/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.logging.OpenShiftLoggingHandler;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.containers.ContainerManagedResourceBuilder;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class OpenShiftContainerManagedResource
implements ManagedResource {
    private static final String DEPLOYMENT_SERVICE_PROPERTY = "openshift.service";
    private static final String DEPLOYMENT_TEMPLATE_PROPERTY = "openshift.template";
    private static final String USE_INTERNAL_SERVICE_AS_URL_PROPERTY = "openshift.use-internal-service-as-url";
    private static final String DEPLOYMENT_TEMPLATE_PROPERTY_DEFAULT = "/openshift-deployment-template.yml";
    private static final String DEPLOYMENT = "openshift.yml";
    private static final int HTTP_PORT = 80;
    private final ContainerManagedResourceBuilder model;
    private final OpenShiftClient client;
    private LoggingHandler loggingHandler;
    private boolean running;

    protected OpenShiftContainerManagedResource(ContainerManagedResourceBuilder model) {
        this.model = model;
        this.client = (OpenShiftClient)model.getContext().get("openshift-client");
    }

    public String getDisplayName() {
        return this.model.getImage();
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.applyDeployment();
        this.exposeService();
        this.client.scaleToWhenDcReady(this.model.getContext().getOwner(), 1);
        this.running = true;
        this.loggingHandler = new OpenShiftLoggingHandler(this.model.getContext());
        this.loggingHandler.startWatching();
    }

    public void stop() {
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 0);
        this.running = false;
    }

    public URILike getURI(Protocol protocol) {
        if (this.useInternalServiceAsUrl()) {
            return this.createURI("http", this.getInternalServiceName(), this.model.getPort());
        }
        return this.client.url(this.model.getContext().getOwner()).withPort(80);
    }

    public boolean isRunning() {
        return this.loggingHandler != null && this.loggingHandler.logsContains(this.model.getExpectedLog());
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    public void restart() {
        this.stop();
        this.start();
    }

    protected void exposeService() {
        if (!this.useInternalServiceAsUrl()) {
            this.client.expose(this.model.getContext().getOwner(), (int)this.model.getPort());
        }
    }

    protected String getTemplateByDefault() {
        return DEPLOYMENT_TEMPLATE_PROPERTY_DEFAULT;
    }

    protected boolean useInternalServiceByDefault() {
        return false;
    }

    protected String getInternalServiceName() {
        return this.model.getContext().getName();
    }

    protected OpenShiftClient getClient() {
        return this.client;
    }

    protected String replaceDeploymentContent(String content) {
        String customServiceName = this.model.getContext().getOwner().getConfiguration().get(DEPLOYMENT_SERVICE_PROPERTY);
        if (StringUtils.isNotEmpty((CharSequence)customServiceName)) {
            content = content.replaceAll(Pattern.quote(customServiceName), this.model.getContext().getOwner().getName());
        }
        return content.replaceAll(Pattern.quote("${IMAGE}"), this.model.getImage()).replaceAll(Pattern.quote("${SERVICE_NAME}"), this.model.getContext().getName()).replaceAll(Pattern.quote("${INTERNAL_PORT}"), "" + this.model.getPort()).replaceAll(Pattern.quote("${ARGS}"), String.join((CharSequence)" ", this.model.getCommand()));
    }

    private void applyDeployment() {
        String deploymentFile = this.model.getContext().getOwner().getConfiguration().getOrDefault(DEPLOYMENT_TEMPLATE_PROPERTY, this.getTemplateByDefault());
        this.client.applyServicePropertiesUsingTemplate(this.model.getContext().getOwner(), deploymentFile, this::replaceDeploymentContent, this.model.getContext().getServiceFolder().resolve(DEPLOYMENT));
    }

    private boolean useInternalServiceAsUrl() {
        return Boolean.TRUE.toString().equals(this.model.getContext().getOwner().getConfiguration().getOrDefault(USE_INTERNAL_SERVICE_AS_URL_PROPERTY, "" + this.useInternalServiceByDefault()));
    }
}

