/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.services.quarkus.ArtifactQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.TemplateOpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.model.QuarkusProperties;
import io.quarkus.test.utils.Command;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public class BuildOpenShiftQuarkusApplicationManagedResource
extends TemplateOpenShiftQuarkusApplicationManagedResource<ArtifactQuarkusApplicationManagedResourceBuilder> {
    private static final String S2I_DEFAULT_VERSION = "latest";
    private static final String QUARKUS_OPENSHIFT_TEMPLATE = "/quarkus-build-openshift-template.yml";
    private static final String IMAGE_TAG_SEPARATOR = ":";

    public BuildOpenShiftQuarkusApplicationManagedResource(ArtifactQuarkusApplicationManagedResourceBuilder model) {
        super(model);
    }

    @Override
    protected String getDefaultTemplate() {
        return QUARKUS_OPENSHIFT_TEMPLATE;
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.startBuild();
        this.exposeServices();
    }

    @Override
    protected String replaceDeploymentContent(String content) {
        String s2iImage = this.getS2iImage();
        String s2iVersion = this.getS2iImageVersion(s2iImage);
        return content.replaceAll(Pattern.quote("${QUARKUS_S2I_IMAGE_BUILDER}"), StringUtils.substringBeforeLast((String)s2iImage, (String)IMAGE_TAG_SEPARATOR)).replaceAll(Pattern.quote("${QUARKUS_S2I_IMAGE_BUILDER_VERSION}"), s2iVersion).replaceAll(Pattern.quote("${ARTIFACT}"), ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().getFileName().toString());
    }

    private void exposeServices() {
        this.client.expose(((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner(), 8080);
        this.client.expose(((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getName() + "-management", ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getManagementPort());
    }

    private void startBuild() {
        String fromArg = "--from-dir=" + ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().toAbsolutePath().getParent().toString();
        if (this.isNativeTest()) {
            fromArg = "--from-file=" + ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().toAbsolutePath();
        }
        try {
            new Command(new String[]{"oc", "start-build", ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getName(), fromArg, "--follow"}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed when starting build. Caused by " + e.getMessage()));
        }
    }

    private String getS2iImageVersion(String s2iImage) {
        String s2iVersion = S2I_DEFAULT_VERSION;
        if (s2iImage.contains(IMAGE_TAG_SEPARATOR)) {
            s2iVersion = StringUtils.substringAfterLast((String)s2iImage, (String)IMAGE_TAG_SEPARATOR);
        }
        return s2iVersion;
    }

    private String getS2iImage() {
        PropertyLookup s2iImageProperty = this.isNativeTest() ? QuarkusProperties.QUARKUS_NATIVE_S2I : QuarkusProperties.QUARKUS_JVM_S2I;
        return ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getProperty(s2iImageProperty.getPropertyKey()).orElseGet(() -> s2iImageProperty.get(((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext()));
    }
}

