/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.scenarios.annotations.DisabledOnQuarkusSnapshotCondition;
import io.quarkus.test.services.quarkus.GitRepositoryQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.TemplateOpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.model.QuarkusProperties;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public class OpenShiftS2iGitRepositoryQuarkusApplicationManagedResource
extends TemplateOpenShiftQuarkusApplicationManagedResource<GitRepositoryQuarkusApplicationManagedResourceBuilder> {
    private static final String QUARKUS_SOURCE_S2I_BUILD_TEMPLATE_FILENAME = "/quarkus-s2i-source-build-template.yml";
    private static final String QUARKUS_SOURCE_S2I_SETTINGS_MVN_FILENAME = "settings-mvn.yml";
    private static final String INTERNAL_MAVEN_REPOSITORY_PROPERTY = "${internal.s2i.maven.remote.repository}";
    private static final PropertyLookup MAVEN_REMOTE_REPOSITORY = new PropertyLookup("s2i.maven.remote.repository");
    private static final PropertyLookup QUARKUS_NATIVE_S2I_FROM_SRC = new PropertyLookup("s2i.openshift.base-native-image", "quay.io/quarkus/ubi-quarkus-graalvmce-s2i:jdk-17");
    private final GitRepositoryQuarkusApplicationManagedResourceBuilder model;

    public OpenShiftS2iGitRepositoryQuarkusApplicationManagedResource(GitRepositoryQuarkusApplicationManagedResourceBuilder model) {
        super(model);
        this.model = model;
    }

    public void validate() {
        super.validate();
        if (this.model.isDevMode()) {
            Assertions.fail((String)"DEV mode is not supported when using GIT repositories on OpenShift deployments");
        }
        if (DisabledOnQuarkusSnapshotCondition.isQuarkusSnapshotVersion() && StringUtils.isEmpty((CharSequence)MAVEN_REMOTE_REPOSITORY.get(this.model.getContext()))) {
            Assertions.fail((String)"s2i can't use the Quarkus 999-SNAPSHOT version if not Maven repository has been provided");
        }
    }

    @Override
    protected String getDefaultTemplate() {
        return QUARKUS_SOURCE_S2I_BUILD_TEMPLATE_FILENAME;
    }

    @Override
    protected void doInit() {
        this.createMavenSettings();
        super.doInit();
        this.client.followBuildConfigLogs(this.model.getContext().getName());
    }

    protected boolean needsBuildArtifact() {
        return false;
    }

    @Override
    protected String replaceDeploymentContent(String content) {
        String quarkusPlatformVersion = QuarkusProperties.getVersion();
        String quarkusS2iBaseImage = this.getQuarkusS2iBaseImage();
        String mavenArgs = this.model.getMavenArgsWithVersion();
        return content.replaceAll(Pattern.quote("${APP_NAME}"), this.model.getContext().getOwner().getName()).replaceAll(Pattern.quote("${QUARKUS_S2I_BUILDER_IMAGE}"), quarkusS2iBaseImage).replaceAll(Pattern.quote("${GIT_URI}"), this.model.getGitRepository()).replaceAll(Pattern.quote("${GIT_REF}"), this.model.getGitBranch()).replaceAll(Pattern.quote("${CONTEXT_DIR}"), this.model.getContextDir()).replaceAll(Pattern.quote("${GIT_MAVEN_ARGS}"), mavenArgs).replaceAll(Pattern.quote("${QUARKUS_PLATFORM_GROUP-ID}"), QuarkusProperties.PLATFORM_GROUP_ID.get()).replaceAll(Pattern.quote("${QUARKUS_PLATFORM_VERSION}"), quarkusPlatformVersion);
    }

    private String getQuarkusS2iBaseImage() {
        PropertyLookup s2iImageProperty = this.isNativeTest() ? QUARKUS_NATIVE_S2I_FROM_SRC : QuarkusProperties.QUARKUS_JVM_S2I;
        return this.model.getContext().getOwner().getProperty(s2iImageProperty.getPropertyKey()).orElseGet(() -> s2iImageProperty.get(this.model.getContext()));
    }

    private void createMavenSettings() {
        Path targetQuarkusSourceS2iSettingsMvnFilename = this.model.getContext().getServiceFolder().resolve(QUARKUS_SOURCE_S2I_SETTINGS_MVN_FILENAME);
        String content = FileUtils.loadFile((String)"/settings-mvn.yml");
        String remoteRepo = MAVEN_REMOTE_REPOSITORY.get(this.model.getContext());
        if (StringUtils.isNotEmpty((CharSequence)remoteRepo)) {
            content = content.replaceAll(Pattern.quote(INTERNAL_MAVEN_REPOSITORY_PROPERTY), remoteRepo);
        }
        FileUtils.copyContentTo((String)content, (Path)targetQuarkusSourceS2iSettingsMvnFilename);
        this.client.apply(targetQuarkusSourceS2iSettingsMvnFilename);
    }
}

