/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.DefaultService;
import io.quarkus.test.bootstrap.ExtensionBootstrap;
import io.quarkus.test.bootstrap.ScenarioContext;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.configuration.Configuration;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.scenarios.OpenShiftScenario;
import io.quarkus.test.services.Operator;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

public class OpenShiftExtensionBootstrap
implements ExtensionBootstrap {
    public static final String CLIENT = "openshift-client";
    private static final PropertyLookup PRINT_INFO_ON_ERROR = new PropertyLookup(Configuration.Property.OPENSHIFT_PRINT_ON_ERROR.getName(), Boolean.TRUE.toString());
    private static final PropertyLookup DELETE_PROJECT_AFTER = new PropertyLookup(Configuration.Property.OPENSHIFT_DELETE_AFTERWARDS.getName(), Boolean.TRUE.toString());
    private OpenShiftClient client;

    public boolean appliesFor(ScenarioContext context) {
        boolean isValidConfig = context.isAnnotationPresent(OpenShiftScenario.class);
        if (isValidConfig && !DELETE_PROJECT_AFTER.getAsBoolean().booleanValue() && OpenShiftClient.ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            Log.error((String)"-Dts.openshift.delete.project.after.all=false is only supported with -Dts.openshift.ephemeral.namespaces.enabled=false", (Object[])new Object[0]);
            isValidConfig = false;
        }
        return isValidConfig;
    }

    public void beforeAll(ScenarioContext context) {
        context.setDebug(DELETE_PROJECT_AFTER.getAsBoolean() == false && OpenShiftClient.ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean() == false);
        this.client = OpenShiftClient.create(context.getId());
        this.installOperators(context);
    }

    public void afterAll(ScenarioContext context) {
        if (DELETE_PROJECT_AFTER.getAsBoolean().booleanValue()) {
            this.client.deleteProject();
        }
    }

    public void updateServiceContext(ServiceContext context) {
        context.put(CLIENT, (Object)this.client);
    }

    public Optional<Object> getParameter(Class<?> clazz) {
        if (clazz == OpenShiftClient.class) {
            return Optional.of(this.client);
        }
        return Optional.empty();
    }

    public void onError(ScenarioContext context, Throwable throwable) {
        if (PRINT_INFO_ON_ERROR.getAsBoolean().booleanValue()) {
            FileUtils.createDirectoryIfDoesNotExist((Path)this.logsTestFolder(context));
            this.printStatus(context);
            this.printEvents(context);
            this.printPodLogs(context);
        }
    }

    private void printEvents(ScenarioContext context) {
        FileUtils.copyContentTo((String)this.client.getEvents(), (Path)this.logsTestFolder(context).resolve("events.log"));
    }

    private void printStatus(ScenarioContext context) {
        FileUtils.copyContentTo((String)this.client.getStatus(), (Path)this.logsTestFolder(context).resolve("status.log"));
    }

    private void printPodLogs(ScenarioContext context) {
        Map<String, String> logs = this.client.logs();
        for (Map.Entry<String, String> podLog : logs.entrySet()) {
            FileUtils.copyContentTo((String)podLog.getValue(), (Path)this.logsTestFolder(context).resolve(podLog.getKey() + ".log"));
        }
    }

    private Path logsTestFolder(ScenarioContext context) {
        return context.getLogFolder().resolve(context.getRunningTestClassName());
    }

    private void installOperators(ScenarioContext context) {
        OpenShiftScenario openShiftScenario = (OpenShiftScenario)context.getAnnotation(OpenShiftScenario.class);
        for (Operator operator : openShiftScenario.operators()) {
            DefaultService defaultService = new DefaultService();
            defaultService.register(operator.name(), context);
            this.client.installOperator((Service)defaultService, operator.name(), operator.channel(), operator.source(), operator.sourceNamespace());
        }
    }
}

