/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.model;

import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;

public class CustomVolume {
    private final Volume volume;
    private final String name;
    private final String subFolderRegExp;
    private ConfigMapVolumeSource configMap;
    private SecretVolumeSource secret;

    public CustomVolume(String name, String subFolderRegExp, VolumeType volumeType) {
        this.subFolderRegExp = subFolderRegExp;
        this.name = name;
        VolumeBuilder vBuilder = (VolumeBuilder)new VolumeBuilder().withName(name);
        if (volumeType.equals((Object)VolumeType.CONFIG_MAP)) {
            this.configMap = ((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(name)).build();
            vBuilder = (VolumeBuilder)vBuilder.withConfigMap(this.configMap);
        } else {
            this.secret = ((SecretVolumeSourceBuilder)new SecretVolumeSourceBuilder().withSecretName(name)).build();
            vBuilder = (VolumeBuilder)vBuilder.withSecret(this.secret);
        }
        this.volume = vBuilder.build();
    }

    public Volume getVolume() {
        return this.volume;
    }

    public String getName() {
        return this.name;
    }

    public ConfigMapVolumeSource getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(ConfigMapVolumeSource configMap) {
        this.configMap = configMap;
    }

    public SecretVolumeSource getSecret() {
        return this.secret;
    }

    public void setSecret(SecretVolumeSource secret) {
        this.secret = secret;
    }

    public String getSubFolderRegExp() {
        return this.subFolderRegExp;
    }

    public static enum VolumeType {
        CONFIG_MAP,
        SECRET;

    }
}

