/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.openshift.utils;

import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.security.certificate.ServingCertificateConfig;
import io.quarkus.test.services.URILike;
import java.util.random.RandomGenerator;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public final class OpenShiftPropertiesUtils {
    public static final int EXTERNAL_SSL_PORT = 443;
    public static final String CA_BUNDLE_CONFIGMAP_NAME = "ca-bundle-configmap";
    public static final String SERVING_CERTS_SECRET_NAME = "serving-certificates-secret";
    private static final String ANNOTATION_PREFIX = "annotation::";
    private static final String ANNOTATION_SEPARATOR = "|";
    private static final String MOUNT_SECRET_PREFIX = "mount-secret::";
    private static final String MOUNT_SECRET_SEPARATOR = "|";
    private static final String MOUNT_CONFIGMAP_PREFIX = "mount-configmap::";
    private static final String MOUNT_CONFIGMAP_SEPARATOR = "|";
    private static final String ANNOTATED_CONFIG_MAP_PREFIX = "annotated-configmap::";
    private static final String ANNOTATED_CONFIG_MAP_SEPARATOR = "|";
    private static final String ANNOTATED_CONFIG_ANNOTATION_SEPARATOR = "&";
    private static final int INTERNAL_HTTPS_PORT_DEFAULT = 8443;
    private static final String QUARKUS_HTTPS_PORT_PROPERTY = "quarkus.http.ssl-port";

    private OpenShiftPropertiesUtils() {
    }

    public static String buildAnnotatedConfigMapProp(String configmapName, String annotationKey, String annotationVal) {
        return ANNOTATED_CONFIG_MAP_PREFIX + configmapName + "|" + annotationKey + ANNOTATED_CONFIG_ANNOTATION_SEPARATOR + annotationVal;
    }

    public static String buildMountConfigMapProp(String secretName, String secretValue) {
        return MOUNT_CONFIGMAP_PREFIX + secretName + "|" + secretValue;
    }

    public static String buildMountSecretProp(String secretName, String secretValue) {
        return MOUNT_SECRET_PREFIX + secretName + "|" + secretValue;
    }

    public static String buildAnnotationProp(String annotationName, String annotationValue) {
        return ANNOTATION_PREFIX + annotationName + "|" + annotationValue;
    }

    public static boolean isMountSecret(String propertyValue) {
        return propertyValue.startsWith(MOUNT_SECRET_PREFIX);
    }

    public static boolean isMountConfigMap(String propertyValue) {
        return propertyValue.startsWith(MOUNT_CONFIGMAP_PREFIX);
    }

    public static boolean isAnnotatedConfigMap(String propertyValue) {
        return propertyValue.startsWith(ANNOTATED_CONFIG_MAP_PREFIX);
    }

    public static boolean isAnnotation(String propertyValue) {
        return propertyValue.startsWith(ANNOTATION_PREFIX);
    }

    public static String createAnnotationPropertyKey() {
        return OpenShiftPropertiesUtils.createRandomPropertyKeyWithPrefix("annotation-");
    }

    public static String createSecretPropertyKey() {
        return OpenShiftPropertiesUtils.createRandomPropertyKeyWithPrefix("secret-");
    }

    public static String createConfigMapPropertyKey() {
        return OpenShiftPropertiesUtils.createRandomPropertyKeyWithPrefix("configmap-");
    }

    public static String createAnnotatedConfigMapPropertyKey() {
        return OpenShiftPropertiesUtils.createRandomPropertyKeyWithPrefix("annotated-configmap-");
    }

    public static PropertyToValue getMountConfigMap(String propertyValue) {
        return OpenShiftPropertiesUtils.getPropertyToValue(propertyValue, MOUNT_CONFIGMAP_PREFIX, "|", "configmap");
    }

    public static PropertyToValue getMountSecret(String propertyValue) {
        return OpenShiftPropertiesUtils.getPropertyToValue(propertyValue, MOUNT_SECRET_PREFIX, "|", "secret");
    }

    public static PropertyToValue getServiceAnnotation(String propertyValue) {
        return OpenShiftPropertiesUtils.getPropertyToValue(propertyValue, ANNOTATION_PREFIX, "|", "annotation");
    }

    public static PropertyToObj getAnnotatedConfigMap(String propertyValue) {
        PropertyToValue configMapNameToAnnotation = OpenShiftPropertiesUtils.getPropertyToValue(propertyValue, ANNOTATED_CONFIG_MAP_PREFIX, "|", "annotated-configmap");
        PropertyToValue annotationKeyToValue = OpenShiftPropertiesUtils.getPropertyToValue(configMapNameToAnnotation.value(), "", ANNOTATED_CONFIG_ANNOTATION_SEPARATOR, "annotation-configmap-annotation");
        return new PropertyToObj(configMapNameToAnnotation.key(), annotationKeyToValue);
    }

    public static boolean checkPodReadinessWithStatusInsteadOfRoute(ServiceContext ctx) {
        return ServingCertificateConfig.isServingCertificateScenario((ServiceContext)ctx) && ServingCertificateConfig.get((ServiceContext)ctx).addServiceCertificate();
    }

    public static int getInternalHttpsPort(ServiceContext ctx) {
        return ctx.getOwner().getProperty(QUARKUS_HTTPS_PORT_PROPERTY).filter(StringUtils::isNotBlank).map(Integer::parseInt).orElse(8443);
    }

    public static URILike getInternalServiceHttpsUrl(ServiceContext ctx) {
        String serviceName = ctx.getOwner().getName();
        String projectName = ((OpenShiftClient)ctx.get("openshift-client")).project();
        String host = "%s.%s.svc.cluster.local".formatted(serviceName, projectName);
        return new URILike(Protocol.HTTPS.getValue(), host, OpenShiftPropertiesUtils.getInternalHttpsPort(ctx), "");
    }

    private static PropertyToValue getPropertyToValue(String propertyValue, String prefix, String separator, String subject) {
        String keyToVal = propertyValue.replace(prefix, "");
        int separatorIdx = keyToVal.indexOf(separator);
        if (separatorIdx == -1) {
            Assertions.fail((String)"Configuration property defining OpenShift '%s' is missing key to value separator '%s'".formatted(subject, separatorIdx));
        }
        String key = keyToVal.substring(0, separatorIdx);
        String value = keyToVal.substring(separatorIdx + 1);
        return new PropertyToValue(key, value);
    }

    private static String createRandomPropertyKeyWithPrefix(String x) {
        RandomGenerator generator = RandomGenerator.getDefault();
        return x + generator.nextInt() + "-" + generator.nextInt();
    }

    public record PropertyToValue(String key, String value) {
    }

    public record PropertyToObj(String key, PropertyToValue value) {
    }
}

