/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.bootstrap.inject.OpenShiftUtils;
import io.quarkus.test.configuration.Configuration;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.logging.OpenShiftLoggingHandler;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.containers.ContainerManagedResourceBuilder;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class OpenShiftContainerManagedResource
implements ManagedResource {
    private static final String DEPLOYMENT_TEMPLATE_PROPERTY_DEFAULT = "/openshift-deployment-template.yml";
    private static final String DEPLOYMENT = "openshift.yml";
    private static final int HTTP_PORT = 80;
    private final ContainerManagedResourceBuilder model;
    private final OpenShiftClient client;
    private LoggingHandler loggingHandler;
    private boolean running;

    protected OpenShiftContainerManagedResource(ContainerManagedResourceBuilder model) {
        this.model = model;
        this.client = (OpenShiftClient)model.getContext().get("openshift-client");
    }

    public String getDisplayName() {
        return this.model.getImage();
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.applyDeployment();
        this.exposeService();
        this.client.scaleTo(this.model.getContext().getOwner(), 1);
        this.running = true;
        this.loggingHandler = new OpenShiftLoggingHandler(this.model.getContext());
        this.loggingHandler.startWatching();
    }

    public void stop() {
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 0);
        this.running = false;
    }

    public URILike getURI(Protocol protocol) {
        if (this.useInternalServiceAsUrl()) {
            return this.createURI("http", this.getInternalServiceName(), this.model.getPort());
        }
        return this.client.url(this.model.getContext().getOwner()).withPort(80);
    }

    public boolean isRunning() {
        return this.loggingHandler != null && this.loggingHandler.logsContains(this.model.getExpectedLog());
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    public void restart() {
        this.stop();
        this.start();
    }

    protected void exposeService() {
        if (!this.useInternalServiceAsUrl()) {
            this.client.expose(this.model.getContext().getOwner(), (int)this.model.getPort());
        }
    }

    protected String getTemplateByDefault() {
        return DEPLOYMENT_TEMPLATE_PROPERTY_DEFAULT;
    }

    protected boolean useInternalServiceByDefault() {
        return false;
    }

    protected String getInternalServiceName() {
        return this.model.getContext().getName();
    }

    protected OpenShiftClient getClient() {
        return this.client;
    }

    private Configuration getConfiguration() {
        return this.model.getContext().getOwner().getConfiguration();
    }

    protected String replaceDeploymentContent(String content) {
        String customServiceName = this.getConfiguration().get(Configuration.Property.OPENSHIFT_DEPLOYMENT_SERVICE_PROPERTY);
        if (StringUtils.isNotEmpty((CharSequence)customServiceName)) {
            content = content.replaceAll(Pattern.quote(customServiceName), this.model.getContext().getOwner().getName());
        }
        String args = Arrays.stream(this.model.getCommand()).map(cmd -> "\"" + cmd + "\"").collect(Collectors.joining(", "));
        return content.replaceAll(Pattern.quote("${IMAGE}"), this.model.getImage()).replaceAll(Pattern.quote("${SERVICE_NAME}"), this.model.getContext().getName()).replaceAll(Pattern.quote("${INTERNAL_PORT}"), "" + this.model.getPort()).replaceAll(Pattern.quote("${INTERNAL_INGRESS_PORT}"), "" + this.model.getPort()).replaceAll(Pattern.quote("${ARGS}"), args).replaceAll(Pattern.quote("${CURRENT_NAMESPACE}"), this.client.project());
    }

    private void applyDeployment() {
        String deploymentFile = this.getConfiguration().getOrDefault(Configuration.Property.OPENSHIFT_DEPLOYMENT_TEMPLATE_PROPERTY, this.getTemplateByDefault());
        Path templateFile = this.model.getContext().getServiceFolder().resolve(DEPLOYMENT);
        this.client.applyServicePropertiesUsingTemplate(this.model.getContext().getOwner(), deploymentFile, this::replaceDeploymentContent, templateFile);
        List<HasMetadata> metadata = this.client.loadYamlFromFile(templateFile);
        Deployment deployment = OpenShiftUtils.getDeployment(metadata).orElseThrow();
        for (ContainerManagedResourceBuilder.MountConfig mount : this.model.getMounts()) {
            this.client.addMount(deployment, mount.from, mount.to);
        }
        String yaml = OpenShiftUtils.toYaml(metadata);
        this.client.apply(FileUtils.copyContentTo((String)yaml, (Path)templateFile));
    }

    private boolean useInternalServiceAsUrl() {
        return Boolean.TRUE.toString().equals(this.getConfiguration().getOrDefault(Configuration.Property.OPENSHIFT_USE_INTERNAL_SERVICE_AS_URL_PROPERTY, "" + this.useInternalServiceByDefault()));
    }
}

