/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.logging.LoggingHandler;
import io.quarkus.test.logging.OpenShiftLoggingHandler;
import io.quarkus.test.openshift.utils.OpenShiftPropertiesUtils;
import io.quarkus.test.security.certificate.ServingCertificateConfig;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.quarkus.QuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.QuarkusManagedResource;
import io.quarkus.test.utils.AwaitilityUtils;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.List;
import org.junit.jupiter.api.Assertions;

public abstract class OpenShiftQuarkusApplicationManagedResource<T extends QuarkusApplicationManagedResourceBuilder>
extends QuarkusManagedResource {
    private static final int EXTERNAL_PORT = 80;
    protected final T model;
    protected final OpenShiftClient client;
    private LoggingHandler loggingHandler;
    private boolean init;
    private boolean running;
    private URILike uri;

    public OpenShiftQuarkusApplicationManagedResource(T model) {
        super(model.getContext());
        this.model = model;
        this.client = (OpenShiftClient)model.getContext().get("openshift-client");
        this.configureServingCertificates();
    }

    protected abstract void doInit();

    protected abstract void doUpdate();

    public void start() {
        if (this.running) {
            return;
        }
        if (!this.init) {
            this.doInit();
            this.init = true;
        } else {
            this.doUpdate();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 1);
        this.running = true;
        this.loggingHandler = new OpenShiftLoggingHandler(this.model.getContext());
        this.loggingHandler.startWatching();
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        if (this.loggingHandler != null) {
            this.loggingHandler.stopWatching();
        }
        this.client.scaleTo(this.model.getContext().getOwner(), 0);
        this.uri = null;
        this.running = false;
    }

    public URILike getURI(Protocol protocol) {
        boolean isServingCertSslScenario;
        ServiceContext context = this.model.getContext();
        boolean isServerless = this.client.isServerlessService(context.getName());
        boolean bl = isServingCertSslScenario = ServingCertificateConfig.isServingCertificateScenario((ServiceContext)context) && this.model.isSslEnabled();
        if (protocol == Protocol.HTTPS && !isServerless && !isServingCertSslScenario) {
            Assertions.fail((String)"SSL is not supported for OpenShift tests yet");
        } else if (protocol == Protocol.GRPC) {
            Assertions.fail((String)"gRPC is not supported for OpenShift tests yet");
        } else if (protocol == Protocol.MANAGEMENT && this.model.useSeparateManagementInterface()) {
            if (this.model.useManagementSsl()) {
                Assertions.fail((String)"SSL is not supported for OpenShift tests yet");
            }
            return this.client.url(context.getOwner().getName() + "-management").withPort(80);
        }
        if (this.uri == null) {
            if (isServingCertSslScenario) {
                this.uri = OpenShiftPropertiesUtils.getInternalServiceHttpsUrl(context);
                return this.uri;
            }
            int port = isServerless ? 443 : 80;
            this.uri = (URILike)AwaitilityUtils.untilIsNotNull(() -> this.client.url(context.getOwner()).withPort(port), (AwaitilityUtils.AwaitilitySettings)AwaitilityUtils.AwaitilitySettings.defaults().withService(this.getContext().getOwner()));
        }
        return this.uri;
    }

    public boolean isRunning() {
        if (!this.running) {
            return false;
        }
        if (this.client.isServerlessService(this.model.getContext().getName())) {
            return this.routeIsReachable(Protocol.HTTPS);
        }
        if (OpenShiftPropertiesUtils.checkPodReadinessWithStatusInsteadOfRoute(this.model.getContext())) {
            String serviceName = this.model.getContext().getOwner().getName();
            return super.isRunning() && this.client.isAnyServicePodReady(serviceName);
        }
        return super.isRunning() && this.routeIsReachable(Protocol.HTTP);
    }

    public List<String> logs() {
        return this.loggingHandler.logs();
    }

    public void restart() {
        this.stop();
        if (this.model.buildPropertiesChanged()) {
            this.init = false;
            this.model.build();
        }
        this.start();
    }

    protected LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    private boolean routeIsReachable(Protocol protocol) {
        URILike url = this.getURI(protocol);
        return ((Response)RestAssured.given().relaxedHTTPSValidation().baseUri(url.getRestAssuredStyleUri()).basePath("/").port(url.getPort()).get()).getStatusCode() != 503;
    }

    private void configureServingCertificates() {
        ServiceContext ctx = this.model.getContext();
        if (ServingCertificateConfig.isServingCertificateScenario((ServiceContext)ctx)) {
            String annotationKey;
            String annotationVal;
            ServingCertificateConfig config = ServingCertificateConfig.get((ServiceContext)ctx);
            if (config.addServiceCertificate()) {
                annotationVal = OpenShiftPropertiesUtils.buildAnnotationProp("service.beta.openshift.io/serving-cert-secret-name", "serving-certificates-secret");
                annotationKey = OpenShiftPropertiesUtils.createAnnotationPropertyKey();
                ctx.withTestScopeConfigProperty(annotationKey, annotationVal);
                String mountSecretVal = OpenShiftPropertiesUtils.buildMountSecretProp("serving-certificates-secret", "/etc/tls");
                String mountSecretKey = OpenShiftPropertiesUtils.createSecretPropertyKey();
                ctx.withTestScopeConfigProperty(mountSecretKey, mountSecretVal);
                if (config.tlsConfigName() == null) {
                    ctx.withTestScopeConfigProperty("quarkus.tls.key-store.pem.acme.cert", "/etc/tls/tls.crt");
                    ctx.withTestScopeConfigProperty("quarkus.tls.key-store.pem.acme.key", "/etc/tls/tls.key");
                } else {
                    ctx.withTestScopeConfigProperty("quarkus.tls." + config.tlsConfigName() + ".key-store.pem.acme.cert", "/etc/tls/tls.crt");
                    ctx.withTestScopeConfigProperty("quarkus.tls." + config.tlsConfigName() + ".key-store.pem.acme.key", "/etc/tls/tls.key");
                    ctx.withTestScopeConfigProperty("quarkus.http.tls-configuration-name", config.tlsConfigName());
                }
            }
            if (config.injectCABundle()) {
                annotationVal = "true";
                annotationKey = "service.beta.openshift.io/inject-cabundle";
                String annotatedConfigMapVal = OpenShiftPropertiesUtils.buildAnnotatedConfigMapProp("ca-bundle-configmap", annotationKey, annotationVal);
                String annotatedConfigMapKey = OpenShiftPropertiesUtils.createAnnotatedConfigMapPropertyKey();
                ctx.withTestScopeConfigProperty(annotatedConfigMapKey, annotatedConfigMapVal);
                String caCertDirPath = "/deployments/tls";
                String mountConfigMapVal = OpenShiftPropertiesUtils.buildMountConfigMapProp("ca-bundle-configmap", caCertDirPath);
                String mountConfigMapKey = OpenShiftPropertiesUtils.createConfigMapPropertyKey();
                ctx.withTestScopeConfigProperty(mountConfigMapKey, mountConfigMapVal);
                String caCertPath = caCertDirPath + "/service-ca.crt";
                if (config.tlsConfigName() == null) {
                    ctx.withTestScopeConfigProperty("quarkus.tls.trust-store.pem.certs", caCertPath);
                } else {
                    ctx.withTestScopeConfigProperty("quarkus.tls." + config.tlsConfigName() + ".trust-store.pem.certs", caCertPath);
                }
            }
        }
    }
}

