/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap.inject;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.serving.v1.Route;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroup;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpec;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersion;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionSpec;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.impl.OpenShiftClientImpl;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.bootstrap.inject.OpenShiftUtils;
import io.quarkus.test.configuration.Configuration;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.model.CustomVolume;
import io.quarkus.test.openshift.utils.OpenShiftPropertiesUtils;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.operator.model.CustomResourceStatus;
import io.quarkus.test.services.quarkus.model.QuarkusProperties;
import io.quarkus.test.utils.AwaitilityUtils;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.PropertiesUtils;
import io.smallrye.config.common.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

public final class OpenShiftClient {
    public static final String LABEL_TO_WATCH_FOR_LOGS = "tsLogWatch";
    public static final String LABEL_SCENARIO_ID = "scenarioId";
    public static final PropertyLookup ENABLED_EPHEMERAL_NAMESPACES = new PropertyLookup(Configuration.Property.OPENSHIFT_EPHEMERAL_NAMESPACES.getName(), Boolean.TRUE.toString());
    private static final Logger LOG = Logger.getLogger(OpenShiftClient.class);
    private static final Duration TIMEOUT_DEFAULT = Duration.ofMinutes(5L);
    private static final int PROJECT_NAME_SIZE = 10;
    private static final int PROJECT_CREATION_RETRIES = 5;
    private static final int SPECS_SECRET_NAME_LIMIT = 63;
    private static final String OPERATOR_PHASE_INSTALLED = "Succeeded";
    private static final String BUILD_FAILED_STATUS = "Failed";
    private static final String CUSTOM_RESOURCE_EXPECTED_TYPE = "Ready";
    private static final String CUSTOM_RESOURCE_EXPECTED_STATUS = "True";
    private static final String RESOURCE_MNT_FOLDER = "/resources";
    private static final String APP_PROPS_CONFIG_MAP_KEY = "application-properties";
    private static final String OC = "oc";
    private final String currentNamespace;
    private final OpenShiftClientImpl client;
    private final KnativeClient kn;
    private final String scenarioId;
    private boolean isClientReady;

    private OpenShiftClient(String scenarioId) {
        this.scenarioId = scenarioId;
        if (ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            this.currentNamespace = this.createProject();
            OpenShiftConfig config = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withTrustCerts(true)).withNamespace(this.currentNamespace)).build();
            this.client = OpenShiftClient.createClient(config);
        } else {
            OpenShiftConfig config = ((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withTrustCerts(true)).build();
            this.client = OpenShiftClient.createClient(config);
            this.currentNamespace = this.client.getNamespace();
        }
        this.isClientReady = true;
        this.kn = (KnativeClient)this.client.adapt(KnativeClient.class);
    }

    private static OpenShiftClientImpl createClient(OpenShiftConfig config) {
        return (OpenShiftClientImpl)((NamespacedOpenShiftClient)new KubernetesClientBuilder().withConfig((Config)config).build().adapt(NamespacedOpenShiftClient.class)).adapt(OpenShiftClientImpl.class);
    }

    public static OpenShiftClient create(String scenarioId) {
        return new OpenShiftClient(scenarioId);
    }

    public String project() {
        return this.currentNamespace;
    }

    public void apply(Path file) {
        this.applyInProject(file, this.currentNamespace);
    }

    public void applyInProject(Path file, String project) {
        try {
            new Command(new String[]{OC, "apply", "-f", file.toAbsolutePath().toString(), "-n", project}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to apply resource " + String.valueOf(file.toAbsolutePath()) + " . Caused by " + e.getMessage()));
        }
    }

    public void delete(Path file) {
        this.deleteInProject(file, this.currentNamespace);
    }

    public void deleteInProject(Path file, String project) {
        try {
            new Command(new String[]{OC, "delete", "-f", file.toAbsolutePath().toString(), "-n", project}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to apply resource " + String.valueOf(file.toAbsolutePath()) + " . Caused by " + e.getMessage()));
        }
    }

    public void applyServicePropertiesUsingTemplate(Service service, String file, UnaryOperator<String> update, Path target) {
        this.applyServicePropertiesUsingTemplate(service, file, update, Collections.emptyMap(), target);
    }

    public void applyServicePropertiesUsingTemplate(Service service, String file, UnaryOperator<String> update, Map<String, String> extraTemplateProperties, Path target) {
        Log.info((String)"Enriching template %s to create a deployment file %s ", (Object[])new Object[]{file, target});
        String content = FileUtils.loadFile((String)file);
        content = this.enrichTemplate(service, (String)update.apply(content), extraTemplateProperties);
        this.apply(FileUtils.copyContentTo((String)content, (Path)target));
    }

    public List<HasMetadata> loadYamlFromFile(Path file) {
        String content = FileUtils.loadFile((File)file.toFile());
        return this.loadYaml(content);
    }

    public void applyServicePropertiesToDeployment(Service service) {
        String serviceName = service.getName();
        Deployment deployment = (Deployment)((RollableScalableResource)this.client.apps().deployments().withName(serviceName)).get();
        boolean isQuarkusRuntime = OpenShiftClient.isQuarkusRuntime(deployment.getSpec().getTemplate().getMetadata().getLabels());
        Map<String, String> enrichProperties = this.enrichProperties(service.getProperties(), deployment, isQuarkusRuntime);
        if (isQuarkusRuntime) {
            this.updateAnnotationsIfNecessary(service, serviceName);
        }
        deployment.getSpec().getTemplate().getSpec().getContainers().forEach(container -> enrichProperties.forEach((key, value) -> container.getEnv().add(new EnvVar(key, value, null))));
        ((RollableScalableResource)this.client.apps().deployments().resource((Object)deployment)).unlock().createOr(EditReplacePatchable::patch);
    }

    private void updateAnnotationsIfNecessary(Service service, String serviceName) {
        List<OpenShiftPropertiesUtils.PropertyToValue> annotations = OpenShiftClient.collectAnnotations(service);
        if (!annotations.isEmpty()) {
            ServiceResource k8ServiceResource = (ServiceResource)this.client.services().withName(serviceName);
            AwaitilityUtils.untilIsNotNull(() -> ((ServiceResource)k8ServiceResource).get());
            io.fabric8.kubernetes.api.model.Service k8Service = (io.fabric8.kubernetes.api.model.Service)k8ServiceResource.get();
            boolean edited = false;
            for (OpenShiftPropertiesUtils.PropertyToValue keyToVal : annotations) {
                String annotationName = keyToVal.key();
                if (k8Service.getMetadata().getAnnotations().containsKey(annotationName)) continue;
                k8Service = ((ServiceBuilder)((ServiceFluent.MetadataNested)k8Service.edit().editMetadata().addToAnnotations(annotationName, keyToVal.value())).endMetadata()).build();
                edited = true;
            }
            if (edited) {
                k8ServiceResource.patch((Object)k8Service);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public void rollout(Service service) {
        Log.info((String)("Rolling out deployment " + service.getName() + " in namespace " + this.currentNamespace), (Object[])new Object[0]);
        Log.info((String)("Run this command to replicate: oc rollout latest dc/" + service.getName() + " -n " + this.currentNamespace), (Object[])new Object[0]);
        Log.info((String)("deployment/" + service.getName() + " rolled out."), (Object[])new Object[0]);
    }

    public void expose(Service service, int port) {
        this.expose(service.getName(), port);
    }

    public void expose(String serviceName, int port) {
        io.fabric8.openshift.api.model.Route route = (io.fabric8.openshift.api.model.Route)((Resource)this.client.routes().withName(serviceName)).get();
        if (route != null) {
            return;
        }
        try {
            new Command(new String[]{OC, "expose", "svc/" + serviceName, "--port=" + port, "-n", this.currentNamespace, "-lscenarioId=" + this.getScenarioId()}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be exposed. Caused by " + e.getMessage()));
        }
    }

    public void expose(String serviceName, String routeName, int port) {
        io.fabric8.openshift.api.model.Route route = (io.fabric8.openshift.api.model.Route)((Resource)this.client.routes().withName(routeName)).get();
        if (route != null) {
            return;
        }
        try {
            new Command(new String[]{OC, "expose", "svc/" + serviceName, "--port=" + port, "--name=" + routeName, "-n", this.currentNamespace, "-lscenarioId=" + this.getScenarioId()}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be exposed. Caused by " + e.getMessage()));
        }
    }

    public void createService(String appName, String serviceName, int port) {
        io.fabric8.kubernetes.api.model.Service route = (io.fabric8.kubernetes.api.model.Service)((ServiceResource)this.client.services().withName(serviceName)).get();
        if (route != null) {
            return;
        }
        try {
            new Command(new String[]{OC, "expose", "deployment/" + appName, "--port=" + port, "--target-port=" + port, "--name=" + serviceName, "-n", this.currentNamespace, "-lscenarioId=" + this.getScenarioId()}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service was not created. Caused by " + e.getMessage()));
        }
    }

    public void scaleTo(Service service, int replicas) {
        if (this.isServerlessService(service.getName())) {
            return;
        }
        try {
            new Command(new String[]{OC, "scale", "deployment/" + service.getName(), "--replicas=" + replicas, "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Service failed to be scaled. Caused by " + e.getMessage()));
        }
    }

    public void followBuildConfigLogs(String buildConfigName) {
        AwaitilityUtils.untilIsNotNull(() -> ((BuildConfigResource)((BuildConfigResource)this.client.buildConfigs().withName(buildConfigName))).get());
        try {
            new Command(new String[]{OC, "logs", "bc/" + buildConfigName, "--follow", "-n", this.currentNamespace}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Log retrieval from bc failed. Caused by " + e.getMessage()));
        }
        if (this.isBuildFailed(buildConfigName)) {
            Assertions.fail((String)"Build failed");
        }
    }

    public boolean isBuildFailed(String buildConfigName) {
        return ((BuildList)((FilterWatchListDeletable)this.client.builds().withLabel("buildconfig", buildConfigName)).list()).getItems().stream().anyMatch(build -> BUILD_FAILED_STATUS.equals(build.getStatus().getPhase()));
    }

    public int readyReplicas(Service service) {
        Deployment deployment = (Deployment)((RollableScalableResource)this.client.apps().deployments().withName(service.getName())).get();
        return Optional.ofNullable(deployment.getStatus().getReadyReplicas()).orElse(0);
    }

    public List<Pod> podsInService(Service service) {
        return ((PodList)((FilterWatchListDeletable)this.client.pods().withLabel(LABEL_TO_WATCH_FOR_LOGS, service.getName())).list()).getItems();
    }

    public Map<String, String> logs() {
        HashMap<String, String> logs = new HashMap<String, String>();
        for (Pod pod : ((PodList)this.client.pods().list()).getItems()) {
            String podName = pod.getMetadata().getName();
            PodResource resource = (PodResource)this.client.pods().withName(podName);
            for (Container container : pod.getSpec().getContainers()) {
                logs.put(podName + "-" + container.getName(), ((ContainerResource)resource.inContainer((Object)container.getName())).getLog());
            }
        }
        return logs;
    }

    public Map<String, String> logs(Service service) {
        HashMap<String, String> logs = new HashMap<String, String>();
        for (Pod pod : this.podsInService(service)) {
            if (!this.isPodRunning(pod)) continue;
            String podName = pod.getMetadata().getName();
            PodResource resource = (PodResource)this.client.pods().withName(podName);
            for (Container container : pod.getSpec().getContainers()) {
                logs.put(podName + "-" + container.getName(), ((ContainerResource)resource.inContainer((Object)container.getName())).getLog());
            }
        }
        return logs;
    }

    public URILike url(Service service) {
        return this.url(service.getName());
    }

    public URILike url(String serviceName) {
        if (this.isServerlessService(serviceName)) {
            Route knRoute = (Route)((Resource)this.kn.routes().withName(serviceName)).get();
            return URILike.parse((String)knRoute.getStatus().getUrl());
        }
        io.fabric8.openshift.api.model.Route route = (io.fabric8.openshift.api.model.Route)((Resource)this.client.routes().withName(serviceName)).get();
        if (route == null || route.getSpec() == null) {
            Assertions.fail((String)("Route for service " + serviceName + " not found"));
        }
        String protocol = route.getSpec().getTls() == null ? "http" : "https";
        String path = route.getSpec().getPath() == null ? "" : route.getSpec().getPath();
        return new URILike(protocol, route.getSpec().getHost(), -1, path);
    }

    public void awaitFor(Service service, Path file) {
        try {
            List<HasMetadata> objs = this.loadYaml(Files.readString(file));
            for (HasMetadata obj : objs) {
                if (!(obj instanceof ImageStream)) continue;
                ImageStream is = (ImageStream)obj;
                if (StringUtils.equals((CharSequence)obj.getMetadata().getName(), (CharSequence)service.getName())) continue;
                Callable<Boolean> callable = () -> this.hasImageStreamTags(is);
                AwaitilityUtils.AwaitilitySettings.defaults().withService(service);
                AwaitilityUtils.untilIsTrue(callable, (AwaitilityUtils.AwaitilitySettings)AwaitilityUtils.AwaitilitySettings.usingTimeout((Duration)service.getConfiguration().getAsDuration(Configuration.Property.IMAGE_STREAM_TIMEOUT, TIMEOUT_DEFAULT)));
            }
        }
        catch (IOException e) {
            Assertions.fail((String)("Fail to load the file " + String.valueOf(file) + ". Caused by " + e.getMessage()));
        }
    }

    public void installOperator(Service service, String name, String channel, String source, String sourceNamespace) {
        if (!ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            throw new UnsupportedOperationException("Operators not supported with ephemeral namespaces disabled");
        }
        OperatorGroup groupModel = new OperatorGroup();
        groupModel.setMetadata(new ObjectMeta());
        groupModel.getMetadata().setName(service.getName());
        groupModel.setSpec(new OperatorGroupSpec());
        groupModel.getSpec().setTargetNamespaces(Collections.singletonList(this.currentNamespace));
        this.client.resource((HasMetadata)groupModel).unlock().createOr(Updatable::update);
        Subscription subscriptionModel = new Subscription();
        subscriptionModel.setMetadata(new ObjectMeta());
        subscriptionModel.getMetadata().setName(name);
        subscriptionModel.getMetadata().setNamespace(this.currentNamespace);
        subscriptionModel.setSpec(new SubscriptionSpec());
        subscriptionModel.getSpec().setChannel(channel);
        subscriptionModel.getSpec().setName(name);
        subscriptionModel.getSpec().setSource(source);
        subscriptionModel.getSpec().setSourceNamespace(sourceNamespace);
        Log.info((String)"Installing operator... %s", (Object[])new Object[]{service.getName()});
        ((Resource)this.client.operatorHub().subscriptions().resource((Object)subscriptionModel)).create();
        Callable<Boolean> callable = () -> {
            Subscription subscription = (Subscription)((Resource)this.client.operatorHub().subscriptions().withName(name)).get();
            String installedCsv = subscription.getStatus().getInstalledCSV();
            if (StringUtils.isEmpty((CharSequence)installedCsv)) {
                return false;
            }
            ClusterServiceVersion operatorService = (ClusterServiceVersion)((Resource)this.client.operatorHub().clusterServiceVersions().withName(installedCsv)).get();
            return OPERATOR_PHASE_INSTALLED.equals(operatorService.getStatus().getPhase());
        };
        AwaitilityUtils.AwaitilitySettings.defaults().withService(service);
        AwaitilityUtils.untilIsTrue(callable, (AwaitilityUtils.AwaitilitySettings)AwaitilityUtils.AwaitilitySettings.usingTimeout((Duration)service.getConfiguration().getAsDuration(Configuration.Property.OPERATOR_INSTALL_TIMEOUT, TIMEOUT_DEFAULT)));
        Log.info((String)"Operator installed... %s", (Object[])new Object[]{service.getName()});
    }

    public boolean isCustomResourceReady(String name, Class<? extends CustomResource<?, ? extends CustomResourceStatus>> crdType) {
        if (!this.isClientReady) {
            return false;
        }
        CustomResource customResource = (CustomResource)((Resource)this.client.resources(crdType).withName(name)).get();
        if (customResource == null || customResource.getStatus() == null || ((CustomResourceStatus)customResource.getStatus()).getConditions() == null) {
            return false;
        }
        return ((CustomResourceStatus)customResource.getStatus()).getConditions().stream().anyMatch(condition -> CUSTOM_RESOURCE_EXPECTED_TYPE.equals(condition.getType()) && CUSTOM_RESOURCE_EXPECTED_STATUS.equals(condition.getStatus()));
    }

    public String execOnPod(String namespace, String podName, String containerId, String ... input) throws InterruptedException, IOException {
        ArrayList output = new ArrayList();
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(OC, "exec", podName, "-c", containerId, "-n", namespace));
        List<String> command = Arrays.asList(input);
        if (!command.isEmpty()) {
            args.add("--");
            args.addAll(command);
        }
        new Command(args).outputToLines(output).runAndWait();
        return output.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    public boolean isServerlessService(String serviceName) {
        try {
            return ((Resource)this.kn.services().withName(serviceName)).get() != null;
        }
        catch (Exception ex) {
            Log.warn((String)"Failed to check serverless service. Will assume it's not serverless", (Object[])new Object[]{ex});
            return false;
        }
    }

    public String getEvents() {
        ArrayList output = new ArrayList();
        try {
            new Command(new String[]{OC, "get", "events", "-n", this.currentNamespace}).outputToLines(output).runAndWait();
        }
        catch (Exception ex) {
            Log.warn((String)"Failed to get project status", (Object[])new Object[]{ex});
        }
        return output.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    public String getStatus() {
        ArrayList output = new ArrayList();
        try {
            new Command(new String[]{OC, "status", "--suggest", "-n", this.currentNamespace}).outputToLines(output).runAndWait();
        }
        catch (Exception ex) {
            Log.warn((String)"Failed to get project status", (Object[])new Object[]{ex});
        }
        return output.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProject() {
        if (ENABLED_EPHEMERAL_NAMESPACES.getAsBoolean().booleanValue()) {
            try {
                List finalizers;
                Resource projectResource = (Resource)this.client.projects().withName(this.currentNamespace);
                Project project = (Project)projectResource.get();
                if (project == null) {
                    LOG.infof("Skipping delete operation on project '%s' as project does not exists", (Object)this.currentNamespace);
                    return;
                }
                if (project.isMarkedForDeletion()) {
                    LOG.infof("Skipping delete operation on project '%s' as project is already marked for deletion", (Object)this.currentNamespace);
                    return;
                }
                LOG.infof("Deleting project '%s'", (Object)this.currentNamespace);
                if (projectResource.delete().stream().allMatch(Objects::isNull)) {
                    LOG.infof("Project '%s' deleted", (Object)this.currentNamespace);
                    return;
                }
                project = (Project)projectResource.update();
                if (project == null) {
                    LOG.warnf("Deleted project '%s', but behavior of 'io.fabric8.kubernetes.client.dsl.Deletable.delete' has changed, we need to refactor this operation", (Object)this.currentNamespace);
                    return;
                }
                if (!project.isMarkedForDeletion()) {
                    Assertions.fail((String)("Illegal state - project '" + this.currentNamespace + "' should be marked for deletion, please delete project manually"));
                }
                if ((finalizers = project.getFinalizers()) != null && !finalizers.isEmpty()) {
                    LOG.infof("Attempting to delete finalizers '%s' of project '%s' as the project wasn't cleaned up within default timeout", (Object)Arrays.toString(finalizers.toArray()), (Object)this.currentNamespace);
                    finalizers.forEach(arg_0 -> ((Project)project).removeFinalizer(arg_0));
                    projectResource.patch((Object)project);
                    AwaitilityUtils.until(() -> ((Resource)projectResource).get(), (Matcher)Matchers.nullValue());
                }
                Assertions.fail((String)"Failed to delete project within default timeout, project is marked for deletion, but we might need too raise waiting period");
            }
            catch (AssertionFailedError e) {
                Assertions.fail((String)("Project failed to be deleted. Caused by " + e.getMessage()));
            }
            catch (Exception e) {
                LOG.errorf("Failed to delete project %s", (Object)this.currentNamespace, (Object)e);
                Assertions.fail((String)"Failed to delete OpenShit project");
            }
            finally {
                this.client.close();
                this.isClientReady = false;
            }
        } else {
            this.deleteResources(this.getScenarioId());
        }
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public KnativeClient getKnClient() {
        return this.kn;
    }

    public void removeSecret(String secretName) {
        Resource secret = (Resource)this.client.secrets().withName(secretName);
        if (secret.get() != null) {
            secret.delete();
        }
    }

    public boolean isAnyServicePodReady(String serviceName) {
        return ((FilterWatchListDeletable)this.client.pods().withLabel(LABEL_TO_WATCH_FOR_LOGS, serviceName)).resources().anyMatch(Resource::isReady);
    }

    public void createConfigMap(String configMapName, Path fileSystemPath) {
        Resource configMapResource = (Resource)this.client.configMaps().withName(configMapName);
        if (configMapResource.get() == null) {
            try {
                ConfigMap configMap = KubernetesResourceUtil.createConfigMapFromDirOrFiles((String)configMapName, (Path[])new Path[]{fileSystemPath});
                this.client.resource((HasMetadata)configMap).create();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create config map with name " + configMapName, e);
            }
        }
    }

    public void createEmptyConfigMap(String configMapName) {
        Resource configMapResource = (Resource)this.client.configMaps().withName(configMapName);
        if (configMapResource.get() == null) {
            ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().editMetadata().withName(configMapName)).endMetadata()).build();
            this.client.resource((HasMetadata)configMap).create();
        }
    }

    private void addAnnotatedConfigMap(String configMapName, String annotationName, String annotationValue) {
        Resource configMapResource = (Resource)this.client.configMaps().withName(configMapName);
        if (configMapResource.get() == null) {
            ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().editMetadata().withName(configMapName)).addToAnnotations(annotationName, annotationValue)).endMetadata()).build();
            this.client.resource((HasMetadata)configMap).create();
        }
    }

    private void deleteResources(String labelValue) {
        try {
            String label = String.format("%s=%s", LABEL_SCENARIO_ID, labelValue);
            new Command(new String[]{OC, "delete", "-n", this.currentNamespace, "all", "-l", label}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Project failed to be deleted. Caused by " + e.getMessage()));
        }
        finally {
            this.client.close();
            this.isClientReady = false;
        }
    }

    private String enrichTemplate(Service service, String template, Map<String, String> extraTemplateProperties) {
        String serviceName = service.getName();
        List<HasMetadata> objs = this.loadYaml(template);
        for (HasMetadata obj : objs) {
            boolean isQuarkusRuntime;
            obj.getMetadata().setNamespace(this.project());
            Map objMetadataLabels = Optional.ofNullable(obj.getMetadata().getLabels()).orElse(new HashMap());
            objMetadataLabels.put(LABEL_SCENARIO_ID, this.getScenarioId());
            obj.getMetadata().setLabels(objMetadataLabels);
            if (obj instanceof Deployment) {
                Map<String, String> environmentVariables;
                Deployment deployment = (Deployment)obj;
                deployment.getSpec().getTemplate().getMetadata().setNamespace(this.project());
                Map templateMetadataLabels = deployment.getSpec().getTemplate().getMetadata().getLabels();
                templateMetadataLabels.put(LABEL_TO_WATCH_FOR_LOGS, serviceName);
                templateMetadataLabels.put(LABEL_SCENARIO_ID, this.getScenarioId());
                isQuarkusRuntime = OpenShiftClient.isQuarkusRuntime(templateMetadataLabels);
                Map<String, String> enrichProperties = this.enrichProperties(service.getProperties(), deployment, isQuarkusRuntime);
                if (isQuarkusRuntime) {
                    Map<String, String> propsThatRequireDottedFormat = OpenShiftClient.appPropsThatRequireDottedFormat(enrichProperties);
                    environmentVariables = OpenShiftClient.convertPropertiesToEnvironment(enrichProperties, propsThatRequireDottedFormat);
                    String appPropertiesFileContent = OpenShiftClient.createAppPropsForPropsThatRequireDottedFormat(propsThatRequireDottedFormat);
                    if (!appPropertiesFileContent.isEmpty()) {
                        this.mountPropertiesAsQuarkusAppConfigFile(service, enrichProperties, deployment, appPropertiesFileContent);
                    }
                } else {
                    environmentVariables = enrichProperties;
                }
                environmentVariables.putAll(extraTemplateProperties);
                deployment.getSpec().getTemplate().getSpec().getContainers().forEach(container -> environmentVariables.forEach((key, value) -> {
                    EnvVar envVar = this.getEnvVarByKey((String)key, (Container)container);
                    if (envVar == null) {
                        container.getEnv().add(new EnvVar(key, value, null));
                    } else {
                        envVar.setValue(value);
                    }
                }));
                continue;
            }
            if (!(obj instanceof io.fabric8.kubernetes.api.model.Service)) continue;
            io.fabric8.kubernetes.api.model.Service k8Service = (io.fabric8.kubernetes.api.model.Service)obj;
            String k8ServiceName = k8Service.getMetadata().getName();
            isQuarkusRuntime = OpenShiftClient.isQuarkusRuntime(k8Service.getMetadata().getLabels());
            if (!isQuarkusRuntime || !OpenShiftClient.isNotManagementInterfaceService(k8ServiceName)) continue;
            OpenShiftClient.collectAnnotations(service).forEach(keyToVal -> {
                String annotationKey = keyToVal.key();
                String annotationVal = keyToVal.value();
                k8Service.getMetadata().getAnnotations().put(annotationKey, annotationVal);
            });
        }
        template = OpenShiftUtils.toYaml(objs);
        return template;
    }

    private static List<OpenShiftPropertiesUtils.PropertyToValue> collectAnnotations(Service service) {
        return service.getProperties().values().stream().filter(OpenShiftPropertiesUtils::isAnnotation).map(OpenShiftPropertiesUtils::getServiceAnnotation).toList();
    }

    private static boolean isNotManagementInterfaceService(String serviceName) {
        return serviceName == null || !serviceName.endsWith("-management");
    }

    private static String createAppPropsForPropsThatRequireDottedFormat(Map<String, String> configProperties) {
        return configProperties.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue() + System.lineSeparator()).collect(Collectors.joining());
    }

    private static boolean isQuarkusRuntime(Map<String, String> templateMetadataLabels) {
        return "quarkus".equals(templateMetadataLabels.get("app.openshift.io/runtime"));
    }

    private static Map<String, String> appPropsThatRequireDottedFormat(Map<String, String> configProperties) {
        return configProperties.entrySet().stream().filter(e -> {
            String configPropertyName = (String)e.getKey();
            String environmentVariableName = StringUtil.replaceNonAlphanumericByUnderscores((String)configPropertyName);
            String configPropertyNameCreatedFromEnvName = StringUtil.toLowerCaseAndDotted((String)environmentVariableName);
            return !configPropertyNameCreatedFromEnvName.equalsIgnoreCase(configPropertyName);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void mountPropertiesAsQuarkusAppConfigFile(Service service, Map<String, String> enrichProperties, Deployment deployment, String appPropertiesFileContent) {
        String appConfigFileName = service.getName().toLowerCase() + "-quarkus-application-configuration-file";
        this.createOrUpdateConfigMap(appConfigFileName, APP_PROPS_CONFIG_MAP_KEY, appPropertiesFileContent);
        ConfigMapVolumeSource configMapVolumeSource = ((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(appConfigFileName)).build();
        Volume volume = ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(appConfigFileName)).withConfigMap(configMapVolumeSource)).build();
        deployment.getSpec().getTemplate().getSpec().getVolumes().add(volume);
        String pwd = QuarkusProperties.isNativeEnabled() ? "/home/quarkus" : "/deployments";
        VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(appConfigFileName)).withSubPath(APP_PROPS_CONFIG_MAP_KEY)).withReadOnly(Boolean.valueOf(true))).withMountPath(pwd + "/config/application.properties")).build();
        deployment.getSpec().getTemplate().getSpec().getContainers().forEach(container -> container.getVolumeMounts().add(volumeMount));
    }

    private static Map<String, String> convertPropertiesToEnvironment(Map<String, String> properties, Map<String, String> propsThatRequireDottedFormat) {
        HashMap<String, String> environment = new HashMap<String, String>(properties.size());
        properties.forEach((property, value) -> {
            if (!propsThatRequireDottedFormat.containsKey(property) || OpenShiftClient.isQuarkusProperty(property)) {
                String variable = StringUtil.replaceNonAlphanumericByUnderscores((String)property).toUpperCase();
                environment.put(variable, (String)value);
            }
        });
        return environment;
    }

    private static boolean isQuarkusProperty(String propertyKey) {
        return propertyKey.startsWith("quarkus.");
    }

    private EnvVar getEnvVarByKey(String key, Container container) {
        return container.getEnv().stream().filter(env -> StringUtils.equals((CharSequence)key, (CharSequence)env.getName())).findFirst().orElse(null);
    }

    private Map<String, String> enrichProperties(Map<String, String> properties, Deployment deployment, boolean isQuarkusRuntime) {
        HashMap<String, CustomVolume> volumes = new HashMap<String, CustomVolume>();
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propertyValue = entry.getValue();
            if (this.isResource(propertyValue)) {
                path = entry.getValue().replace("resource::/", "");
                String mountPath = this.getMountPath(path);
                filename = OpenShiftClient.getFileName(path);
                String configMapName = OpenShiftClient.normalizeConfigMapName(mountPath, filename);
                this.createOrUpdateConfigMap(configMapName, filename, OpenShiftClient.getFileContent(path));
                if (!volumes.containsKey(mountPath)) {
                    volumes.put(mountPath, new CustomVolume(configMapName, "", CustomVolume.VolumeType.CONFIG_MAP));
                }
                propertyValue = OpenShiftClient.joinMountPathAndFileName(mountPath, filename);
                LOG.warn((Object)("Property " + entry.getKey() + " was used to copy file to " + propertyValue + ". Please consider using @Mount instead"));
            } else if (this.isResourceWithDestinationPath(propertyValue)) {
                path = propertyValue.replace("resource_with_destination::", "");
                if (!propertyValue.matches(".*\\|.*")) {
                    String errorMsg = String.format("Unexpected %s format. Expected destinationPath|fileName but found %s", "resource_with_destination::", propertyValue);
                    throw new RuntimeException(errorMsg);
                }
                String mountPath = path.split("\\|")[0];
                String fileName = path.split("\\|")[1];
                String fileNameNormalized = OpenShiftClient.getFileName(fileName);
                String configMapName = OpenShiftClient.normalizeConfigMapName(mountPath, fileNameNormalized);
                this.createOrUpdateConfigMap(configMapName, fileNameNormalized, OpenShiftClient.getFileContent(fileName));
                propertyValue = OpenShiftClient.joinMountPathAndFileName(mountPath, fileNameNormalized);
                if (!volumes.containsKey(propertyValue)) {
                    volumes.put(propertyValue, new CustomVolume(configMapName, fileNameNormalized, CustomVolume.VolumeType.CONFIG_MAP));
                }
                LOG.warn((Object)("Property " + entry.getKey() + " was used to copy file to " + propertyValue + ". Please consider using @Mount instead"));
            } else if (propertyValue.startsWith("secret_with_destination::")) {
                path = entry.getValue().replace("secret_with_destination::", "");
                int separatorIdx = path.lastIndexOf("|");
                mountPath = path.substring(0, separatorIdx);
                String filename = path.substring(separatorIdx + 1);
                String secretName = OpenShiftClient.normalizeConfigMapName(mountPath, filename);
                propertyValue = OpenShiftClient.joinMountPathAndFileName(mountPath, filename);
                String filePath = Files.exists(Path.of(propertyValue, new String[0]), new LinkOption[0]) ? propertyValue : OpenShiftClient.getFilePath(PropertiesUtils.SLASH + filename);
                this.doCreateSecretFromFile(secretName, filePath);
                volumes.putIfAbsent(mountPath, new CustomVolume(secretName, "", CustomVolume.VolumeType.SECRET));
            } else if (this.isSecret(propertyValue)) {
                path = entry.getValue().replace("secret::/", "");
                String mountPath = this.getMountPath(path);
                filename = OpenShiftClient.getFileName(path);
                String secretName = OpenShiftClient.normalizeConfigMapName(mountPath, filename);
                this.doCreateSecretFromFile(secretName, OpenShiftClient.getFilePath(path));
                volumes.put(mountPath, new CustomVolume(secretName, "", CustomVolume.VolumeType.SECRET));
                propertyValue = OpenShiftClient.joinMountPathAndFileName(mountPath, filename);
            } else if (isQuarkusRuntime && OpenShiftPropertiesUtils.isMountSecret(propertyValue)) {
                OpenShiftPropertiesUtils.PropertyToValue secretNameToMountPath = OpenShiftPropertiesUtils.getMountSecret(propertyValue);
                String secretName = secretNameToMountPath.key();
                mountPath = secretNameToMountPath.value();
                volumes.put(mountPath, new CustomVolume(secretName, "", CustomVolume.VolumeType.SECRET));
                propertyValue = mountPath;
            } else if (isQuarkusRuntime && OpenShiftPropertiesUtils.isMountConfigMap(propertyValue)) {
                OpenShiftPropertiesUtils.PropertyToValue configMapNameToMountPath = OpenShiftPropertiesUtils.getMountConfigMap(propertyValue);
                String configMapName = configMapNameToMountPath.key();
                mountPath = configMapNameToMountPath.value();
                volumes.put(mountPath, new CustomVolume(configMapName, "", CustomVolume.VolumeType.CONFIG_MAP));
                propertyValue = mountPath;
            } else if (isQuarkusRuntime && OpenShiftPropertiesUtils.isAnnotatedConfigMap(propertyValue)) {
                OpenShiftPropertiesUtils.PropertyToObj annotatedConfigMap = OpenShiftPropertiesUtils.getAnnotatedConfigMap(propertyValue);
                String configMapName = annotatedConfigMap.key();
                String annotationName = annotatedConfigMap.value().key();
                String annotationVal = annotatedConfigMap.value().value();
                this.addAnnotatedConfigMap(configMapName, annotationName, annotationVal);
                propertyValue = annotationVal;
            }
            output.put(entry.getKey(), propertyValue);
        }
        for (Map.Entry<String, String> entry : volumes.entrySet()) {
            deployment.getSpec().getTemplate().getSpec().getVolumes().add(((CustomVolume)((Object)entry.getValue())).getVolume());
            deployment.getSpec().getTemplate().getSpec().getContainers().forEach(container -> container.getVolumeMounts().add(OpenShiftClient.createVolumeMount((String)volume.getKey(), (CustomVolume)volume.getValue())));
        }
        return output;
    }

    private static VolumeMount createVolumeMount(String path, CustomVolume volume) {
        VolumeMountBuilder volumeMountBuilder = (VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(volume.getName())).withReadOnly(Boolean.valueOf(true))).withMountPath(path);
        if (!volume.getSubFolderRegExp().isEmpty()) {
            volumeMountBuilder.withSubPathExpr(volume.getSubFolderRegExp());
        }
        return volumeMountBuilder.build();
    }

    private void createOrUpdateConfigMap(String configMapName, String key, String value) {
        MixedOperation configMaps = this.client.configMaps();
        if (((Resource)configMaps.withName(configMapName)).get() != null) {
            ((Resource)configMaps.withName(configMapName)).edit(configMap -> {
                configMap.getData().put(key, value);
                return configMap;
            });
        } else {
            ((Resource)configMaps.resource((Object)((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName)).endMetadata()).addToData(key, value)).build())).unlock().create();
        }
    }

    private static String getFileName(String path) {
        if (!path.contains(PropertiesUtils.SLASH)) {
            return path;
        }
        return path.substring(path.lastIndexOf(PropertiesUtils.SLASH) + 1);
    }

    private String getMountPath(String path) {
        if (!path.contains(PropertiesUtils.SLASH)) {
            return RESOURCE_MNT_FOLDER;
        }
        Object mountPath = (String)StringUtils.defaultIfEmpty((CharSequence)path.substring(0, path.lastIndexOf(PropertiesUtils.SLASH)), (CharSequence)RESOURCE_MNT_FOLDER);
        if (!path.startsWith(PropertiesUtils.SLASH)) {
            mountPath = PropertiesUtils.SLASH + (String)mountPath;
        }
        return mountPath;
    }

    private static String getFileContent(String path) {
        String filePath = OpenShiftClient.getFilePath(path);
        if (Files.exists(Path.of(filePath, new String[0]), new LinkOption[0])) {
            return FileUtils.loadFile((File)Path.of(filePath, new String[0]).toFile());
        }
        return FileUtils.loadFile((String)filePath);
    }

    private static String getFilePath(String path) {
        String string;
        block8: {
            Stream<Path> binariesFound = Files.find(PropertiesUtils.TARGET, Integer.MAX_VALUE, (file, basicFileAttributes) -> file.toString().contains(path), new FileVisitOption[0]);
            try {
                string = binariesFound.map(Path::toString).findFirst().orElse(path);
                if (binariesFound == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (binariesFound != null) {
                        try {
                            binariesFound.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return path;
                }
            }
            binariesFound.close();
        }
        return string;
    }

    private static String normalizeConfigMapName(String mountPath, String fileName) {
        String newName = StringUtils.removeStart((String)OpenShiftClient.joinMountPathAndFileName(mountPath, fileName), (String)PropertiesUtils.SLASH).replaceAll(Pattern.quote("."), "-").replaceAll(PropertiesUtils.SLASH, "-");
        if (newName.length() > 63) {
            newName = newName.substring(newName.length() - 63);
            while (newName.startsWith("-")) {
                newName = newName.substring(1);
            }
        }
        return newName;
    }

    private static String joinMountPathAndFileName(String mountPath, String fileName) {
        if (!((String)mountPath).endsWith(PropertiesUtils.SLASH)) {
            mountPath = (String)mountPath + PropertiesUtils.SLASH;
        }
        return (String)mountPath + fileName;
    }

    private boolean isResourceWithDestinationPath(String key) {
        return key.startsWith("resource_with_destination::");
    }

    private boolean isResource(String key) {
        return key.startsWith("resource::/");
    }

    private boolean isSecret(String key) {
        return key.startsWith("secret::/");
    }

    private boolean hasImageStreamTags(ImageStream is) {
        return !((ImageStream)((Resource)this.client.imageStreams().withName(is.getMetadata().getName())).get()).getStatus().getTags().isEmpty();
    }

    private boolean isPodRunning(Pod pod) {
        return pod.getStatus().getPhase().equals("Running");
    }

    private String createProject() {
        boolean projectCreated = false;
        String namespace = OpenShiftClient.generateRandomProjectName();
        for (int index = 0; index < 5; ++index) {
            if (this.doCreateProject(namespace)) {
                projectCreated = true;
                break;
            }
            namespace = OpenShiftClient.generateRandomProjectName();
        }
        if (!projectCreated) {
            Assertions.fail((String)"Project cannot be created. Review your OpenShift installation.");
        }
        return namespace;
    }

    private void doCreateSecretFromFile(String name, String filePath) {
        if (((Resource)this.client.secrets().withName(name)).get() == null) {
            try {
                new Command(new String[]{OC, "create", "secret", "generic", name, "--from-file=" + filePath, "-n", this.currentNamespace}).runAndWait();
            }
            catch (Exception e) {
                Assertions.fail((String)("Could not create secret. Caused by " + e.getMessage()));
            }
        }
    }

    private boolean doCreateProject(String projectName) {
        boolean created = false;
        try {
            new Command(new String[]{OC, "new-project", projectName}).runAndWait();
            created = true;
        }
        catch (Exception e) {
            Log.warn((String)("Project " + projectName + " failed to be created. Caused by: " + e.getMessage() + ". Trying again."), (Object[])new Object[0]);
        }
        return created;
    }

    private List<HasMetadata> loadYaml(String template) {
        NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable load = this.client.load((InputStream)new ByteArrayInputStream(template.getBytes()));
        return load.items();
    }

    private static String generateRandomProjectName() {
        return ThreadLocalRandom.current().ints(10L, 97, 123).collect(() -> new StringBuilder("ts-"), StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public void addMount(Deployment deployment, String from, String to) {
        String newName;
        String mountPath;
        if (to.endsWith(PropertiesUtils.SLASH)) {
            mountPath = to;
            newName = from;
        } else {
            newName = OpenShiftClient.getFileName(to);
            mountPath = to.substring(0, to.indexOf(newName));
        }
        LOG.info((Object)("Copying file " + from + " to folder " + mountPath + " with name " + newName));
        String configMapName = OpenShiftClient.normalizeConfigMapName(mountPath, newName);
        this.createOrUpdateConfigMap(configMapName, newName, OpenShiftClient.getFileContent(from));
        String volumeName = OpenShiftClient.joinMountPathAndFileName(mountPath, newName);
        CustomVolume volume = new CustomVolume(configMapName, newName, CustomVolume.VolumeType.CONFIG_MAP);
        deployment.getSpec().getTemplate().getSpec().getVolumes().add(volume.getVolume());
        deployment.getSpec().getTemplate().getSpec().getContainers().forEach(container -> container.getVolumeMounts().add(OpenShiftClient.createVolumeMount(volumeName, volume)));
    }
}

