/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.logging;

import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.logging.ServiceLoggingHandler;
import java.util.Map;

public class OpenShiftLoggingHandler
extends ServiceLoggingHandler {
    private final OpenShiftClient client;
    private final Service service;
    private Map<String, String> oldLogs;

    public OpenShiftLoggingHandler(ServiceContext context) {
        super(context.getOwner());
        this.service = context.getOwner();
        this.client = (OpenShiftClient)context.get("openshift-client");
    }

    protected synchronized void handle() {
        Map<String, String> newLogs = this.client.logs(this.service);
        for (Map.Entry<String, String> entry : newLogs.entrySet()) {
            this.onMapDifference(entry);
        }
        this.oldLogs = newLogs;
    }

    private void onMapDifference(Map.Entry<String, String> entry) {
        String newPodLogs = this.formatPodLogs(entry.getKey(), entry.getValue());
        if (this.oldLogs != null && this.oldLogs.containsKey(entry.getKey())) {
            String oldPodLogs = this.formatPodLogs(entry.getKey(), this.oldLogs.get(entry.getKey()));
            this.onStringDifference(newPodLogs, oldPodLogs);
        } else {
            this.onLines(newPodLogs);
        }
    }

    private String formatPodLogs(String podName, String log) {
        return String.format("[%s] %s", podName, log);
    }
}

