/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.operator;

import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.OperatorService;
import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.bootstrap.inject.OpenShiftClient;
import io.quarkus.test.services.URILike;
import io.quarkus.test.services.operator.OperatorManagedResourceBuilder;
import io.quarkus.test.services.operator.model.CustomResourceDefinition;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OperatorManagedResource
implements ManagedResource {
    private final OperatorManagedResourceBuilder model;
    private final OpenShiftClient client;
    private final List<CustomResourceDefinition> crdsToWatch = new ArrayList<CustomResourceDefinition>();
    private boolean running;

    public OperatorManagedResource(OperatorManagedResourceBuilder model) {
        this.model = model;
        this.client = (OpenShiftClient)model.getContext().get("openshift-client");
    }

    public String getDisplayName() {
        return this.model.getName();
    }

    public void start() {
        if (!this.running) {
            this.installOperator();
            this.applyCRDs();
            this.running = true;
        }
    }

    public void stop() {
    }

    public boolean isRunning() {
        return this.running && this.customResourcesAreReady();
    }

    public URILike getURI(Protocol protocol) {
        throw new UnsupportedOperationException("Operator does not expose services.");
    }

    public List<String> logs() {
        return Collections.emptyList();
    }

    private void applyCRDs() {
        Service service = this.model.getContext().getOwner();
        if (service instanceof OperatorService) {
            OperatorService service2 = (OperatorService)service;
            for (CustomResourceDefinition crd : service2.getCrds()) {
                this.applyCRD(crd);
            }
        }
    }

    private void applyCRD(CustomResourceDefinition crd) {
        ServiceContext serviceContext = this.model.getContext();
        Path crdFileDefinition = serviceContext.getServiceFolder().resolve(crd.name());
        String content = FileUtils.loadFile((String)crd.file());
        FileUtils.copyContentTo((String)content, (Path)crdFileDefinition);
        this.client.apply(crdFileDefinition);
        this.crdsToWatch.add(crd);
    }

    private boolean customResourcesAreReady() {
        return this.crdsToWatch.stream().allMatch(crd -> this.client.isCustomResourceReady(crd.name(), crd.type()));
    }

    private void installOperator() {
        this.client.installOperator(this.model.getContext().getOwner(), this.model.getName(), this.model.getChannel(), this.model.getSource(), this.model.getSourceNamespace());
    }
}

