/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.services.quarkus.ArtifactQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.TemplateOpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.model.QuarkusProperties;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.PropertiesUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

public class BuildOpenShiftQuarkusApplicationManagedResource
extends TemplateOpenShiftQuarkusApplicationManagedResource<ArtifactQuarkusApplicationManagedResourceBuilder> {
    private static final String S2I_DEFAULT_VERSION = "latest";
    private static final String QUARKUS_OPENSHIFT_TEMPLATE = "/quarkus-build-openshift-template.yml";
    private static final String IMAGE_TAG_SEPARATOR = ":";
    private static final String QUARKUS_OPENSHIFT_OPTS_PROPERTY = "quarkus.openshift.env.vars.quarkus-opts";
    private String builtImageName = "no-image-yet";

    public BuildOpenShiftQuarkusApplicationManagedResource(ArtifactQuarkusApplicationManagedResourceBuilder model) {
        super(model);
    }

    @Override
    protected String getDefaultTemplate() {
        return QUARKUS_OPENSHIFT_TEMPLATE;
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.startBuild();
        this.builtImageName = BuildOpenShiftQuarkusApplicationManagedResource.getImage(((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getName());
        BuildOpenShiftQuarkusApplicationManagedResource.patchDeployment(((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getName(), this.builtImageName);
        this.exposeServices();
    }

    private static void patchDeployment(String service, String image) {
        Log.info((String)"Trying to patch deployment with the latest image version.", (Object[])new Object[0]);
        try {
            HashMap<String, String> replacement = new HashMap<String, String>();
            replacement.put("op", "replace");
            replacement.put("path", "/spec/template/spec/containers/0/image");
            replacement.put("value", image);
            String patch = new ObjectMapper().writer().writeValueAsString(replacement);
            new Command(new String[]{"oc", "patch", "deployment", service, "--type=json", "-p=[%s]".formatted(patch)}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed while patching the deployment. Caused by " + e.getMessage()));
        }
    }

    private static String getImage(String service) {
        Log.info((String)"Trying to retrieve the latest image version.", (Object[])new Object[0]);
        try {
            ArrayList output = new ArrayList();
            new Command(new String[]{"oc", "get", "buildconfig", service, "-o", "template", "--template", "{{.status.lastVersion}}"}).outputToLines(output).runAndWait();
            String version = (String)output.get(0);
            Log.info((String)"Received build version %s", (Object[])new Object[]{version});
            output = new ArrayList();
            new Command(new String[]{"oc", "get", "build", service + "-" + version, "-o", "template", "--template", "{{.status.outputDockerImageReference}}"}).outputToLines(output).runAndWait();
            String image = (String)output.get(0);
            Log.info((String)"Received full image name: '%s'", (Object[])new Object[]{image});
            return image;
        }
        catch (Exception e) {
            throw new AssertionFailedError("Failed while retrieving image. Caused by " + e.getMessage());
        }
    }

    @Override
    protected String replaceDeploymentContent(String content) {
        String s2iImage = this.getS2iImage();
        String s2iVersion = this.getS2iImageVersion(s2iImage);
        String quarkusOpts = this.getQuarkusOpts();
        if (!quarkusOpts.isEmpty()) {
            Log.info((String)("Setting QUARKUS_OPTS, based on quarkus.openshift.env.vars.quarkus-opts to " + quarkusOpts), (Object[])new Object[0]);
        }
        return content.replaceAll(Pattern.quote("${QUARKUS_S2I_IMAGE_BUILDER}"), StringUtils.substringBeforeLast((String)s2iImage, (String)IMAGE_TAG_SEPARATOR)).replaceAll(Pattern.quote("${QUARKUS_S2I_IMAGE_BUILDER_VERSION}"), s2iVersion).replaceAll(Pattern.quote("${ARTIFACT}"), ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().getFileName().toString()).replaceAll(Pattern.quote("${QUARKUS_OPTS}"), quarkusOpts).replaceAll(Pattern.quote("${IMAGE_NAME}"), this.builtImageName);
    }

    private void exposeServices() {
        this.client.expose(((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner(), 8080);
        this.client.expose(((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getName() + "-management", ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getManagementPort());
    }

    private void startBuild() {
        String fromArg = "--from-dir=" + ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().toAbsolutePath().getParent().toString();
        if (this.isNativeTest()) {
            fromArg = "--from-file=" + String.valueOf(((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().toAbsolutePath());
        }
        try {
            new Command(new String[]{"oc", "start-build", ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getName(), fromArg, "--follow"}).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed when starting build. Caused by " + e.getMessage()));
        }
    }

    private String getS2iImageVersion(String s2iImage) {
        String s2iVersion = S2I_DEFAULT_VERSION;
        if (s2iImage.contains(IMAGE_TAG_SEPARATOR)) {
            s2iVersion = StringUtils.substringAfterLast((String)s2iImage, (String)IMAGE_TAG_SEPARATOR);
        }
        return s2iVersion;
    }

    private String getS2iImage() {
        PropertyLookup s2iImageProperty = this.isNativeTest() ? QuarkusProperties.QUARKUS_NATIVE_S2I : QuarkusProperties.QUARKUS_JVM_S2I;
        return ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getProperty(s2iImageProperty.getPropertyKey()).orElseGet(() -> s2iImageProperty.get(((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getContext()));
    }

    private String getQuarkusOpts() {
        Map properties;
        Path applicationProperties = ((ArtifactQuarkusApplicationManagedResourceBuilder)this.model).getComputedApplicationProperties();
        if (Files.exists(applicationProperties, new LinkOption[0]) && (properties = PropertiesUtils.toMap((Path)applicationProperties)).containsKey(QUARKUS_OPENSHIFT_OPTS_PROPERTY)) {
            return (String)properties.get(QUARKUS_OPENSHIFT_OPTS_PROPERTY);
        }
        return "";
    }
}

