/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.services.quarkus.ProdQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.TemplateOpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.model.LaunchMode;
import io.quarkus.test.utils.DockerUtils;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class ContainerRegistryOpenShiftQuarkusApplicationManagedResource
extends TemplateOpenShiftQuarkusApplicationManagedResource<ProdQuarkusApplicationManagedResourceBuilder> {
    private static final String QUARKUS_OPENSHIFT_TEMPLATE = "/quarkus-registry-openshift-template.yml";
    private String image;

    public ContainerRegistryOpenShiftQuarkusApplicationManagedResource(ProdQuarkusApplicationManagedResourceBuilder model) {
        super(model);
    }

    @Override
    protected String getDefaultTemplate() {
        return QUARKUS_OPENSHIFT_TEMPLATE;
    }

    @Override
    protected void doInit() {
        this.image = this.createImageAndPush();
        super.doInit();
        this.exposeServices();
    }

    @Override
    protected String replaceDeploymentContent(String content) {
        return content.replaceAll(Pattern.quote("${IMAGE}"), this.image).replaceAll(Pattern.quote("${ARTIFACT}"), ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getArtifact().getFileName().toString());
    }

    private void exposeServices() {
        Service service = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner();
        this.client.expose(service, 8080);
        if (((ProdQuarkusApplicationManagedResourceBuilder)this.model).useSeparateManagementInterface()) {
            this.client.expose(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getName() + "-management", ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getManagementPort());
        }
    }

    private String createImageAndPush() {
        return DockerUtils.createImageAndPush((ServiceContext)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext(), (LaunchMode)this.getLaunchMode(), (Path)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getArtifact());
    }
}

