/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.services.quarkus.OpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.ProdQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.model.QuarkusProperties;
import io.quarkus.test.utils.Command;
import io.quarkus.test.utils.FileUtils;
import io.quarkus.test.utils.MavenUtils;
import io.quarkus.test.utils.PropertiesUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;

public class ExtensionOpenShiftQuarkusApplicationManagedResource
extends OpenShiftQuarkusApplicationManagedResource<ProdQuarkusApplicationManagedResourceBuilder> {
    private static final String USING_EXTENSION_PROFILE = "-Pdeploy-to-openshift-using-extension";
    private static final String QUARKUS_PLUGIN_DEPLOY = "-Dquarkus.kubernetes.deploy=true";
    private static final String QUARKUS_PLUGIN_ROUTE_EXPOSE = "-Dquarkus.openshift.route.expose=true";
    private static final String QUARKUS_CONTAINER_NAME = "quarkus.application.name";
    private static final String QUARKUS_KUBERNETES_CLIENT_NAMESPACE = "quarkus.kubernetes-client.namespace";
    private static final String QUARKUS_KUBERNETES_CLIENT_TRUST_CERTS = "quarkus.kubernetes-client.trust-certs";
    private static final String QUARKUS_CONTAINER_IMAGE_GROUP = "quarkus.container-image.group";
    private static final String QUARKUS_OPENSHIFT_ENV_VARS = "quarkus.openshift.env.vars.";
    private static final String QUARKUS_OPENSHIFT_LABELS = "quarkus.openshift.labels.";
    private static final String QUARKUS_OPENSHIFT_BASE_JAVA_IMAGE = "quarkus.openshift.base-jvm-image";
    private static final String QUARKUS_OPENSHIFT_BASE_NATIVE_IMAGE = "quarkus.openshift.base-native-image";
    private static final String QUARKUS_KNATIVE_ENV_VARS = "quarkus.knative.env.vars.";
    private static final String QUARKUS_KNATIVE_LABELS = "quarkus.knative.labels.";
    private static final String QUARKUS_KUBERNETES_DEPLOYMENT_TARGET = "quarkus.kubernetes.deployment-target";
    private static final String OPENSHIFT = "openshift";
    private static final String KNATIVE = "knative";
    private static final String QUARKUS_KUBERNETES_DEPLOYMENT_TARGET_OPENSHIFT = String.format("-D%s=%s", "quarkus.kubernetes.deployment-target", "openshift");
    private static final Path APPLICATION_PROPERTIES_PATH = Paths.get("src", "main", "resources", "application.properties");

    public ExtensionOpenShiftQuarkusApplicationManagedResource(ProdQuarkusApplicationManagedResourceBuilder model) {
        super(model);
    }

    @Override
    protected void doInit() {
        this.cloneProjectToServiceAppFolder();
        this.copyComputedPropertiesIntoAppFolder();
        this.deployProjectUsingMavenCommand();
        this.exposeManagementRoute();
    }

    private void exposeManagementRoute() {
        if (((ProdQuarkusApplicationManagedResourceBuilder)this.model).useSeparateManagementInterface()) {
            String app = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getName();
            String routeName = app + "-management";
            int port = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getManagementPort();
            this.client.createService(app, routeName, port);
            this.client.expose(routeName, routeName, port);
        }
    }

    @Override
    protected void doUpdate() {
        this.client.applyServicePropertiesToDeployment(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner());
    }

    public boolean needsBuildArtifact() {
        return false;
    }

    public void validate() {
        super.validate();
        if (((ProdQuarkusApplicationManagedResourceBuilder)this.model).requiresCustomBuild()) {
            Assertions.fail((String)"Custom source classes or forced dependencies is not supported by `UsingOpenShiftExtension`");
        }
    }

    protected void withAdditionalArguments(List<String> args) {
    }

    private void copyComputedPropertiesIntoAppFolder() {
        Map computedProperties;
        Path computedPropertiesPath = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getComputedApplicationProperties();
        if (Files.exists(computedPropertiesPath, new LinkOption[0]) && !(computedProperties = PropertiesUtils.toMap((Path)computedPropertiesPath)).isEmpty()) {
            Path appPropertiesPath = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getApplicationFolder().resolve(APPLICATION_PROPERTIES_PATH);
            ExtensionOpenShiftQuarkusApplicationManagedResource.createApplicationPropertiesIfNotExists(appPropertiesPath);
            PropertiesUtils.fromMap((Map)computedProperties, (Path)appPropertiesPath);
        }
        ((ProdQuarkusApplicationManagedResourceBuilder)this.model).createSnapshotOfBuildProperties();
    }

    private static void createApplicationPropertiesIfNotExists(Path appPropertiesPath) {
        if (!Files.exists(appPropertiesPath, new LinkOption[0])) {
            if (!Files.exists(appPropertiesPath.getParent(), new LinkOption[0])) {
                appPropertiesPath.getParent().toFile().mkdirs();
            }
            try {
                appPropertiesPath.toFile().createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create application properties file at path: '%s'".formatted(appPropertiesPath), e);
            }
        }
    }

    private void deployProjectUsingMavenCommand() {
        MavenUtils.installParentPomsIfNeeded();
        String namespace = this.client.project();
        List args = MavenUtils.mvnCommand((ServiceContext)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext());
        args.addAll(Arrays.asList(USING_EXTENSION_PROFILE, "-B", "-V", "package", QUARKUS_PLUGIN_DEPLOY, QUARKUS_PLUGIN_ROUTE_EXPOSE, "-DskipTests=true", "-DskipITs=true", "-Dcheckstyle.skip", "-Dquarkus.build.skip=false"));
        args.add(this.withContainerName());
        args.add(this.withKubernetesClientNamespace(namespace));
        args.add(this.withKubernetesClientTrustCerts());
        args.add(this.withContainerImageGroup(namespace));
        args.add(this.withLabelsForWatching());
        args.add(this.withLabelsForScenarioId());
        this.withDeploymentTarget(args);
        this.withEnvVars(args);
        this.withBaseImageProperties(args);
        this.withAdditionalArguments(args);
        try {
            new Command(args).onDirectory(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getApplicationFolder()).runAndWait();
        }
        catch (Exception e) {
            Assertions.fail((String)("Failed to run maven command. Caused by " + e.getMessage()));
        }
    }

    private void withDeploymentTarget(List<String> args) {
        String deploymentTarget = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getComputedProperty(QUARKUS_KUBERNETES_DEPLOYMENT_TARGET);
        if (deploymentTarget == null || deploymentTarget.isBlank()) {
            args.add(QUARKUS_KUBERNETES_DEPLOYMENT_TARGET_OPENSHIFT);
        }
    }

    private void withBaseImageProperties(List<String> args) {
        String openShiftImageProperty;
        boolean isNativeTest = this.isNativeTest();
        PropertyLookup s2iImageProperty = isNativeTest ? QuarkusProperties.QUARKUS_NATIVE_S2I : QuarkusProperties.QUARKUS_JVM_S2I;
        String baseImage = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getProperty(s2iImageProperty.getPropertyKey()).orElseGet(() -> s2iImageProperty.get(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext()));
        args.add(MavenUtils.withProperty((String)s2iImageProperty.getPropertyKey(), (String)baseImage));
        String string = openShiftImageProperty = isNativeTest ? QUARKUS_OPENSHIFT_BASE_NATIVE_IMAGE : QUARKUS_OPENSHIFT_BASE_JAVA_IMAGE;
        if (((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getProperty(openShiftImageProperty).isEmpty()) {
            args.add(MavenUtils.withProperty((String)openShiftImageProperty, (String)baseImage));
        }
    }

    private String withLabelsForWatching() {
        return this.withLabels("tsLogWatch", ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getName());
    }

    private String withLabelsForScenarioId() {
        return this.withLabels("scenarioId", this.client.getScenarioId());
    }

    private String withLabels(String label, String value) {
        String property = QUARKUS_OPENSHIFT_LABELS;
        if (this.isKnativeDeployment()) {
            property = QUARKUS_KNATIVE_LABELS;
        }
        return MavenUtils.withProperty((String)(property + label), (String)value);
    }

    private String withContainerName() {
        return MavenUtils.withProperty((String)QUARKUS_CONTAINER_NAME, (String)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getName());
    }

    private String withJarFileName() {
        return MavenUtils.withProperty((String)"quarkus.openshift.jar-file-name", (String)"quarkus-run.jar");
    }

    private String withContainerImageGroup(String namespace) {
        return MavenUtils.withProperty((String)QUARKUS_CONTAINER_IMAGE_GROUP, (String)namespace);
    }

    private String withKubernetesClientNamespace(String namespace) {
        return MavenUtils.withProperty((String)QUARKUS_KUBERNETES_CLIENT_NAMESPACE, (String)namespace);
    }

    private String withKubernetesClientTrustCerts() {
        return MavenUtils.withProperty((String)QUARKUS_KUBERNETES_CLIENT_TRUST_CERTS, (String)Boolean.TRUE.toString());
    }

    private void withEnvVars(List<String> args) {
        Map envVars = ((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getOwner().getProperties();
        String property = QUARKUS_OPENSHIFT_ENV_VARS;
        if (this.isKnativeDeployment()) {
            property = QUARKUS_KNATIVE_ENV_VARS;
        }
        for (Map.Entry envVar : envVars.entrySet()) {
            if (ExtensionOpenShiftQuarkusApplicationManagedResource.requiredByExtension((String)envVar.getKey())) {
                args.add(MavenUtils.withProperty((String)((String)envVar.getKey()), (String)((String)envVar.getValue())));
                continue;
            }
            String envVarKey = ((String)envVar.getKey()).replaceAll(Pattern.quote("."), "-");
            args.add(MavenUtils.withProperty((String)(property + envVarKey), (String)((String)envVar.getValue())));
        }
    }

    private static boolean requiredByExtension(String parameter) {
        return parameter.startsWith("quarkus.management.") || parameter.endsWith(".grpc-action");
    }

    private boolean isKnativeDeployment() {
        return KNATIVE.equals(((ProdQuarkusApplicationManagedResourceBuilder)this.model).getComputedProperty(QUARKUS_KUBERNETES_DEPLOYMENT_TARGET));
    }

    protected void cloneProjectToServiceAppFolder() {
        FileUtils.copyCurrentDirectoryTo((Path)((ProdQuarkusApplicationManagedResourceBuilder)this.model).getContext().getServiceFolder());
    }
}

