/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.configuration.Configuration;
import io.quarkus.test.configuration.PropertyLookup;
import io.quarkus.test.logging.Log;
import io.quarkus.test.scenarios.annotations.DisabledOnQuarkusSnapshotCondition;
import io.quarkus.test.services.quarkus.GitRepositoryQuarkusApplicationManagedResourceBuilder;
import io.quarkus.test.services.quarkus.TemplateOpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.model.QuarkusProperties;
import io.quarkus.test.utils.FileUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;

public class OpenShiftS2iGitRepositoryQuarkusApplicationManagedResource
extends TemplateOpenShiftQuarkusApplicationManagedResource<GitRepositoryQuarkusApplicationManagedResourceBuilder> {
    private static final String QUARKUS_SOURCE_S2I_BUILD_TEMPLATE_FILENAME = "/quarkus-s2i-source-build-template.yml";
    private static final String QUARKUS_SOURCE_S2I_SETTINGS_MVN_FILENAME = "settings-mvn.yml";
    private static final String INTERNAL_MAVEN_REPOSITORY_PROPERTY = "${internal.s2i.maven.remote.repository}";
    private static final PropertyLookup MAVEN_REMOTE_REPOSITORY = new PropertyLookup(Configuration.Property.S2I_MAVEN_REMOTE_REPOSITORY.getName());
    private static final PropertyLookup REPLACE_JAVA_CA_CERTS = new PropertyLookup(Configuration.Property.S2I_REPLACE_CA_CERTS.getName());
    private static final String ETC_PKI_JAVA_CONFIG_MAP_NAME = "etc-pki-java";
    private static final PropertyLookup QUARKUS_NATIVE_S2I_FROM_SRC = new PropertyLookup(Configuration.Property.S2I_BASE_NATIVE_IMAGE.getName(), "quay.io/quarkus/ubi9-quarkus-graalvmce-s2i:jdk-21");
    private final GitRepositoryQuarkusApplicationManagedResourceBuilder model;

    public OpenShiftS2iGitRepositoryQuarkusApplicationManagedResource(GitRepositoryQuarkusApplicationManagedResourceBuilder model) {
        super(model);
        this.model = model;
    }

    public void validate() {
        super.validate();
        if (this.model.isDevMode()) {
            Assertions.fail((String)"DEV mode is not supported when using GIT repositories on OpenShift deployments");
        }
        System.out.println("name: " + Configuration.Property.S2I_MAVEN_REMOTE_REPOSITORY.getName());
        String repo = MAVEN_REMOTE_REPOSITORY.get(this.model.getContext());
        System.out.println("Repo: " + repo);
        if (DisabledOnQuarkusSnapshotCondition.isQuarkusSnapshotVersion() && StringUtils.isEmpty((CharSequence)repo)) {
            Assertions.fail((String)"s2i can't use the Quarkus 999-SNAPSHOT version if not Maven repository has been provided");
        }
    }

    @Override
    protected String getDefaultTemplate() {
        return QUARKUS_SOURCE_S2I_BUILD_TEMPLATE_FILENAME;
    }

    @Override
    protected void doInit() {
        this.createMavenSettings();
        super.doInit();
        this.client.followBuildConfigLogs(this.model.getContext().getName());
    }

    protected boolean needsBuildArtifact() {
        return false;
    }

    @Override
    protected String replaceDeploymentContent(String content) {
        String quarkusPlatformVersion = QuarkusProperties.getVersion();
        String quarkusS2iBaseImage = this.getQuarkusS2iBaseImage();
        String mavenArgs = this.model.getMavenArgsWithVersion();
        return content.replaceAll(Pattern.quote("${APP_NAME}"), this.model.getContext().getOwner().getName()).replaceAll(Pattern.quote("${QUARKUS_S2I_BUILDER_IMAGE}"), quarkusS2iBaseImage).replaceAll(Pattern.quote("${GIT_URI}"), this.model.getGitRepository()).replaceAll(Pattern.quote("${GIT_REF}"), this.model.getGitBranch()).replaceAll(Pattern.quote("${CONTEXT_DIR}"), this.model.getContextDir()).replaceAll(Pattern.quote("${GIT_MAVEN_ARGS}"), mavenArgs).replaceAll(Pattern.quote("${CURRENT_NAMESPACE}"), this.client.project()).replaceAll(Pattern.quote("${QUARKUS_PLATFORM_GROUP-ID}"), QuarkusProperties.PLATFORM_GROUP_ID.get()).replaceAll(Pattern.quote("${QUARKUS_PLATFORM_VERSION}"), quarkusPlatformVersion);
    }

    private String getQuarkusS2iBaseImage() {
        PropertyLookup s2iImageProperty = this.isNativeTest() ? QUARKUS_NATIVE_S2I_FROM_SRC : QuarkusProperties.QUARKUS_JVM_S2I;
        return this.model.getContext().getOwner().getProperty(s2iImageProperty.getPropertyKey()).orElseGet(() -> s2iImageProperty.get(this.model.getContext()));
    }

    private void createMavenSettings() {
        Path targetQuarkusSourceS2iSettingsMvnFilename = this.model.getContext().getServiceFolder().resolve(QUARKUS_SOURCE_S2I_SETTINGS_MVN_FILENAME);
        String content = FileUtils.loadFile((String)"/settings-mvn.yml");
        boolean replaceJavaCaCerts = false;
        String remoteRepo = MAVEN_REMOTE_REPOSITORY.get(this.model.getContext());
        if (StringUtils.isNotEmpty((CharSequence)remoteRepo)) {
            content = content.replaceAll(Pattern.quote(INTERNAL_MAVEN_REPOSITORY_PROPERTY), remoteRepo);
            replaceJavaCaCerts = this.shouldReplaceJavaCaCerts(remoteRepo);
        }
        this.prepareJavaCaCerts(replaceJavaCaCerts);
        FileUtils.copyContentTo((String)content, (Path)targetQuarkusSourceS2iSettingsMvnFilename);
        this.client.apply(targetQuarkusSourceS2iSettingsMvnFilename);
    }

    private void prepareJavaCaCerts(boolean replaceJavaCaCerts) {
        if (this.isDefaultTemplate() || this.templateInjectsEtcPkiJava()) {
            Path javaCaCertsPath = Path.of("/etc/pki/java/cacerts", new String[0]);
            if (replaceJavaCaCerts && Files.exists(javaCaCertsPath, new LinkOption[0])) {
                Log.info((String)"Creating '%s' config map with 'cacerts' file".formatted(ETC_PKI_JAVA_CONFIG_MAP_NAME), (Object[])new Object[0]);
                this.client.createConfigMap(ETC_PKI_JAVA_CONFIG_MAP_NAME, javaCaCertsPath);
            } else {
                Log.info((String)"Creating empty '%s' config map".formatted(ETC_PKI_JAVA_CONFIG_MAP_NAME), (Object[])new Object[0]);
                this.client.createEmptyConfigMap(ETC_PKI_JAVA_CONFIG_MAP_NAME);
            }
        }
    }

    private boolean templateInjectsEtcPkiJava() {
        String template = FileUtils.loadFile((String)this.getTemplate());
        return template != null && template.contains(ETC_PKI_JAVA_CONFIG_MAP_NAME);
    }

    private boolean shouldReplaceJavaCaCerts(String remoteRepo) {
        String replaceJavaCaCertsAsString = REPLACE_JAVA_CA_CERTS.get(this.model.getContext());
        if (replaceJavaCaCertsAsString == null || replaceJavaCaCertsAsString.isEmpty()) {
            return remoteRepo.contains(".quarkus-qe.");
        }
        return Boolean.parseBoolean(replaceJavaCaCertsAsString);
    }

    private boolean isDefaultTemplate() {
        return this.getDefaultTemplate().equals(this.getTemplate());
    }
}

