/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.quarkus;

import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.configuration.Configuration;
import io.quarkus.test.logging.Log;
import io.quarkus.test.openshift.utils.OpenShiftPropertiesUtils;
import io.quarkus.test.security.certificate.ServingCertificateConfig;
import io.quarkus.test.services.quarkus.OpenShiftQuarkusApplicationManagedResource;
import io.quarkus.test.services.quarkus.QuarkusApplicationManagedResourceBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class TemplateOpenShiftQuarkusApplicationManagedResource<T extends QuarkusApplicationManagedResourceBuilder>
extends OpenShiftQuarkusApplicationManagedResource<T> {
    private static final String DEPLOYMENT = "openshift.yml";
    private static final String QUARKUS_HTTP_PORT_PROPERTY = "quarkus.http.port";
    private static final int INTERNAL_PORT_DEFAULT = 8080;

    public TemplateOpenShiftQuarkusApplicationManagedResource(T model) {
        super(model);
    }

    protected abstract String getDefaultTemplate();

    protected String replaceDeploymentContent(String content) {
        return content;
    }

    @Override
    protected void doInit() {
        this.applyTemplate();
        this.awaitForImageStreams();
    }

    @Override
    protected void doUpdate() {
        this.applyTemplate();
    }

    protected int getInternalPort() {
        if (this.isHttpsScenario()) {
            return OpenShiftPropertiesUtils.getInternalHttpsPort(this.model.getContext());
        }
        return this.model.getContext().getOwner().getProperty(QUARKUS_HTTP_PORT_PROPERTY).filter(StringUtils::isNotBlank).map(Integer::parseInt).orElse(8080);
    }

    private boolean isHttpsScenario() {
        return this.model.isSslEnabled() && ServingCertificateConfig.isServingCertificateScenario((ServiceContext)this.model.getContext());
    }

    protected Map<String, String> addExtraTemplateProperties() {
        return Collections.emptyMap();
    }

    protected final String getTemplate() {
        return this.model.getContext().getOwner().getConfiguration().getOrDefault(Configuration.Property.OPENSHIFT_DEPLOYMENT_TEMPLATE_PROPERTY, this.getDefaultTemplate());
    }

    private void applyTemplate() {
        String deploymentFile = this.getTemplate();
        this.client.applyServicePropertiesUsingTemplate(this.model.getContext().getOwner(), deploymentFile, this::internalReplaceDeploymentContent, this.addExtraTemplateProperties(), this.model.getContext().getServiceFolder().resolve(DEPLOYMENT));
    }

    private String internalReplaceDeploymentContent(String content) {
        String customServiceName = this.model.getContext().getOwner().getConfiguration().get(Configuration.Property.OPENSHIFT_DEPLOYMENT_SERVICE_PROPERTY);
        if (StringUtils.isNotEmpty((CharSequence)customServiceName)) {
            content = content.replaceAll(Pattern.quote(customServiceName), this.model.getContext().getOwner().getName());
        }
        int ingressInternalPort = this.isHttpsScenario() ? 443 : this.getInternalPort();
        content = content.replaceAll(Pattern.quote("${SERVICE_NAME}"), this.model.getContext().getName()).replaceAll(Pattern.quote("${INTERNAL_PORT}"), "" + this.getInternalPort()).replaceAll(Pattern.quote("${INTERNAL_INGRESS_PORT}"), "" + ingressInternalPort).replace("${MANAGEMENT_PORT}", "" + this.model.getManagementPort());
        return this.replaceDeploymentContent(content);
    }

    private void awaitForImageStreams() {
        Log.info((Service)this.model.getContext().getOwner(), (String)"Waiting for image streams ... ", (Object[])new Object[0]);
        this.client.awaitFor(this.model.getContext().getOwner(), this.model.getContext().getServiceFolder().resolve(DEPLOYMENT));
    }
}

