/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.ManagedResource;
import io.quarkus.test.bootstrap.ServiceContext;
import io.quarkus.test.services.AmqContainer;
import io.quarkus.test.services.containers.AmqContainerManagedResourceBinding;
import io.quarkus.test.services.containers.ContainerManagedResourceBuilder;
import io.quarkus.test.services.containers.GenericDockerContainerManagedResource;
import io.quarkus.test.services.containers.model.AmqProtocol;
import io.quarkus.test.utils.PropertiesUtils;
import java.lang.annotation.Annotation;
import java.util.ServiceLoader;

public class AmqContainerManagedResourceBuilder
extends ContainerManagedResourceBuilder {
    private final ServiceLoader<AmqContainerManagedResourceBinding> managedResourceBindingsRegistry = ServiceLoader.load(AmqContainerManagedResourceBinding.class);
    private ServiceContext context;
    private String image;
    private String expectedLog;
    private AmqProtocol protocol;

    protected String getImage() {
        return this.image;
    }

    protected String getExpectedLog() {
        return this.expectedLog;
    }

    protected Integer getPort() {
        return this.protocol.getPort();
    }

    protected ServiceContext getContext() {
        return this.context;
    }

    protected AmqProtocol getProtocol() {
        return this.protocol;
    }

    public void init(Annotation annotation) {
        AmqContainer metadata = (AmqContainer)annotation;
        this.image = PropertiesUtils.resolveProperty((String)metadata.image());
        this.expectedLog = PropertiesUtils.resolveProperty((String)metadata.expectedLog());
        this.protocol = metadata.protocol();
    }

    public ManagedResource build(ServiceContext context) {
        this.context = context;
        for (AmqContainerManagedResourceBinding binding : this.managedResourceBindingsRegistry) {
            if (!binding.appliesFor(this)) continue;
            return binding.init(this);
        }
        return new GenericDockerContainerManagedResource((ContainerManagedResourceBuilder)this);
    }
}

