/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.bootstrap;

import io.quarkus.test.bootstrap.BaseService;
import io.quarkus.test.bootstrap.Protocol;
import io.quarkus.test.services.URILike;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.Configuration;

public class KeycloakService
extends BaseService<KeycloakService> {
    private static final String REALM_DEST_PATH = "/opt/keycloak/data/import";
    private static final String USER = "admin";
    private static final String PASSWORD = "admin";
    private static final int HTTP_80 = 80;
    private String realmBasePath = "auth/realms";
    private final String realm;

    public KeycloakService(String realmFile, String realmName, String realmBasePath) {
        this(realmName);
        this.realmBasePath = this.normalizeRealmBasePath(realmBasePath);
        this.withProperty("KEYCLOAK_IMPORT", "resource::" + realmFile);
        this.withProperty("KEYCLOAK_REALM_IMPORT", "resource_with_destination::/opt/keycloak/data/import|" + realmFile);
    }

    @Deprecated
    public KeycloakService(String realmFile, String realmName) {
        this(realmName);
        this.withProperty("KEYCLOAK_IMPORT", "resource::" + realmFile);
        this.withProperty("KEYCLOAK_REALM_IMPORT", "resource_with_destination::/opt/keycloak/data/import|" + realmFile);
    }

    public KeycloakService(String realmName) {
        this.realm = realmName;
        this.withProperty("KEYCLOAK_ADMIN", "admin");
        this.withProperty("KEYCLOAK_ADMIN_PASSWORD", "admin");
        this.withProperty("KEYCLOAK_USER", "admin");
        this.withProperty("KEYCLOAK_PASSWORD", "admin");
    }

    public String getRealmUrl() {
        URILike host = this.getURI(Protocol.HTTP);
        int port = host.getPort();
        if (port == 80) {
            port = -1;
        }
        try {
            URI url = new URI(host.getScheme(), host.getUserInfo(), host.getHost(), port, "/" + this.realmBasePath + "/" + this.realm, null, null);
            return url.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public AuthzClient createAuthzClient(String clientId, String clientSecret) {
        return AuthzClient.create((Configuration)new Configuration(StringUtils.substringBefore((String)this.getRealmUrl(), (String)"/realms"), this.realm, clientId, Collections.singletonMap("secret", clientSecret), (HttpClient)HttpClients.createDefault()));
    }

    private String normalizeRealmBasePath(String realmBasePath) {
        if (realmBasePath.startsWith("/")) {
            realmBasePath = realmBasePath.substring(1);
        }
        if (realmBasePath.endsWith("/")) {
            realmBasePath = realmBasePath.substring(0, realmBasePath.length() - 1);
        }
        return realmBasePath;
    }
}

