/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.services.containers;

import io.quarkus.test.bootstrap.Service;
import io.quarkus.test.logging.Log;
import io.quarkus.test.services.containers.ContainerManagedResourceBuilder;
import io.quarkus.test.services.containers.GenericDockerContainerManagedResource;
import io.quarkus.test.services.containers.KeycloakContainerManagedResourceBuilder;
import io.quarkus.test.utils.DockerUtils;
import org.apache.commons.lang3.StringUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class KeycloakGenericDockerContainerManagedResource
extends GenericDockerContainerManagedResource {
    private static final String PRIVILEGED_MODE = "container.privileged-mode";
    private static final String REUSABLE_MODE = "container.reusable";
    private final KeycloakContainerManagedResourceBuilder model;

    protected KeycloakGenericDockerContainerManagedResource(KeycloakContainerManagedResourceBuilder model) {
        super((ContainerManagedResourceBuilder)model);
        this.model = model;
    }

    protected GenericContainer<?> initContainer() {
        GenericContainer container = new GenericContainer(this.model.getImage());
        if (StringUtils.isNotBlank((CharSequence)this.model.getExpectedLog())) {
            container.waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*" + this.model.getExpectedLog() + ".*\\s"));
        }
        if (this.model.getCommand() != null && this.model.getCommand().length > 0) {
            container.withCommand(this.model.getCommand());
        }
        if (this.isPrivileged()) {
            Log.info((Service)this.model.getContext().getOwner(), (String)"Running container on Privileged mode", (Object[])new Object[0]);
            container.setPrivilegedMode(true);
        }
        container.withCreateContainerCmdModifier(cmd -> cmd.withName(DockerUtils.generateDockerContainerName()));
        if (this.isReusable()) {
            Log.info((Service)this.model.getContext().getOwner(), (String)"Running container on Reusable mode", (Object[])new Object[0]);
            Log.warn((Service)this.model.getContext().getOwner(), (String)"Reusable mode expose testcontainers 'withReuse' method that is tagged as UnstableAPI, so is a subject to change and SHOULD NOT be considered a stable API", (Object[])new Object[0]);
            container.withReuse(true);
        }
        container.withExposedPorts(new Integer[]{this.model.getPort()});
        return container;
    }

    public void stop() {
        if (!this.isReusable()) {
            super.stop();
        }
    }

    protected boolean isReusable() {
        return this.model.getContext().getOwner().getConfiguration().isTrue(REUSABLE_MODE);
    }

    private boolean isPrivileged() {
        return this.model.getContext().getOwner().getConfiguration().isTrue(PRIVILEGED_MODE);
    }
}

