/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.amazon.lambda.http.model.Headers;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AwsProxyResponse {
    private int statusCode;
    private String statusDescription;
    private Map<String, String> headers;
    private Headers multiValueHeaders;
    private String body;
    private boolean isBase64Encoded;

    public AwsProxyResponse() {
    }

    public AwsProxyResponse(int statusCode) {
        this(statusCode, null);
    }

    public AwsProxyResponse(int statusCode, Headers headers) {
        this(statusCode, headers, null);
    }

    public AwsProxyResponse(int statusCode, Headers headers, String body) {
        this.statusCode = statusCode;
        this.multiValueHeaders = headers;
        this.body = body;
    }

    public void addHeader(String key, String value) {
        if (this.multiValueHeaders == null) {
            this.multiValueHeaders = new Headers();
        }
        this.multiValueHeaders.add(key, value);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Headers getMultiValueHeaders() {
        return this.multiValueHeaders;
    }

    public void setMultiValueHeaders(Headers multiValueHeaders) {
        this.multiValueHeaders = multiValueHeaders;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @JsonProperty(value="isBase64Encoded")
    public boolean isBase64Encoded() {
        return this.isBase64Encoded;
    }

    public void setBase64Encoded(boolean base64Encoded) {
        this.isBase64Encoded = base64Encoded;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }
}

