/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BuildExclusionsBuildItem;
import io.quarkus.arc.deployment.BuildTimeConditionBuildItem;
import io.quarkus.arc.deployment.PreAdditionalBeanBuildTimeConditionBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.profile.IfBuildProfile;
import io.quarkus.arc.profile.UnlessBuildProfile;
import io.quarkus.arc.properties.IfBuildProperty;
import io.quarkus.arc.properties.UnlessBuildProperty;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.runtime.configuration.ProfileManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class BuildTimeEnabledProcessor {
    private static final Logger LOGGER = Logger.getLogger(BuildTimeEnabledProcessor.class);
    private static final DotName IF_BUILD_PROFILE = DotName.createSimple((String)IfBuildProfile.class.getName());
    private static final DotName UNLESS_BUILD_PROFILE = DotName.createSimple((String)UnlessBuildProfile.class.getName());
    private static final DotName IF_BUILD_PROPERTY = DotName.createSimple((String)IfBuildProperty.class.getName());
    private static final DotName UNLESS_BUILD_PROPERTY = DotName.createSimple((String)UnlessBuildProperty.class.getName());

    @BuildStep
    void ifBuildProfile(CombinedIndexBuildItem index, BuildProducer<BuildTimeConditionBuildItem> producer, BuildProducer<PreAdditionalBeanBuildTimeConditionBuildItem> producerPreAdditionalBean) {
        Collection annotationInstances = index.getIndex().getAnnotations(IF_BUILD_PROFILE);
        for (AnnotationInstance instance : annotationInstances) {
            String profileOnInstance = instance.value().asString();
            boolean enabled = profileOnInstance.equals(ProfileManager.getActiveProfile());
            if (enabled) {
                LOGGER.debug((Object)("Enabling " + instance.target() + " since the profile value matches the active profile."));
            } else {
                LOGGER.debug((Object)("Disabling " + instance.target() + " since the profile value does not match the active profile."));
            }
            producer.produce((BuildItem)new BuildTimeConditionBuildItem(instance.target(), enabled));
            producerPreAdditionalBean.produce((BuildItem)new PreAdditionalBeanBuildTimeConditionBuildItem(instance.target(), enabled));
        }
    }

    @BuildStep
    void unlessBuildProfile(CombinedIndexBuildItem index, BuildProducer<BuildTimeConditionBuildItem> producer, BuildProducer<PreAdditionalBeanBuildTimeConditionBuildItem> producerPreAdditionalBean) {
        Collection annotationInstances = index.getIndex().getAnnotations(UNLESS_BUILD_PROFILE);
        for (AnnotationInstance instance : annotationInstances) {
            boolean enabled;
            String profileOnInstance = instance.value().asString();
            boolean bl = enabled = !profileOnInstance.equals(ProfileManager.getActiveProfile());
            if (enabled) {
                LOGGER.debug((Object)("Enabling " + instance.target() + " since the profile value does not match the active profile."));
            } else {
                LOGGER.debug((Object)("Disabling " + instance.target() + " since the profile value matches the active profile."));
            }
            producer.produce((BuildItem)new BuildTimeConditionBuildItem(instance.target(), enabled));
            producerPreAdditionalBean.produce((BuildItem)new PreAdditionalBeanBuildTimeConditionBuildItem(instance.target(), enabled));
        }
    }

    @BuildStep
    void ifBuildProperty(BeanArchiveIndexBuildItem index, final BuildProducer<BuildTimeConditionBuildItem> producer) {
        this.buildProperty(IF_BUILD_PROPERTY, new BiFunction<String, String, Boolean>(){

            @Override
            public Boolean apply(String stringValue, String expectedStringValue) {
                return stringValue.equals(expectedStringValue);
            }
        }, index.getIndex(), new BiConsumer<AnnotationTarget, Boolean>(){

            @Override
            public void accept(AnnotationTarget target, Boolean enabled) {
                producer.produce((BuildItem)new BuildTimeConditionBuildItem(target, enabled));
            }
        });
    }

    @BuildStep
    void unlessBuildProperty(BeanArchiveIndexBuildItem index, final BuildProducer<BuildTimeConditionBuildItem> producer) {
        this.buildProperty(UNLESS_BUILD_PROPERTY, new BiFunction<String, String, Boolean>(){

            @Override
            public Boolean apply(String stringValue, String expectedStringValue) {
                return !stringValue.equals(expectedStringValue);
            }
        }, index.getIndex(), new BiConsumer<AnnotationTarget, Boolean>(){

            @Override
            public void accept(AnnotationTarget target, Boolean enabled) {
                producer.produce((BuildItem)new BuildTimeConditionBuildItem(target, enabled));
            }
        });
    }

    @BuildStep
    void ifBuildPropertyPreAdditionalBean(CombinedIndexBuildItem index, final BuildProducer<PreAdditionalBeanBuildTimeConditionBuildItem> producer) {
        this.buildProperty(IF_BUILD_PROPERTY, new BiFunction<String, String, Boolean>(){

            @Override
            public Boolean apply(String stringValue, String expectedStringValue) {
                return stringValue.equals(expectedStringValue);
            }
        }, index.getIndex(), new BiConsumer<AnnotationTarget, Boolean>(){

            @Override
            public void accept(AnnotationTarget target, Boolean enabled) {
                producer.produce((BuildItem)new PreAdditionalBeanBuildTimeConditionBuildItem(target, enabled));
            }
        });
    }

    @BuildStep
    void unlessBuildPropertyPreAdditionalBean(CombinedIndexBuildItem index, final BuildProducer<PreAdditionalBeanBuildTimeConditionBuildItem> producer) {
        this.buildProperty(UNLESS_BUILD_PROPERTY, new BiFunction<String, String, Boolean>(){

            @Override
            public Boolean apply(String stringValue, String expectedStringValue) {
                return !stringValue.equals(expectedStringValue);
            }
        }, index.getIndex(), new BiConsumer<AnnotationTarget, Boolean>(){

            @Override
            public void accept(AnnotationTarget target, Boolean enabled) {
                producer.produce((BuildItem)new PreAdditionalBeanBuildTimeConditionBuildItem(target, enabled));
            }
        });
    }

    void buildProperty(DotName annotationName, BiFunction<String, String, Boolean> testFun, IndexView index, BiConsumer<AnnotationTarget, Boolean> producer) {
        Config config = ConfigProviderResolver.instance().getConfig();
        Collection annotationInstances = index.getAnnotations(annotationName);
        for (AnnotationInstance instance : annotationInstances) {
            boolean enabled;
            String propertyName = instance.value("name").asString();
            String expectedStringValue = instance.value("stringValue").asString();
            AnnotationValue enableIfMissingValue = instance.value("enableIfMissing");
            boolean enableIfMissing = enableIfMissingValue != null && enableIfMissingValue.asBoolean();
            Optional optionalValue = config.getOptionalValue(propertyName, String.class);
            if (optionalValue.isPresent()) {
                if (testFun.apply((String)optionalValue.get(), expectedStringValue).booleanValue()) {
                    LOGGER.debug((Object)("Enabling " + instance.target() + " since the property value matches the expected one."));
                    enabled = true;
                } else {
                    LOGGER.debug((Object)("Disabling " + instance.target() + " since the property value matches the specified value one."));
                    enabled = false;
                }
            } else if (enableIfMissing) {
                LOGGER.debug((Object)("Enabling " + instance.target() + " since the property has not been set and 'enableIfMissing' is set to 'true'."));
                enabled = true;
            } else {
                LOGGER.debug((Object)("Disabling " + instance.target() + " since the property has not been set and 'enableIfMissing' is set to 'false'."));
                enabled = false;
            }
            producer.accept(instance.target(), enabled);
        }
    }

    @BuildStep
    void conditionTransformer(List<BuildTimeConditionBuildItem> buildTimeConditions, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        if (buildTimeConditions.isEmpty()) {
            return;
        }
        final HashMap<DotName, Boolean> classTargets = new HashMap<DotName, Boolean>();
        final HashMap<String, Boolean> fieldTargets = new HashMap<String, Boolean>();
        final HashMap<MethodInfo, Boolean> methodTargets = new HashMap<MethodInfo, Boolean>();
        for (BuildTimeConditionBuildItem buildTimeCondition : buildTimeConditions) {
            String uniqueFieldName;
            Boolean allPreviousConditionsTrue;
            AnnotationTarget target = buildTimeCondition.getTarget();
            AnnotationTarget.Kind kind = target.kind();
            if (kind == AnnotationTarget.Kind.CLASS) {
                DotName classDotName;
                allPreviousConditionsTrue = classTargets.getOrDefault(classDotName = target.asClass().name(), true);
                classTargets.put(classDotName, allPreviousConditionsTrue != false && buildTimeCondition.isEnabled());
                continue;
            }
            if (kind == AnnotationTarget.Kind.METHOD) {
                MethodInfo method;
                allPreviousConditionsTrue = methodTargets.getOrDefault(method = target.asMethod(), true);
                methodTargets.put(method, allPreviousConditionsTrue != false && buildTimeCondition.isEnabled());
                continue;
            }
            if (kind != AnnotationTarget.Kind.FIELD) continue;
            allPreviousConditionsTrue = fieldTargets.getOrDefault(uniqueFieldName = this.toUniqueString(target.asField()), true);
            fieldTargets.put(uniqueFieldName, allPreviousConditionsTrue != false && buildTimeCondition.isEnabled());
        }
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                FieldInfo field;
                String uniqueFieldName;
                AnnotationTarget target = ctx.getTarget();
                if (ctx.isClass()) {
                    DotName classDotName = target.asClass().name();
                    if (classTargets.containsKey(classDotName)) {
                        BuildTimeEnabledProcessor.this.transformBean(target, ctx, (Boolean)classTargets.get(classDotName));
                    }
                } else if (ctx.isMethod()) {
                    MethodInfo method = target.asMethod();
                    if (methodTargets.containsKey(method)) {
                        BuildTimeEnabledProcessor.this.transformBean(target, ctx, (Boolean)methodTargets.get(method));
                    }
                } else if (ctx.isField() && fieldTargets.containsKey(uniqueFieldName = BuildTimeEnabledProcessor.this.toUniqueString(field = target.asField()))) {
                    BuildTimeEnabledProcessor.this.transformBean(target, ctx, (Boolean)fieldTargets.get(uniqueFieldName));
                }
            }
        }));
    }

    @BuildStep
    BuildExclusionsBuildItem buildExclusions(List<PreAdditionalBeanBuildTimeConditionBuildItem> buildTimeConditions) {
        Map map = buildTimeConditions.stream().filter(item -> !item.isEnabled()).map(PreAdditionalBeanBuildTimeConditionBuildItem::getTarget).collect(Collectors.groupingBy(AnnotationTarget::kind, Collectors.mapping(BuildExclusionsBuildItem::targetMapper, Collectors.toSet())));
        return new BuildExclusionsBuildItem(map.getOrDefault(AnnotationTarget.Kind.CLASS, Collections.emptySet()), map.getOrDefault(AnnotationTarget.Kind.METHOD, Collections.emptySet()), map.getOrDefault(AnnotationTarget.Kind.FIELD, Collections.emptySet()));
    }

    private String toUniqueString(FieldInfo field) {
        return field.declaringClass().name().toString() + "." + field.name();
    }

    private void transformBean(AnnotationTarget target, AnnotationsTransformer.TransformationContext ctx, boolean enabled) {
        if (!enabled) {
            Transformation transform = ctx.transform();
            if (target.kind() == AnnotationTarget.Kind.CLASS) {
                transform.add(DotNames.VETOED, new AnnotationValue[0]);
            } else {
                transform.add(DotNames.VETOED_PRODUCER, new AnnotationValue[0]);
            }
            transform.done();
        }
    }
}

