/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.gizmo.ClassOutput;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GeneratedBeanGizmoAdaptor
implements ClassOutput {
    private final BuildProducer<GeneratedBeanBuildItem> classOutput;
    private final Map<String, StringWriter> sources;

    public GeneratedBeanGizmoAdaptor(BuildProducer<GeneratedBeanBuildItem> classOutput) {
        this.classOutput = classOutput;
        this.sources = BootstrapDebug.DEBUG_SOURCES_DIR != null ? new ConcurrentHashMap() : null;
    }

    public void write(String className, byte[] bytes) {
        StringWriter sw;
        String source = null;
        if (this.sources != null && (sw = this.sources.get(className)) != null) {
            source = sw.toString();
        }
        this.classOutput.produce((BuildItem)new GeneratedBeanBuildItem(className, bytes, source));
    }

    public Writer getSourceWriter(String className) {
        if (this.sources != null) {
            StringWriter writer = new StringWriter();
            this.sources.put(className, writer);
            return writer;
        }
        return super.getSourceWriter(className);
    }
}

