/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.processor.BeanConfiguratorBase;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.runtime.RuntimeValue;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class SyntheticBeanBuildItem
extends MultiBuildItem {
    private final ExtendedBeanConfigurator configurator;

    public static ExtendedBeanConfigurator configure(Class<?> implClazz) {
        return SyntheticBeanBuildItem.configure(DotName.createSimple((String)implClazz.getName()));
    }

    public static ExtendedBeanConfigurator configure(DotName implClazz) {
        return (ExtendedBeanConfigurator)new ExtendedBeanConfigurator(implClazz).addType(implClazz);
    }

    SyntheticBeanBuildItem(ExtendedBeanConfigurator configurator) {
        this.configurator = configurator;
    }

    ExtendedBeanConfigurator configurator() {
        return this.configurator;
    }

    boolean isStaticInit() {
        return this.configurator.staticInit;
    }

    boolean hasRecorderInstance() {
        return this.configurator.supplier != null || this.configurator.runtimeValue != null || this.configurator.fun != null || this.configurator.runtimeProxy != null;
    }

    boolean hasCheckActiveSupplier() {
        return this.configurator.checkActive != null;
    }

    public static class ExtendedBeanConfigurator
    extends BeanConfiguratorBase<ExtendedBeanConfigurator, Object> {
        private Object runtimeProxy;
        private Supplier<?> supplier;
        private RuntimeValue<?> runtimeValue;
        private Function<SyntheticCreationalContext<?>, ?> fun;
        private boolean staticInit = true;
        private Supplier<ActiveResult> checkActive;

        ExtendedBeanConfigurator(DotName implClazz) {
            super(implClazz);
        }

        public SyntheticBeanBuildItem done() {
            if (this.supplier == null && this.runtimeValue == null && this.fun == null && this.runtimeProxy == null && this.creatorConsumer == null) {
                throw new IllegalStateException("Synthetic bean does not provide a creation method, use ExtendedBeanConfigurator#creator(), ExtendedBeanConfigurator#supplier(), ExtendedBeanConfigurator#createWith() or ExtendedBeanConfigurator#runtimeValue()");
            }
            if (this.checkActive != null && this.supplier == null && this.runtimeValue == null && this.fun == null && this.runtimeProxy == null) {
                throw new IllegalStateException("Synthetic bean has ExtendedBeanConfigurator#checkActive(), but does not have ExtendedBeanConfigurator#supplier() / createWith() / runtimeValue() / runtimeProxy()");
            }
            return new SyntheticBeanBuildItem(this);
        }

        public ExtendedBeanConfigurator supplier(Supplier<?> supplier) {
            this.checkReturnedProxy(supplier);
            this.checkMultipleCreationMethods();
            this.supplier = Objects.requireNonNull(supplier);
            return this;
        }

        public ExtendedBeanConfigurator runtimeValue(RuntimeValue<?> runtimeValue) {
            this.checkReturnedProxy(runtimeValue);
            this.checkMultipleCreationMethods();
            this.runtimeValue = Objects.requireNonNull(runtimeValue);
            return this;
        }

        public <B> ExtendedBeanConfigurator createWith(Function<SyntheticCreationalContext<B>, B> function) {
            this.checkReturnedProxy(function);
            this.checkMultipleCreationMethods();
            this.fun = (Function)ExtendedBeanConfigurator.cast(Objects.requireNonNull(function));
            return this;
        }

        public ExtendedBeanConfigurator runtimeProxy(Object proxy) {
            this.checkReturnedProxy(proxy);
            this.checkMultipleCreationMethods();
            this.runtimeProxy = Objects.requireNonNull(proxy);
            return this;
        }

        public ExtendedBeanConfigurator setRuntimeInit() {
            this.staticInit = false;
            return this;
        }

        public ExtendedBeanConfigurator checkActive(Supplier<ActiveResult> checkActive) {
            this.checkReturnedProxy(checkActive);
            this.checkActive = Objects.requireNonNull(checkActive);
            return this;
        }

        DotName getImplClazz() {
            return this.implClazz;
        }

        Set<Type> getTypes() {
            return this.types;
        }

        Set<AnnotationInstance> getQualifiers() {
            return this.qualifiers;
        }

        String getIdentifier() {
            return this.identifier;
        }

        Supplier<?> getSupplier() {
            return this.supplier;
        }

        RuntimeValue<?> getRuntimeValue() {
            return this.runtimeValue;
        }

        Function<SyntheticCreationalContext<?>, ?> getFunction() {
            return this.fun;
        }

        Object getRuntimeProxy() {
            return this.runtimeProxy;
        }

        Supplier<ActiveResult> getCheckActive() {
            return this.checkActive;
        }

        private void checkMultipleCreationMethods() {
            if (this.runtimeProxy == null && this.runtimeValue == null && this.supplier == null && this.fun == null) {
                return;
            }
            throw new IllegalStateException("It is not possible to specify multiple creation methods");
        }

        private void checkReturnedProxy(Object object) {
            if (object instanceof BytecodeRecorderImpl.ReturnedProxy) {
                return;
            }
            throw new IllegalArgumentException("The object is not a proxy returned from a recorder method: " + object.toString());
        }
    }
}

