/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.runtime.annotations.Template;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@Template
public class ConfigDeploymentTemplate {
    public void validateConfigProperties(Map<String, Class<?>> properties) {
        Config config = ConfigProvider.getConfig();
        for (Map.Entry<String, Class<?>> entry : properties.entrySet()) {
            Class<Object> propertyType = entry.getValue();
            if (Collection.class.isAssignableFrom(propertyType)) {
                propertyType = String.class;
            }
            if (config.getOptionalValue(entry.getKey(), propertyType).isPresent()) continue;
            throw new DeploymentException("No config value of type " + entry.getValue() + " exists for: " + entry.getKey());
        }
    }
}

