/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sbom;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.sbom.ApplicationComponent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApplicationManifestConfig {
    private Path distDir;
    private Path runnerPath;
    private ApplicationComponent main;
    private List<ApplicationComponent> components = List.of();

    public static Builder builder() {
        return new ApplicationManifestConfig().new Builder();
    }

    private ApplicationManifestConfig() {
    }

    public Path getDistributionDirectory() {
        return this.distDir;
    }

    public Path getRunnerPath() {
        return this.runnerPath;
    }

    public ApplicationComponent getMainComponent() {
        return this.main;
    }

    public Collection<ApplicationComponent> getComponents() {
        return this.components;
    }

    public class Builder {
        private boolean built;
        private ComponentHolder main;
        private Map<ArtifactKey, ComponentHolder> compArtifacts = new HashMap<ArtifactKey, ComponentHolder>();
        private Map<Path, ComponentHolder> compPaths = new HashMap<Path, ComponentHolder>();
        private List<ComponentHolder> compList = new ArrayList<ComponentHolder>();

        private Builder() {
        }

        public Builder setApplicationModel(ApplicationModel model) {
            this.setMainComponent(ApplicationComponent.builder().setResolvedDependency(model.getAppArtifact()).build());
            for (ResolvedDependency d : model.getDependencies()) {
                this.addComponent(ApplicationComponent.builder().setResolvedDependency(d).setPath((Path)d.getResolvedPaths().iterator().next()).build());
            }
            return this;
        }

        public Builder setMainComponent(ApplicationComponent applicationRunner) {
            this.ensureNotBuilt();
            this.main = applicationRunner == null ? null : new ComponentHolder(applicationRunner);
            return this;
        }

        public Builder setDistributionDirectory(Path distributionDirectory) {
            this.ensureNotBuilt();
            ApplicationManifestConfig.this.distDir = distributionDirectory;
            return this;
        }

        public Builder setRunnerPath(Path runnerPath) {
            this.ensureNotBuilt();
            ApplicationManifestConfig.this.runnerPath = runnerPath;
            return this;
        }

        public Builder addComponent(ApplicationComponent component) {
            ComponentHolder holder = null;
            if (component.getPath() != null) {
                holder = this.compPaths.get(component.getPath());
            }
            if (holder == null && component.getResolvedDependency() != null) {
                holder = this.compArtifacts.get(component.getResolvedDependency().getKey());
            }
            if (holder == null) {
                holder = new ComponentHolder(component);
                if (holder.path != null) {
                    this.compPaths.put(holder.path, holder);
                }
                if (holder.component.getResolvedDependency() != null) {
                    this.compArtifacts.put(holder.component.getResolvedDependency().getKey(), holder);
                }
                this.compList.add(holder);
            } else {
                if (component.getPath() != null) {
                    if (holder.path != null) {
                        this.compPaths.remove(holder.path);
                    }
                    holder.path = component.getPath();
                    this.compPaths.put(holder.path, holder);
                }
                if (holder.component.getResolvedDependency() == null && component.getResolvedDependency() != null) {
                    holder.component = component;
                    this.compArtifacts.put(holder.component.getResolvedDependency().getKey(), holder);
                }
                if (component.getPedigree() != null) {
                    if (holder.component.getPedigree() == null) {
                        holder.component.pedigree = component.getPedigree();
                    } else if (!holder.component.getPedigree().contains(component.getPedigree())) {
                        holder.component.pedigree = holder.component.pedigree + System.lineSeparator() + component.getPedigree();
                    }
                }
                if (component.getScope() != null) {
                    holder.component.scope = component.scope;
                }
            }
            return this;
        }

        public ApplicationManifestConfig build() {
            this.ensureNotBuilt();
            Objects.requireNonNull(this.main, "mainComponent is null");
            this.built = true;
            if (!this.compList.isEmpty()) {
                ApplicationManifestConfig.this.components = new ArrayList<ApplicationComponent>(this.compList.size());
                for (ComponentHolder holder : this.compList) {
                    if (holder.path != null && !holder.path.equals(holder.component.getPath())) {
                        holder.component = ApplicationComponent.builder().setPath(holder.path).setResolvedDependency(holder.component.getResolvedDependency()).setPedigree(holder.component.getPedigree());
                    }
                    if (ApplicationManifestConfig.this.distDir != null) {
                        this.setDistributionPath(holder, false);
                    }
                    ApplicationManifestConfig.this.components.add(holder.component.ensureImmutable());
                }
            }
            if (ApplicationManifestConfig.this.distDir != null) {
                this.setDistributionPath(this.main, true);
            }
            ApplicationManifestConfig.this.main = this.main.component.ensureImmutable();
            return ApplicationManifestConfig.this;
        }

        private void setDistributionPath(ComponentHolder holder, boolean main) {
            ApplicationComponent c = holder.component;
            if (c.getDistributionPath() == null && c.getPath() != null && c.getPath().startsWith(ApplicationManifestConfig.this.distDir)) {
                ApplicationComponent.Builder builder;
                if (c instanceof ApplicationComponent.Builder) {
                    builder = (ApplicationComponent.Builder)c;
                } else {
                    builder = new ApplicationComponent.Builder(c);
                    if (!main) {
                        holder.component = builder;
                    }
                }
                Path relativePath = ApplicationManifestConfig.this.distDir.relativize(c.getPath());
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < relativePath.getNameCount(); ++i) {
                    if (i > 0) {
                        sb.append("/");
                    }
                    sb.append(relativePath.getName(i));
                }
                builder.setDistributionPath(sb.toString());
            }
        }

        private void ensureNotBuilt() {
            if (this.built) {
                throw new RuntimeException("This builder instance has already been built");
            }
        }

        private class ComponentHolder {
            private Path path;
            private ApplicationComponent component;

            private ComponentHolder(ApplicationComponent component) {
                this.component = component;
                this.path = component.getPath();
            }
        }
    }
}

