/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.ManifestAttributes;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MultiRootPathTree
implements OpenPathTree {
    private final PathTree[] trees;
    private final List<Path> roots;

    public MultiRootPathTree(PathTree ... trees) {
        this.trees = trees;
        ArrayList<Path> tmp = new ArrayList<Path>();
        for (PathTree t : trees) {
            tmp.addAll(t.getRoots());
        }
        tmp.trimToSize();
        this.roots = tmp;
    }

    @Override
    public Collection<Path> getRoots() {
        return this.roots;
    }

    @Override
    public ManifestAttributes getManifestAttributes() {
        for (PathTree tree : this.trees) {
            ManifestAttributes m = tree.getManifestAttributes();
            if (m == null) continue;
            return m;
        }
        return null;
    }

    @Override
    public void walk(PathVisitor visitor) {
        if (this.trees.length == 0) {
            return;
        }
        for (PathTree t : this.trees) {
            t.walk(visitor);
        }
    }

    @Override
    public void walkIfContains(String relativePath, PathVisitor visitor) {
        if (this.trees.length == 0) {
            return;
        }
        for (PathTree t : this.trees) {
            t.walkIfContains(relativePath, visitor);
        }
    }

    @Override
    public <T> T apply(String relativePath, Function<PathVisit, T> func) {
        for (PathTree tree : this.trees) {
            T result = tree.apply(relativePath, func);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void accept(String relativePath, final Consumer<PathVisit> func) {
        final AtomicBoolean consumed = new AtomicBoolean();
        Consumer<PathVisit> wrapper = new Consumer<PathVisit>(){

            @Override
            public void accept(PathVisit t) {
                if (t != null) {
                    func.accept(t);
                    consumed.set(true);
                }
            }
        };
        for (PathTree tree : this.trees) {
            tree.accept(relativePath, wrapper);
            if (consumed.get()) break;
        }
        if (!consumed.get()) {
            func.accept(null);
        }
    }

    @Override
    public void acceptAll(String relativePath, final Consumer<PathVisit> func) {
        final AtomicBoolean consumed = new AtomicBoolean();
        Consumer<PathVisit> wrapper = new Consumer<PathVisit>(){

            @Override
            public void accept(PathVisit t) {
                if (t != null) {
                    func.accept(t);
                    consumed.set(true);
                }
            }
        };
        for (PathTree tree : this.trees) {
            tree.accept(relativePath, wrapper);
        }
        if (!consumed.get()) {
            func.accept(null);
        }
    }

    @Override
    public boolean contains(String relativePath) {
        for (PathTree tree : this.trees) {
            if (!tree.contains(relativePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Path getPath(String relativePath) {
        for (PathTree tree : this.trees) {
            if (tree instanceof OpenPathTree) {
                Path p = ((OpenPathTree)tree).getPath(relativePath);
                if (p == null) continue;
                return p;
            }
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public OpenPathTree open() {
        return this;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public PathTree getOriginalTree() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.trees);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiRootPathTree other = (MultiRootPathTree)obj;
        return Arrays.equals(this.trees, other.trees);
    }

    public String toString() {
        return this.roots.stream().map(p -> p.toString()).collect(Collectors.joining(", ", "[", "]"));
    }
}

