/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CapabilityErrors {
    private final Map<String, List<String>> conflicts = new HashMap<String, List<String>>();
    private final Map<String, List<String>> missing = new HashMap<String, List<String>>();

    public void addConflict(String capability, String provider) {
        this.conflicts.computeIfAbsent(capability, k -> new ArrayList()).add(provider);
    }

    public void addMissing(String capability, String consumer) {
        this.missing.computeIfAbsent(capability, k -> new ArrayList()).add(consumer);
    }

    public boolean isEmpty() {
        return this.conflicts.isEmpty() && this.missing.isEmpty();
    }

    public String report() {
        StringWriter sw = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(sw);){
            CapabilityErrors.reportProblems(this.conflicts, false, writer);
            CapabilityErrors.reportProblems(this.missing, true, writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate the capability error report out of conflicts " + this.conflicts + " and unsatisfied " + this.missing, e);
        }
        return sw.getBuffer().toString();
    }

    private static void reportProblems(Map<String, List<String>> problems, boolean missing, BufferedWriter writer) throws IOException {
        if (problems.isEmpty()) {
            return;
        }
        if (missing) {
            writer.write("The following capability requirements aren't satisfied by the Quarkus extensions present on the classpath:");
        } else {
            writer.write("Please make sure there is only one provider of the following capabilities:");
        }
        ArrayList<String> capabilities = new ArrayList<String>(problems.size());
        capabilities.addAll(problems.keySet());
        Collections.sort(capabilities);
        for (String capability : capabilities) {
            writer.newLine();
            writer.append("capability ").append(capability).append(missing ? " is required by:" : " is provided by:");
            List<String> extensions = problems.get(capability);
            Collections.sort(extensions);
            for (String extension : extensions) {
                writer.newLine();
                writer.append("  - ").append(extension);
            }
        }
        writer.newLine();
    }
}

