/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.resolver.TsArtifact;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.fs.util.ZipUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class TsJar
implements TsArtifact.ContentProvider {
    private Path target;
    private Map<String, String> content = Collections.emptyMap();
    private Map<String, Path> paths = Collections.emptyMap();

    public TsJar(Path target) {
        this.target = target;
    }

    public TsJar() {
    }

    @Override
    public Path getPath(Path workDir) throws IOException {
        if (this.target == null) {
            this.target = workDir.resolve(UUID.randomUUID().toString());
        } else if (Files.exists(this.target, new LinkOption[0])) {
            return this.target;
        }
        try (FileSystem zip = this.openZip();){
            Path p;
            if (!this.content.isEmpty()) {
                for (Map.Entry<String, String> entry : this.content.entrySet()) {
                    p = zip.getPath(entry.getKey(), new String[0]);
                    Files.createDirectories(p.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(p, new OpenOption[0]);){
                        writer.write(entry.getValue());
                    }
                }
            }
            if (!this.paths.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.paths.entrySet()) {
                    p = zip.getPath(entry.getKey(), new String[0]);
                    Files.createDirectories(p.getParent(), new FileAttribute[0]);
                    IoUtils.copy((Path)((Path)entry.getValue()), (Path)p);
                }
            }
        }
        return this.target;
    }

    private String getKey(String ... path) {
        if (path.length == 1) {
            return path[0];
        }
        StringBuilder buf = new StringBuilder();
        buf.append(path[0]);
        for (int i = 1; i < path.length; ++i) {
            buf.append('/').append(path[i]);
        }
        return buf.toString();
    }

    private void addContent(String content, String ... path) {
        if (this.content.isEmpty()) {
            this.content = new HashMap<String, String>(1);
        }
        this.content.put(this.getKey(path), content);
    }

    public TsJar addEntry(Path content, String ... path) {
        if (this.paths.isEmpty()) {
            this.paths = new HashMap<String, Path>(1);
        }
        this.paths.put(this.getKey(path), content);
        return this;
    }

    public TsJar addEntry(String content, String ... path) {
        this.addContent(content, path);
        return this;
    }

    public TsJar addEntry(Properties props, String ... path) {
        StringWriter writer = new StringWriter();
        try {
            props.store(writer, "Written by TsJarBuilder");
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize properties", e);
        }
        this.addContent(writer.getBuffer().toString(), path);
        return this;
    }

    public TsJar addMavenMetadata(TsArtifact artifact, Path pomXml) {
        Properties props = new Properties();
        props.setProperty("groupId", artifact.groupId);
        props.setProperty("artifactId", artifact.artifactId);
        props.setProperty("version", artifact.version);
        this.addEntry(props, "META-INF", "maven", artifact.groupId, artifact.artifactId, "pom.properties");
        this.addEntry(pomXml, "META-INF", "maven", artifact.groupId, artifact.artifactId, "pom.xml");
        return this;
    }

    private FileSystem openZip() throws IOException {
        if (Files.exists(this.target, new LinkOption[0])) {
            return ZipUtils.newFileSystem((Path)this.target);
        }
        Files.createDirectories(this.target.getParent(), new FileAttribute[0]);
        return ZipUtils.newZip((Path)this.target);
    }
}

