/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.bootstrap.classloading.PathTreeClassPathElement;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.EmptyPathTree;
import io.quarkus.paths.ManifestAttributes;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathTree;
import java.io.Closeable;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public interface ClassPathElement
extends Closeable {
    public static final ClassPathElement EMPTY = new ClassPathElement(){

        @Override
        public Path getRoot() {
            return null;
        }

        @Override
        public boolean isRuntime() {
            return false;
        }

        @Override
        public <T> T apply(Function<OpenPathTree, T> func) {
            return func.apply((OpenPathTree)EmptyPathTree.getInstance());
        }

        @Override
        public ClassPathResource getResource(String name) {
            return null;
        }

        @Override
        public Set<String> getProvidedResources() {
            return Set.of();
        }

        @Override
        public boolean containsReloadableResources() {
            return false;
        }

        @Override
        public ProtectionDomain getProtectionDomain() {
            return null;
        }

        @Override
        public ManifestAttributes getManifestAttributes() {
            return null;
        }

        @Override
        public void close() {
        }
    };

    default public ArtifactKey getDependencyKey() {
        ResolvedDependency resolvedDependency = this.getResolvedDependency();
        return resolvedDependency != null ? resolvedDependency.getKey() : null;
    }

    default public ResolvedDependency getResolvedDependency() {
        return null;
    }

    public Path getRoot();

    public <T> T apply(Function<OpenPathTree, T> var1);

    public ClassPathResource getResource(String var1);

    public Set<String> getProvidedResources();

    public boolean containsReloadableResources();

    public ProtectionDomain getProtectionDomain();

    public ManifestAttributes getManifestAttributes();

    public boolean isRuntime();

    public static ClassPathElement fromPath(Path path, boolean runtime) {
        return new PathTreeClassPathElement(PathTree.ofDirectoryOrArchive((Path)path), runtime);
    }

    public static ClassPathElement fromDependency(ResolvedDependency dep) {
        return ClassPathElement.fromDependency(dep.getContentTree(), dep);
    }

    public static ClassPathElement fromDependency(PathTree contentTree, ResolvedDependency dep) {
        return new PathTreeClassPathElement(contentTree, dep.isRuntimeCp(), dep);
    }

    default public List<ClassPathResource> getResources(String name) {
        ClassPathResource resource = this.getResource(name);
        return resource == null ? List.of() : List.of(resource);
    }
}

