/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.CommandLineParser;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;

public abstract class AbstractBuildOption<T, V extends CommandLineOptionConfiguration>
implements BuildOption<T> {
    protected final String gradleProperty;
    protected final List<V> commandLineOptionConfigurations;

    public AbstractBuildOption(String gradleProperty) {
        this(gradleProperty, null);
    }

    public AbstractBuildOption(String gradleProperty, V ... commandLineOptionConfiguration) {
        this.gradleProperty = gradleProperty;
        this.commandLineOptionConfigurations = commandLineOptionConfiguration != null ? Arrays.asList(commandLineOptionConfiguration) : Collections.emptyList();
    }

    @Override
    public String getGradleProperty() {
        return this.gradleProperty;
    }

    protected boolean isTrue(String value) {
        return value != null && value.trim().equalsIgnoreCase("true");
    }

    protected CommandLineOption configureCommandLineOption(CommandLineParser parser, String[] options, String description, boolean deprecated, boolean incubating) {
        CommandLineOption option = parser.option(options).hasDescription(description);
        if (deprecated) {
            option.deprecated();
        }
        if (incubating) {
            option.incubating();
        }
        return option;
    }
}

