/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.gradle.internal.impldep.javax.annotation.Nonnull;
import org.gradle.internal.impldep.org.objectweb.asm.Type;

public class AsmClassGeneratorUtils {
    public static String signature(Constructor<?> constructor, boolean addNameParameter) {
        StringBuilder builder = new StringBuilder();
        AsmClassGeneratorUtils.visitFormalTypeParameters(constructor.getTypeParameters(), builder);
        AsmClassGeneratorUtils.visitConstructorParameters(constructor.getGenericParameterTypes(), addNameParameter, builder);
        builder.append('V');
        AsmClassGeneratorUtils.visitExceptions(constructor.getGenericExceptionTypes(), builder);
        return builder.toString();
    }

    private static void visitConstructorParameters(java.lang.reflect.Type[] parameterTypes, boolean addNameParameter, StringBuilder builder) {
        builder.append('(');
        if (addNameParameter) {
            AsmClassGeneratorUtils.visitClass(String.class, builder);
        }
        AsmClassGeneratorUtils.visitTypes(parameterTypes, builder);
        builder.append(')');
    }

    public static String getterSignature(java.lang.reflect.Type returnType) {
        StringBuilder builder = new StringBuilder();
        builder.append("()");
        AsmClassGeneratorUtils.visitType(returnType, builder);
        return builder.toString();
    }

    public static String signature(Method method) {
        StringBuilder builder = new StringBuilder();
        AsmClassGeneratorUtils.visitFormalTypeParameters(method.getTypeParameters(), builder);
        AsmClassGeneratorUtils.visitParameters(method.getGenericParameterTypes(), builder);
        AsmClassGeneratorUtils.visitType(method.getGenericReturnType(), builder);
        AsmClassGeneratorUtils.visitExceptions(method.getGenericExceptionTypes(), builder);
        return builder.toString();
    }

    private static void visitExceptions(java.lang.reflect.Type[] exceptionTypes, StringBuilder builder) {
        for (java.lang.reflect.Type exceptionType : exceptionTypes) {
            builder.append('^');
            AsmClassGeneratorUtils.visitType(exceptionType, builder);
        }
    }

    private static void visitParameters(java.lang.reflect.Type[] parameterTypes, StringBuilder builder) {
        builder.append('(');
        AsmClassGeneratorUtils.visitTypes(parameterTypes, builder);
        builder.append(')');
    }

    private static void visitTypes(java.lang.reflect.Type[] types, StringBuilder builder) {
        for (java.lang.reflect.Type type : types) {
            AsmClassGeneratorUtils.visitType(type, builder);
        }
    }

    private static void visitFormalTypeParameters(TypeVariable<?>[] typeParameters, StringBuilder builder) {
        if (typeParameters.length > 0) {
            builder.append('<');
            for (TypeVariable<?> typeVariable : typeParameters) {
                builder.append(typeVariable.getName());
                for (java.lang.reflect.Type bound : typeVariable.getBounds()) {
                    builder.append(':');
                    AsmClassGeneratorUtils.visitType(bound, builder);
                }
            }
            builder.append('>');
        }
    }

    private static void visitType(java.lang.reflect.Type type, StringBuilder builder) {
        if (type instanceof Class) {
            AsmClassGeneratorUtils.visitClass((Class)type, builder);
        } else if (type instanceof ParameterizedType) {
            AsmClassGeneratorUtils.visitParameterizedType((ParameterizedType)type, builder);
        } else if (type instanceof WildcardType) {
            AsmClassGeneratorUtils.visitWildcardType((WildcardType)type, builder);
        } else if (type instanceof TypeVariable) {
            AsmClassGeneratorUtils.visitTypeVariable((TypeVariable)type, builder);
        } else if (type instanceof GenericArrayType) {
            AsmClassGeneratorUtils.visitGenericArrayType((GenericArrayType)type, builder);
        } else {
            throw new IllegalArgumentException(String.format("Cannot generate signature for %s.", type));
        }
    }

    private static void visitGenericArrayType(GenericArrayType type, StringBuilder builder) {
        builder.append('[');
        AsmClassGeneratorUtils.visitType(type.getGenericComponentType(), builder);
    }

    private static void visitTypeVariable(TypeVariable<?> type, StringBuilder builder) {
        builder.append('T');
        builder.append(type.getName());
        builder.append(';');
    }

    private static void visitParameterizedType(ParameterizedType type, StringBuilder builder) {
        AsmClassGeneratorUtils.visitRawType(type.getRawType(), builder);
        builder.append('<');
        AsmClassGeneratorUtils.visitTypes(type.getActualTypeArguments(), builder);
        builder.append(">;");
    }

    private static void visitRawType(java.lang.reflect.Type type, StringBuilder builder) {
        if (type instanceof Class) {
            Class cl = (Class)type;
            if (cl.isPrimitive()) {
                builder.append(AsmClassGeneratorUtils.descriptorOf(cl));
            } else {
                builder.append('L');
                builder.append(cl.getName().replace('.', '/'));
            }
        } else {
            AsmClassGeneratorUtils.visitType(type, builder);
        }
    }

    private static void visitWildcardType(WildcardType type, StringBuilder builder) {
        java.lang.reflect.Type[] upperBounds = type.getUpperBounds();
        if (upperBounds.length == 1 && upperBounds[0].equals(Object.class)) {
            if (type.getLowerBounds().length == 0) {
                builder.append('*');
                return;
            }
        } else {
            AsmClassGeneratorUtils.visitTypesWithPrefix('+', upperBounds, builder);
        }
        AsmClassGeneratorUtils.visitTypesWithPrefix('-', type.getLowerBounds(), builder);
    }

    private static void visitTypesWithPrefix(char prefix, java.lang.reflect.Type[] types, StringBuilder builder) {
        for (java.lang.reflect.Type upperType : types) {
            builder.append(prefix);
            AsmClassGeneratorUtils.visitType(upperType, builder);
        }
    }

    private static void visitClass(Class<?> type, StringBuilder builder) {
        if (type.isPrimitive()) {
            builder.append(AsmClassGeneratorUtils.descriptorOf(type));
        } else {
            String binaryName = type.getName().replace('.', '/');
            if (type.isArray()) {
                builder.append(binaryName);
            } else {
                builder.append('L');
                builder.append(binaryName);
                builder.append(';');
            }
        }
    }

    @Nonnull
    private static String descriptorOf(Class<?> cl) {
        return Type.getType(cl).getDescriptor();
    }

    public static Class<?> getWrapperTypeForPrimitiveType(Class<?> type) {
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException(String.format("Don't know the wrapper type for primitive type %s.", type));
    }
}

