/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.BootstrapArtifactVersion;
import io.quarkus.bootstrap.resolver.maven.BootstrapArtifactVersionConstraint;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BuildDependencyGraphVisitor;
import io.quarkus.bootstrap.resolver.maven.DeploymentDependencySelector;
import io.quarkus.bootstrap.resolver.maven.DeploymentInjectionException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.SimpleDependencyGraphTransformationContext;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathTree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.transformer.ConflictIdSorter;
import org.eclipse.aether.util.graph.transformer.ConflictMarker;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.jboss.logging.Logger;

public class ApplicationDependencyTreeResolver {
    private static final Logger log = Logger.getLogger(ApplicationDependencyTreeResolver.class);
    private static final String QUARKUS_RUNTIME_ARTIFACT = "quarkus.runtime";
    private static final String QUARKUS_EXTENSION_DEPENDENCY = "quarkus.ext";
    private static final byte COLLECT_TOP_EXTENSION_RUNTIME_NODES = 1;
    private static final byte COLLECT_DIRECT_DEPS = 2;
    private static final byte COLLECT_RELOADABLE_MODULES = 4;
    private static final boolean CONVERGED_TREE_ONLY = PropertyUtils.getBoolean((String)"quarkus.bootstrap.converged-tree-only", (boolean)false);
    private static final Artifact[] NO_ARTIFACTS = new Artifact[0];
    private byte walkingFlags = (byte)3;
    private final List<ExtensionDependency> topExtensionDeps = new ArrayList<ExtensionDependency>();
    private ExtensionDependency lastVisitedRuntimeExtNode;
    private final Map<ArtifactKey, ExtensionInfo> allExtensions = new HashMap<ArtifactKey, ExtensionInfo>();
    private List<ConditionalDependency> conditionalDepsToProcess = new ArrayList<ConditionalDependency>();
    private final Deque<Collection<Exclusion>> exclusionStack = new ArrayDeque<Collection<Exclusion>>();
    private final Map<ArtifactCoords, Set<ArtifactKey>> artifactDeps = new HashMap<ArtifactCoords, Set<ArtifactKey>>();
    private MavenArtifactResolver resolver;
    private List<Dependency> managedDeps;
    private ApplicationModelBuilder appBuilder;
    private boolean collectReloadableModules;
    private Consumer<String> buildTreeConsumer;
    private List<Dependency> collectCompileOnly;

    public static ApplicationDependencyTreeResolver newInstance() {
        return new ApplicationDependencyTreeResolver();
    }

    public static Artifact getRuntimeArtifact(DependencyNode dep) {
        return (Artifact)dep.getData().get(QUARKUS_RUNTIME_ARTIFACT);
    }

    public ApplicationDependencyTreeResolver setArtifactResolver(MavenArtifactResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public ApplicationDependencyTreeResolver setApplicationModelBuilder(ApplicationModelBuilder appBuilder) {
        this.appBuilder = appBuilder;
        return this;
    }

    public ApplicationDependencyTreeResolver setCollectReloadableModules(boolean collectReloadableModules) {
        this.collectReloadableModules = collectReloadableModules;
        return this;
    }

    public ApplicationDependencyTreeResolver setBuildTreeConsumer(Consumer<String> buildTreeConsumer) {
        this.buildTreeConsumer = buildTreeConsumer;
        return this;
    }

    public ApplicationDependencyTreeResolver setCollectCompileOnly(List<Dependency> collectCompileOnly) {
        this.collectCompileOnly = collectCompileOnly;
        return this;
    }

    public void resolve(CollectRequest collectRtDepsRequest) throws AppModelResolverException {
        this.managedDeps = collectRtDepsRequest.getManagedDependencies();
        DependencyNode root = this.resolveRuntimeDeps(collectRtDepsRequest);
        if (this.collectReloadableModules) {
            this.setWalkingFlag((byte)4);
        }
        MavenArtifactResolver originalResolver = this.resolver;
        RepositorySystemSession originalSession = this.resolver.getSession();
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(originalSession);
        session.setDependencySelector(DeploymentDependencySelector.ensureDeploymentDependencySelector(session.getDependencySelector()));
        try {
            this.resolver = new MavenArtifactResolver(new BootstrapMavenContext((BootstrapMavenContextConfig<?>)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)BootstrapMavenContext.config().setRepositorySystem(this.resolver.getSystem())).setRepositorySystemSession((RepositorySystemSession)session)).setRemoteRepositories(this.resolver.getRepositories())).setRemoteRepositoryManager(this.resolver.getRemoteRepositoryManager())).setCurrentProject(this.resolver.getMavenContext().getCurrentProject())).setWorkspaceDiscovery(false)));
        }
        catch (BootstrapMavenException e) {
            throw new BootstrapDependencyProcessingException("Failed to initialize deployment dependencies resolver", (Throwable)((Object)e));
        }
        this.managedDeps = this.managedDeps.isEmpty() ? new ArrayList() : this.managedDeps;
        this.visitRuntimeDependencies(root.getChildren());
        List<ConditionalDependency> activatedConditionalDeps = List.of();
        if (!this.conditionalDepsToProcess.isEmpty()) {
            activatedConditionalDeps = new ArrayList();
            List<ConditionalDependency> unsatisfiedConditionalDeps = new ArrayList<ConditionalDependency>();
            while (!this.conditionalDepsToProcess.isEmpty()) {
                ArrayList<ConditionalDependency> tmp = unsatisfiedConditionalDeps;
                unsatisfiedConditionalDeps = this.conditionalDepsToProcess;
                this.conditionalDepsToProcess = tmp;
                int totalConditionsToProcess = unsatisfiedConditionalDeps.size();
                Iterator<ConditionalDependency> i = unsatisfiedConditionalDeps.iterator();
                while (i.hasNext()) {
                    ConditionalDependency cd = i.next();
                    boolean satisfied = cd.isSatisfied();
                    if (!satisfied) continue;
                    i.remove();
                    cd.activate();
                    activatedConditionalDeps.add(cd);
                }
                if (totalConditionsToProcess == unsatisfiedConditionalDeps.size()) break;
                this.conditionalDepsToProcess.addAll(unsatisfiedConditionalDeps);
                unsatisfiedConditionalDeps.clear();
            }
        }
        for (ExtensionDependency extDep : this.topExtensionDeps) {
            this.injectDeploymentDependencies(extDep);
        }
        if (!activatedConditionalDeps.isEmpty()) {
            for (ConditionalDependency cd : activatedConditionalDeps) {
                this.injectDeploymentDependencies(cd.getExtensionDependency());
            }
        }
        root = this.normalize(originalSession, root);
        new BuildDependencyGraphVisitor(originalResolver, this.appBuilder, this.buildTreeConsumer).visit(root);
        if (!CONVERGED_TREE_ONLY && this.collectReloadableModules) {
            for (ResolvedDependencyBuilder db : this.appBuilder.getDependencies()) {
                if (db.isFlagSet(2112)) continue;
                this.clearReloadableFlag(db);
            }
        }
        for (ResolvedDependencyBuilder db : this.appBuilder.getDependencies()) {
            db.clearFlag(2048);
            this.appBuilder.addDependency(db);
        }
        this.collectPlatformProperties();
        this.collectCompileOnly(collectRtDepsRequest, root);
    }

    private void collectCompileOnly(CollectRequest collectRtDepsRequest, DependencyNode root) throws BootstrapMavenException {
        if (this.collectCompileOnly.isEmpty()) {
            return;
        }
        ArrayDeque<List> depStack = new ArrayDeque<List>();
        List children = root.getChildren();
        while (children != null) {
            for (DependencyNode node : children) {
                this.managedDeps.add(node.getDependency());
                if (node.getChildren().isEmpty()) continue;
                depStack.add(node.getChildren());
            }
            children = (List)depStack.poll();
        }
        CollectRequest request = new CollectRequest().setDependencies(this.collectCompileOnly).setManagedDependencies(this.managedDeps).setRepositories(collectRtDepsRequest.getRepositories());
        if (collectRtDepsRequest.getRoot() != null) {
            request.setRoot(collectRtDepsRequest.getRoot());
        } else {
            request.setRootArtifact(collectRtDepsRequest.getRootArtifact());
        }
        try {
            root = this.resolver.getSystem().collectDependencies(this.resolver.getSession(), request).getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new BootstrapDependencyProcessingException("Failed to collect compile-only dependencies of " + root.getArtifact(), e);
        }
        children = root.getChildren();
        int flags = 4098;
        while (children != null) {
            for (DependencyNode node : children) {
                ExtensionInfo extInfo = this.getExtensionInfoOrNull(node.getArtifact(), node.getRepositories());
                ResolvedDependencyBuilder dep = this.appBuilder.getDependency(DependencyUtils.getKey(node.getArtifact()));
                if (dep == null) {
                    dep = (ResolvedDependencyBuilder)DependencyUtils.newDependencyBuilder(node, this.resolver).setFlags(flags);
                    if (extInfo != null) {
                        dep.setFlags(16);
                        if (dep.isFlagSet(2)) {
                            dep.setFlags(128);
                        }
                    }
                    this.appBuilder.addDependency(dep);
                } else {
                    dep.setFlags(4096);
                }
                if (node.getChildren().isEmpty()) continue;
                depStack.add(node.getChildren());
            }
            flags = 4096;
            children = (List)depStack.poll();
        }
    }

    private void collectPlatformProperties() throws AppModelResolverException {
        PlatformImportsImpl platformReleases = new PlatformImportsImpl();
        for (Dependency d : this.managedDeps) {
            Artifact artifact = d.getArtifact();
            String extension = artifact.getExtension();
            String artifactId = artifact.getArtifactId();
            if ("json".equals(extension) && artifactId.endsWith("-quarkus-platform-descriptor")) {
                platformReleases.addPlatformDescriptor(artifact.getGroupId(), artifactId, artifact.getClassifier(), extension, artifact.getVersion());
                continue;
            }
            if (!"properties".equals(artifact.getExtension()) || !artifactId.endsWith("-quarkus-platform-properties")) continue;
            platformReleases.addPlatformProperties(artifact.getGroupId(), artifactId, artifact.getClassifier(), extension, artifact.getVersion(), this.resolver.resolve(artifact).getArtifact().getFile().toPath());
        }
        this.appBuilder.setPlatformImports((PlatformImports)platformReleases);
    }

    private void clearReloadableFlag(ResolvedDependencyBuilder db) {
        Set<ArtifactKey> deps = this.artifactDeps.get(db.getArtifactCoords());
        if (deps == null || deps.isEmpty()) {
            return;
        }
        for (ArtifactKey key : deps) {
            ResolvedDependencyBuilder dep = this.appBuilder.getDependency(key);
            if (dep == null || dep.isFlagSet(2048)) continue;
            dep.setFlags(2048);
            dep.clearFlag(64);
            this.clearReloadableFlag(dep);
        }
    }

    private DependencyNode normalize(RepositorySystemSession session, DependencyNode root) throws AppModelResolverException {
        SimpleDependencyGraphTransformationContext context = new SimpleDependencyGraphTransformationContext(session);
        try {
            root = new ConflictMarker().transformGraph(root, (DependencyGraphTransformationContext)context);
            root = new ConflictIdSorter().transformGraph(root, (DependencyGraphTransformationContext)context);
            root = session.getDependencyGraphTransformer().transformGraph(root, (DependencyGraphTransformationContext)context);
        }
        catch (RepositoryException e) {
            throw new AppModelResolverException("Failed to normalize the dependency graph", (Throwable)e);
        }
        return root;
    }

    private DependencyNode resolveRuntimeDeps(CollectRequest request) throws AppModelResolverException {
        RepositorySystemSession session = this.resolver.getSession();
        if (!CONVERGED_TREE_ONLY && this.collectReloadableModules) {
            DefaultRepositorySystemSession mutableSession = new DefaultRepositorySystemSession(this.resolver.getSession());
            mutableSession.setDependencyGraphTransformer(new DependencyGraphTransformer(){

                public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
                    IdentityHashMap<DependencyNode, DependencyNode> visited = new IdentityHashMap<DependencyNode, DependencyNode>();
                    for (DependencyNode c : node.getChildren()) {
                        this.walk(c, visited);
                    }
                    return ApplicationDependencyTreeResolver.this.resolver.getSession().getDependencyGraphTransformer().transformGraph(node, context);
                }

                private void walk(DependencyNode node, Map<DependencyNode, DependencyNode> visited) {
                    if (visited.put(node, node) != null || node.getChildren().isEmpty()) {
                        return;
                    }
                    Set deps = ApplicationDependencyTreeResolver.this.artifactDeps.computeIfAbsent(DependencyUtils.getCoords(node.getArtifact()), k -> new HashSet(node.getChildren().size()));
                    for (DependencyNode c : node.getChildren()) {
                        deps.add(DependencyUtils.getKey(c.getArtifact()));
                        this.walk(c, visited);
                    }
                }
            });
            session = mutableSession;
        }
        try {
            return this.resolver.getSystem().resolveDependencies(session, new DependencyRequest().setCollectRequest(request)).getRoot();
        }
        catch (DependencyResolutionException e) {
            Artifact a = request.getRoot() == null ? request.getRootArtifact() : request.getRoot().getArtifact();
            throw new BootstrapMavenException("Failed to resolve dependencies for " + a, e);
        }
    }

    private boolean isRuntimeArtifact(ArtifactKey key) {
        ResolvedDependencyBuilder dep = this.appBuilder.getDependency(key);
        return dep != null && dep.isFlagSet(4);
    }

    private void visitRuntimeDependencies(List<DependencyNode> list) {
        for (DependencyNode n : list) {
            this.visitRuntimeDependency(n);
        }
    }

    private void visitRuntimeDependency(DependencyNode node) {
        Artifact artifact;
        ArtifactKey key;
        ResolvedDependencyBuilder dep;
        boolean popExclusions;
        byte prevWalkingFlags = this.walkingFlags;
        ExtensionDependency prevLastVisitedRtExtNode = this.lastVisitedRuntimeExtNode;
        boolean bl = popExclusions = !node.getDependency().getExclusions().isEmpty();
        if (popExclusions) {
            this.exclusionStack.addLast(node.getDependency().getExclusions());
        }
        if ((dep = this.appBuilder.getDependency(key = DependencyUtils.getKey(artifact = node.getArtifact()))) == null) {
            artifact = this.resolve(artifact, node.getRepositories());
        }
        try {
            ExtensionDependency extDep = this.getExtensionDependencyOrNull(node, artifact);
            if (dep == null) {
                if (!node.getRelocations().isEmpty()) {
                    ((DefaultDependencyNode)node).setRelocations(List.of());
                }
                WorkspaceModule module = null;
                if (this.resolver.getProjectModuleResolver() != null) {
                    module = this.resolver.getProjectModuleResolver().getProjectModule(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                }
                if ("provided".equals((dep = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)DependencyUtils.toAppArtifact(artifact, module).setOptional(node.getDependency().isOptional())).setScope(node.getDependency().getScope())).setDirect(this.isWalkingFlagOn((byte)2))).setRuntimeCp()).setDeploymentCp()).getScope())) {
                    dep.setFlags(4096);
                }
                if (extDep != null) {
                    dep.setRuntimeExtensionArtifact();
                    if (this.isWalkingFlagOn((byte)1)) {
                        dep.setFlags(128);
                    }
                }
                if (this.isWalkingFlagOn((byte)4)) {
                    if (module != null) {
                        dep.setReloadable();
                        this.appBuilder.addReloadableWorkspaceModule(key);
                    } else {
                        this.clearWalkingFlag((byte)4);
                    }
                }
                this.appBuilder.addDependency(dep);
            }
            this.clearWalkingFlag((byte)2);
            if (extDep != null) {
                extDep.info.ensureActivated();
                this.visitExtensionDependency(extDep);
            }
            this.visitRuntimeDependencies(node.getChildren());
        }
        catch (DeploymentInjectionException e) {
            throw e;
        }
        catch (Exception t) {
            throw new DeploymentInjectionException("Failed to inject extension deployment dependencies", t);
        }
        if (popExclusions) {
            this.exclusionStack.pollLast();
        }
        this.walkingFlags = prevWalkingFlags;
        this.lastVisitedRuntimeExtNode = prevLastVisitedRtExtNode;
    }

    private ExtensionDependency getExtensionDependencyOrNull(DependencyNode node, Artifact artifact) throws BootstrapDependencyProcessingException {
        ExtensionDependency extDep = ExtensionDependency.get(node);
        if (extDep != null) {
            return extDep;
        }
        ExtensionInfo extInfo = this.getExtensionInfoOrNull(artifact, node.getRepositories());
        if (extInfo != null) {
            Collection<Exclusion> exclusions;
            if (this.exclusionStack.isEmpty()) {
                exclusions = List.of();
            } else if (this.exclusionStack.size() == 1) {
                exclusions = this.exclusionStack.peekLast();
            } else {
                exclusions = new ArrayList<Exclusion>();
                for (Collection<Exclusion> set : this.exclusionStack) {
                    exclusions.addAll(set);
                }
            }
            return new ExtensionDependency(extInfo, node, exclusions);
        }
        return null;
    }

    private void visitExtensionDependency(ExtensionDependency extDep) throws BootstrapDependencyProcessingException {
        this.managedDeps.add(new Dependency(extDep.info.deploymentArtifact, "compile"));
        this.collectConditionalDependencies(extDep);
        if (this.isWalkingFlagOn((byte)1)) {
            this.clearWalkingFlag((byte)1);
            this.topExtensionDeps.add(extDep);
        }
        if (this.lastVisitedRuntimeExtNode != null) {
            this.lastVisitedRuntimeExtNode.addExtensionDependency(extDep);
        }
        this.lastVisitedRuntimeExtNode = extDep;
    }

    private void collectConditionalDependencies(ExtensionDependency dependent) throws BootstrapDependencyProcessingException {
        if (dependent.info.conditionalDeps.length == 0 || dependent.conditionalDepsQueued) {
            return;
        }
        dependent.conditionalDepsQueued = true;
        ExclusionDependencySelector selector = dependent.exclusions == null ? null : new ExclusionDependencySelector(dependent.exclusions);
        for (Artifact conditionalArtifact : dependent.info.conditionalDeps) {
            if (selector != null && !selector.selectDependency(new Dependency(conditionalArtifact, "runtime"))) continue;
            ExtensionInfo conditionalInfo = this.getExtensionInfoOrNull(conditionalArtifact, dependent.runtimeNode.getRepositories());
            if (conditionalInfo == null) {
                log.warn((Object)(dependent.info.runtimeArtifact + " declares a conditional dependency on " + conditionalArtifact + " that is not a Quarkus extension and will be ignored"));
                continue;
            }
            if (conditionalInfo.activated) continue;
            ConditionalDependency conditionalDep = new ConditionalDependency(conditionalInfo, dependent);
            this.conditionalDepsToProcess.add(conditionalDep);
            this.collectConditionalDependencies(conditionalDep.getExtensionDependency());
        }
    }

    private ExtensionInfo getExtensionInfoOrNull(Artifact artifact, List<RemoteRepository> repos) throws BootstrapDependencyProcessingException {
        if (!artifact.getExtension().equals("jar")) {
            return null;
        }
        ArtifactKey extKey = DependencyUtils.getKey(artifact);
        ExtensionInfo ext = this.allExtensions.get(extKey);
        if (ext != null) {
            return ext;
        }
        Path path = (artifact = this.resolve(artifact, repos)).getFile().toPath();
        Properties descriptor = (Properties)PathTree.ofDirectoryOrArchive((Path)path).apply("META-INF/quarkus-extension.properties", visit -> {
            if (visit == null) {
                return null;
            }
            try {
                return ApplicationDependencyTreeResolver.readDescriptor(visit.getPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        if (descriptor != null) {
            ext = new ExtensionInfo(artifact, descriptor);
            this.allExtensions.put(extKey, ext);
        }
        return ext;
    }

    private void injectDeploymentDependencies(ExtensionDependency extDep) throws BootstrapDependencyProcessingException {
        List deploymentDeps;
        log.debugf("Injecting deployment dependency %s", (Object)extDep.info.deploymentArtifact);
        DependencyNode deploymentNode = this.collectDependencies(extDep.info.deploymentArtifact, extDep.exclusions, extDep.runtimeNode.getRepositories());
        if (deploymentNode.getChildren().isEmpty()) {
            throw new BootstrapDependencyProcessingException("Failed to collect dependencies of " + deploymentNode.getArtifact() + ": either its POM could not be resolved from the available Maven repositories or the artifact does not have any dependencies while at least a dependency on the runtime artifact " + extDep.info.runtimeArtifact + " is expected");
        }
        if (this.resolver.getProjectModuleResolver() != null && this.collectReloadableModules) {
            this.clearReloadable(deploymentNode);
        }
        if (!this.replaceDirectDepBranch(extDep, deploymentDeps = deploymentNode.getChildren())) {
            throw new BootstrapDependencyProcessingException("Quarkus extension deployment artifact " + deploymentNode.getArtifact() + " does not appear to depend on the corresponding runtime artifact " + extDep.info.runtimeArtifact);
        }
        DependencyNode runtimeNode = extDep.runtimeNode;
        runtimeNode.setData((Object)QUARKUS_RUNTIME_ARTIFACT, (Object)runtimeNode.getArtifact());
        runtimeNode.setArtifact(deploymentNode.getArtifact());
        runtimeNode.getDependency().setArtifact(deploymentNode.getArtifact());
        runtimeNode.setChildren(deploymentDeps);
    }

    private void clearReloadable(DependencyNode node) {
        for (DependencyNode child : node.getChildren()) {
            this.clearReloadable(child);
        }
        ResolvedDependencyBuilder dep = this.appBuilder.getDependency(DependencyUtils.getKey(node.getArtifact()));
        if (dep != null) {
            dep.clearFlag(64);
        }
    }

    private boolean replaceDirectDepBranch(ExtensionDependency extDep, List<DependencyNode> deploymentDeps) throws BootstrapDependencyProcessingException {
        int i = 0;
        DefaultDependencyNode inserted = null;
        while (i < deploymentDeps.size()) {
            Artifact a = deploymentDeps.get(i).getArtifact();
            if (a == null) continue;
            if (ApplicationDependencyTreeResolver.isSameKey(extDep.info.runtimeArtifact, a)) {
                inserted = new DefaultDependencyNode(extDep.runtimeNode);
                inserted.setChildren(extDep.runtimeNode.getChildren());
                deploymentDeps.set(i, (DependencyNode)inserted);
                break;
            }
            ++i;
        }
        if (inserted == null) {
            return false;
        }
        if (extDep.runtimeExtensionDeps != null) {
            for (ExtensionDependency dep : extDep.runtimeExtensionDeps) {
                for (DependencyNode deploymentDep : deploymentDeps) {
                    if (deploymentDep != inserted && this.replaceRuntimeBranch(dep, deploymentDep.getChildren())) break;
                }
            }
        }
        return true;
    }

    private boolean replaceRuntimeBranch(ExtensionDependency extNode, List<DependencyNode> deploymentNodes) throws BootstrapDependencyProcessingException {
        if (this.replaceDirectDepBranch(extNode, deploymentNodes)) {
            return true;
        }
        for (DependencyNode deploymentNode : deploymentNodes) {
            if (!this.replaceRuntimeBranch(extNode, deploymentNode.getChildren())) continue;
            return true;
        }
        return false;
    }

    private DependencyNode collectDependencies(Artifact artifact, Collection<Exclusion> exclusions, List<RemoteRepository> repos) {
        CollectRequest request;
        if (this.managedDeps.isEmpty()) {
            request = new CollectRequest().setRoot(new Dependency(artifact, "compile", Boolean.valueOf(false), exclusions)).setRepositories(repos);
        } else {
            ArtifactDescriptorResult descr;
            try {
                descr = this.resolver.resolveDescriptor(artifact, repos);
            }
            catch (BootstrapMavenException e) {
                throw new DeploymentInjectionException("Failed to resolve descriptor for " + artifact, (Throwable)((Object)e));
            }
            ArrayList<Dependency> mergedManagedDeps = new ArrayList<Dependency>(this.managedDeps.size() + descr.getManagedDependencies().size());
            HashMap<ArtifactKey, String> managedVersions = new HashMap<ArtifactKey, String>(this.managedDeps.size());
            for (Dependency dep : this.managedDeps) {
                managedVersions.put(DependencyUtils.getKey(dep.getArtifact()), dep.getArtifact().getVersion());
                mergedManagedDeps.add(dep);
            }
            for (Dependency dep : descr.getManagedDependencies()) {
                ArtifactKey key = DependencyUtils.getKey(dep.getArtifact());
                if (managedVersions.containsKey(key)) continue;
                mergedManagedDeps.add(dep);
            }
            List<Dependency> directDeps = DependencyUtils.mergeDeps(List.of(), descr.getDependencies(), managedVersions, Set.of("provided", "test"));
            request = new CollectRequest().setDependencies(directDeps).setManagedDependencies(mergedManagedDeps).setRepositories(repos);
            if (exclusions.isEmpty()) {
                request.setRootArtifact(artifact);
            } else {
                request.setRoot(new Dependency(artifact, "compile", Boolean.valueOf(false), exclusions));
            }
        }
        try {
            return this.resolver.getSystem().collectDependencies(this.resolver.getSession(), request).getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new DeploymentInjectionException("Failed to collect dependencies for " + artifact, e);
        }
    }

    private Artifact resolve(Artifact artifact, List<RemoteRepository> repos) {
        if (artifact.getFile() != null) {
            return artifact;
        }
        try {
            return this.resolver.getSystem().resolveArtifact(this.resolver.getSession(), new ArtifactRequest().setArtifact(artifact).setRepositories(repos)).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new DeploymentInjectionException("Failed to resolve artifact " + artifact, e);
        }
    }

    private void setWalkingFlag(byte flag) {
        this.walkingFlags = (byte)(this.walkingFlags | flag);
    }

    private boolean isWalkingFlagOn(byte flag) {
        return (this.walkingFlags & flag) > 0;
    }

    private void clearWalkingFlag(byte flag) {
        if ((this.walkingFlags & flag) > 0) {
            this.walkingFlags = (byte)(this.walkingFlags ^ flag);
        }
    }

    private static Properties readDescriptor(Path path) throws IOException {
        Properties rtProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            rtProps.load(reader);
        }
        return rtProps;
    }

    private static boolean isSameKey(Artifact a1, Artifact a2) {
        return a2.getArtifactId().equals(a1.getArtifactId()) && a2.getGroupId().equals(a1.getGroupId()) && a2.getClassifier().equals(a1.getClassifier()) && a2.getExtension().equals(a1.getExtension());
    }

    private static String toCompactCoords(Artifact a) {
        StringBuilder b = new StringBuilder();
        b.append(a.getGroupId()).append(':').append(a.getArtifactId()).append(':');
        if (!a.getClassifier().isEmpty()) {
            b.append(a.getClassifier()).append(':');
        }
        if (!"jar".equals(a.getExtension())) {
            b.append(a.getExtension()).append(':');
        }
        b.append(a.getVersion());
        return b.toString();
    }

    private class ConditionalDependency {
        final ExtensionInfo info;
        final ExtensionDependency dependent;
        private ExtensionDependency dependency;
        private boolean activated;

        private ConditionalDependency(ExtensionInfo info, ExtensionDependency dependent) {
            this.info = Objects.requireNonNull(info, "Extension info is null");
            this.dependent = dependent;
        }

        ExtensionDependency getExtensionDependency() {
            if (this.dependency == null) {
                DefaultDependencyNode rtNode = new DefaultDependencyNode(new Dependency(this.info.runtimeArtifact, "runtime"));
                rtNode.setVersion((Version)new BootstrapArtifactVersion(this.info.runtimeArtifact.getVersion()));
                rtNode.setVersionConstraint((VersionConstraint)new BootstrapArtifactVersionConstraint(new BootstrapArtifactVersion(this.info.runtimeArtifact.getVersion())));
                rtNode.setRepositories(this.dependent.runtimeNode.getRepositories());
                this.dependency = new ExtensionDependency(this.info, (DependencyNode)rtNode, this.dependent.exclusions);
            }
            return this.dependency;
        }

        void activate() {
            if (this.activated) {
                return;
            }
            this.activated = true;
            ApplicationDependencyTreeResolver.this.clearWalkingFlag((byte)1);
            ExtensionDependency extDep = this.getExtensionDependency();
            DependencyNode originalNode = ApplicationDependencyTreeResolver.this.collectDependencies(this.info.runtimeArtifact, extDep.exclusions, extDep.runtimeNode.getRepositories());
            DefaultDependencyNode rtNode = (DefaultDependencyNode)extDep.runtimeNode;
            rtNode.setRepositories(originalNode.getRepositories());
            List currentChildren = rtNode.getChildren();
            if (currentChildren == null || currentChildren.isEmpty()) {
                rtNode.setChildren(originalNode.getChildren());
            } else {
                currentChildren.addAll(originalNode.getChildren());
            }
            ApplicationDependencyTreeResolver.this.visitRuntimeDependency((DependencyNode)rtNode);
            this.dependent.runtimeNode.getChildren().add(rtNode);
        }

        boolean isSatisfied() {
            if (this.info.dependencyCondition == null) {
                return true;
            }
            for (ArtifactKey key : this.info.dependencyCondition) {
                if (ApplicationDependencyTreeResolver.this.isRuntimeArtifact(key)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ExtensionDependency {
        final ExtensionInfo info;
        final DependencyNode runtimeNode;
        final Collection<Exclusion> exclusions;
        boolean conditionalDepsQueued;
        private List<ExtensionDependency> runtimeExtensionDeps;

        static ExtensionDependency get(DependencyNode node) {
            return (ExtensionDependency)node.getData().get(ApplicationDependencyTreeResolver.QUARKUS_EXTENSION_DEPENDENCY);
        }

        ExtensionDependency(ExtensionInfo info, DependencyNode node, Collection<Exclusion> exclusions) {
            this.runtimeNode = node;
            this.info = info;
            this.exclusions = exclusions;
            Map data = node.getData();
            if (data.isEmpty()) {
                node.setData((Object)ApplicationDependencyTreeResolver.QUARKUS_EXTENSION_DEPENDENCY, (Object)this);
            } else if (data.put(ApplicationDependencyTreeResolver.QUARKUS_EXTENSION_DEPENDENCY, this) != null) {
                throw new IllegalStateException("Dependency node " + node + " has already been associated with an extension dependency");
            }
        }

        void addExtensionDependency(ExtensionDependency dep) {
            if (this.runtimeExtensionDeps == null) {
                this.runtimeExtensionDeps = new ArrayList<ExtensionDependency>();
            }
            this.runtimeExtensionDeps.add(dep);
        }
    }

    private class ExtensionInfo {
        final Artifact runtimeArtifact;
        final Properties props;
        final Artifact deploymentArtifact;
        final Artifact[] conditionalDeps;
        final ArtifactKey[] dependencyCondition;
        boolean activated;

        ExtensionInfo(Artifact runtimeArtifact, Properties props) throws BootstrapDependencyProcessingException {
            this.runtimeArtifact = runtimeArtifact;
            this.props = props;
            String value = props.getProperty("deployment-artifact");
            if (value == null) {
                throw new BootstrapDependencyProcessingException("Extension descriptor from " + runtimeArtifact + " does not include deployment-artifact");
            }
            Artifact deploymentArtifact = DependencyUtils.toArtifact(value);
            if (deploymentArtifact.getVersion() == null || deploymentArtifact.getVersion().isEmpty()) {
                deploymentArtifact = deploymentArtifact.setVersion(runtimeArtifact.getVersion());
            }
            this.deploymentArtifact = deploymentArtifact;
            value = props.getProperty("conditional-dependencies");
            if (value != null) {
                String[] deps = BootstrapUtils.splitByWhitespace((String)value);
                this.conditionalDeps = new Artifact[deps.length];
                for (int i = 0; i < deps.length; ++i) {
                    try {
                        this.conditionalDeps[i] = DependencyUtils.toArtifact(deps[i]);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BootstrapDependencyProcessingException("Failed to parse conditional dependencies configuration of " + runtimeArtifact, e);
                    }
                }
            } else {
                this.conditionalDeps = NO_ARTIFACTS;
            }
            this.dependencyCondition = BootstrapUtils.parseDependencyCondition((String)props.getProperty("dependency-condition"));
        }

        void ensureActivated() {
            if (this.activated) {
                return;
            }
            this.activated = true;
            ApplicationDependencyTreeResolver.this.appBuilder.handleExtensionProperties(this.props, this.runtimeArtifact.toString());
            String providesCapabilities = this.props.getProperty("provides-capabilities");
            String requiresCapabilities = this.props.getProperty("requires-capabilities");
            if (providesCapabilities != null || requiresCapabilities != null) {
                ApplicationDependencyTreeResolver.this.appBuilder.addExtensionCapabilities((ExtensionCapabilities)CapabilityContract.of((String)ApplicationDependencyTreeResolver.toCompactCoords(this.runtimeArtifact), (String)providesCapabilities, (String)requiresCapabilities));
            }
        }
    }
}

