/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.ModelResolutionTask;
import io.quarkus.bootstrap.resolver.maven.ModelResolutionTaskRunner;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Phaser;
import org.jboss.logging.Logger;

class NonBlockingModelResolutionTaskRunner
implements ModelResolutionTaskRunner {
    private static final Logger log = Logger.getLogger(NonBlockingModelResolutionTaskRunner.class);
    private final Phaser phaser = new Phaser(1);
    private final Collection<Exception> errors = new ConcurrentLinkedDeque<Exception>();

    NonBlockingModelResolutionTaskRunner() {
    }

    @Override
    public void run(ModelResolutionTask task) {
        this.phaser.register();
        CompletableFuture.runAsync(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                this.errors.add(e);
            }
            finally {
                this.phaser.arriveAndDeregister();
            }
        });
    }

    @Override
    public void waitForCompletion() {
        this.phaser.arriveAndAwaitAdvance();
        this.assertNoErrors();
    }

    private void assertNoErrors() {
        if (!this.errors.isEmpty()) {
            StringBuilder sb = new StringBuilder("The following errors were encountered while processing Quarkus application dependencies:");
            log.error((Object)sb);
            int i = 1;
            block0: for (Exception error : this.errors) {
                String prefix = i++ + ")";
                log.error((Object)prefix, (Throwable)error);
                sb.append(System.lineSeparator()).append(prefix).append(" ").append(error.getLocalizedMessage());
                for (StackTraceElement e : error.getStackTrace()) {
                    int j;
                    sb.append(System.lineSeparator());
                    for (j = 0; j < prefix.length(); ++j) {
                        sb.append(" ");
                    }
                    sb.append("at ").append(e);
                    if (!e.getClassName().contains("io.quarkus")) continue;
                    sb.append(System.lineSeparator());
                    for (j = 0; j < prefix.length(); ++j) {
                        sb.append(" ");
                    }
                    sb.append("...");
                    continue block0;
                }
            }
            throw new RuntimeException(sb.toString());
        }
    }
}

