/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelBuilderFactory;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.resolution.WorkspaceModelResolver;

public class MavenModelBuilder
implements ModelBuilder {
    private final ModelBuilder builder = BootstrapModelBuilderFactory.getDefaultModelBuilder();
    private final BootstrapMavenContext ctx;
    private final Map<File, LocalProject> poms;

    public MavenModelBuilder(BootstrapMavenContext ctx) {
        this.ctx = ctx;
        if (ctx != null && ctx.getWorkspace() != null) {
            Collection<LocalProject> projects = ctx.getWorkspace().getProjects().values();
            HashMap<File, LocalProject> tmp = new HashMap<File, LocalProject>(projects.size());
            for (LocalProject p : projects) {
                tmp.put(p.getRawModel().getPomFile(), p);
            }
            this.poms = tmp;
        } else {
            this.poms = Map.of();
        }
    }

    public ModelBuildingResult build(ModelBuildingRequest request) throws ModelBuildingException {
        LocalProject lp = this.getLocalProjectOrNull(request);
        if (lp != null) {
            if (lp.getModelBuildingResult() != null) {
                return lp.getModelBuildingResult();
            }
            if (request.getRawModel() == null) {
                request.setRawModel(lp.getRawModel());
            }
            this.completeWorkspaceProjectBuildRequest(request);
            LocalWorkspace workspace = lp.getWorkspace();
            if (workspace != null) {
                request.setWorkspaceModelResolver((WorkspaceModelResolver)workspace);
            }
        }
        return this.builder.build(request);
    }

    private LocalProject getLocalProjectOrNull(ModelBuildingRequest request) {
        LocalProject lp;
        if (request.getPomFile() != null && (lp = this.poms.get(request.getPomFile())) != null) {
            return lp;
        }
        Model requestModel = request.getRawModel();
        if (requestModel == null && request.getModelSource() != null) {
            try {
                requestModel = ModelUtils.readModel(request.getModelSource().getInputStream());
                request.setRawModel(requestModel);
                if (request.getPomFile() != null) {
                    requestModel.setPomFile(request.getPomFile());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (requestModel != null && this.ctx.getWorkspace() != null) {
            return this.ctx.getWorkspace().getLocalProjectOrNull(ModelUtils.getGroupId(requestModel), requestModel.getArtifactId(), ModelUtils.getRawVersion(requestModel));
        }
        return null;
    }

    private void completeWorkspaceProjectBuildRequest(ModelBuildingRequest request) {
        List<Profile> activeSettingsProfiles;
        Set<String> addedProfiles;
        List profiles = request.getProfiles();
        if (profiles.isEmpty()) {
            addedProfiles = Set.of();
        } else {
            addedProfiles = new HashSet(profiles.size());
            for (Profile p : profiles) {
                addedProfiles.add(p.getId());
            }
        }
        try {
            activeSettingsProfiles = this.ctx.getActiveSettingsProfiles();
        }
        catch (BootstrapMavenException e) {
            Model requestModel = request.getRawModel();
            throw new RuntimeException("Failed to build model for " + ModelUtils.getGroupId(requestModel) + ":" + requestModel.getArtifactId() + ":" + ModelUtils.getVersion(requestModel), (Throwable)((Object)e));
        }
        for (Profile p : activeSettingsProfiles) {
            if (addedProfiles.contains(p.getId())) continue;
            profiles.add(p);
            request.getActiveProfileIds().add(p.getId());
        }
        BootstrapMavenOptions cliOptions = this.ctx.getCliOptions();
        request.getActiveProfileIds().addAll(cliOptions.getActiveProfileIds());
        request.getInactiveProfileIds().addAll(cliOptions.getInactiveProfileIds());
        request.setUserProperties(System.getProperties());
    }

    public ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result) throws ModelBuildingException {
        return this.builder.build(request, result);
    }

    public Result<? extends Model> buildRawModel(File pomFile, int validationLevel, boolean locationTracking) {
        return this.builder.buildRawModel(pomFile, validationLevel, locationTracking);
    }
}

