/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenLocalRepositoryManager;
import io.quarkus.bootstrap.resolver.maven.workspace.ProjectModuleResolver;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

public class MavenArtifactResolver {
    private static final String SECONDARY_LOCAL_REPO_PROP = "io.quarkus.maven.secondary-local-repo";
    protected final BootstrapMavenContext context;
    protected final RepositorySystem repoSystem;
    protected final RepositorySystemSession repoSession;
    protected final List<RemoteRepository> remoteRepos;
    protected final MavenLocalRepositoryManager localRepoManager;
    protected final RemoteRepositoryManager remoteRepoManager;

    public static Builder builder() {
        return new Builder();
    }

    private MavenArtifactResolver(Builder builder) throws BootstrapMavenException {
        this.context = new BootstrapMavenContext(builder);
        this.repoSystem = this.context.getRepositorySystem();
        RepositorySystemSession session = this.context.getRepositorySystemSession();
        String secondaryRepo = PropertyUtils.getProperty((String)SECONDARY_LOCAL_REPO_PROP);
        if (secondaryRepo != null) {
            builder.secondaryLocalRepo = Paths.get(secondaryRepo, new String[0]);
        }
        if (builder.secondaryLocalRepo != null) {
            this.localRepoManager = new MavenLocalRepositoryManager(session.getLocalRepositoryManager(), builder.secondaryLocalRepo);
            this.repoSession = new DefaultRepositorySystemSession(session).setLocalRepositoryManager((LocalRepositoryManager)this.localRepoManager);
        } else {
            this.repoSession = session;
            this.localRepoManager = null;
        }
        this.remoteRepos = this.context.getRemoteRepositories();
        this.remoteRepoManager = this.context.getRemoteRepositoryManager();
    }

    public MavenArtifactResolver(BootstrapMavenContext mvnSettings) throws BootstrapMavenException {
        this.context = mvnSettings;
        this.repoSystem = mvnSettings.getRepositorySystem();
        this.repoSession = mvnSettings.getRepositorySystemSession();
        this.localRepoManager = null;
        this.remoteRepos = mvnSettings.getRemoteRepositories();
        this.remoteRepoManager = mvnSettings.getRemoteRepositoryManager();
    }

    public ProjectModuleResolver getProjectModuleResolver() {
        return this.context.getWorkspace() == null ? null : this.context.getWorkspace();
    }

    public BootstrapMavenContext getMavenContext() {
        return this.context;
    }

    public RemoteRepositoryManager getRemoteRepositoryManager() {
        return this.remoteRepoManager;
    }

    public MavenLocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepoManager;
    }

    public RepositorySystem getSystem() {
        return this.repoSystem;
    }

    public RepositorySystemSession getSession() {
        return this.repoSession;
    }

    public List<RemoteRepository> getRepositories() {
        return this.remoteRepos;
    }

    public void addRemoteRepositories(List<RemoteRepository> repos) {
        this.remoteRepos.addAll(repos);
    }

    public ArtifactResult resolve(Artifact artifact) throws BootstrapMavenException {
        return this.resolveInternal(artifact, this.remoteRepos);
    }

    public ArtifactResult resolve(Artifact artifact, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        return this.resolveInternal(artifact, this.aggregateRepositories(mainRepos, this.remoteRepos));
    }

    private ArtifactResult resolveInternal(Artifact artifact, List<RemoteRepository> aggregatedRepos) throws BootstrapMavenException {
        try {
            return this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setArtifact(artifact).setRepositories(aggregatedRepos));
        }
        catch (ArtifactResolutionException e) {
            throw new BootstrapMavenException("Failed to resolve artifact " + artifact, e);
        }
    }

    public List<ArtifactResult> resolve(List<ArtifactRequest> artifacts) throws BootstrapMavenException {
        try {
            return this.repoSystem.resolveArtifacts(this.repoSession, artifacts);
        }
        catch (ArtifactResolutionException e) {
            throw new BootstrapMavenException("Failed to resolve artifacts", e);
        }
    }

    public ArtifactDescriptorResult resolveDescriptor(Artifact artifact) throws BootstrapMavenException {
        return this.resolveDescriptorInternal(artifact, this.remoteRepos);
    }

    public ArtifactDescriptorResult resolveDescriptor(Artifact artifact, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        return this.resolveDescriptorInternal(artifact, this.aggregateRepositories(mainRepos, this.remoteRepos));
    }

    private ArtifactDescriptorResult resolveDescriptorInternal(Artifact artifact, List<RemoteRepository> aggregatedRepos) throws BootstrapMavenException {
        try {
            return this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setArtifact(artifact).setRepositories(aggregatedRepos));
        }
        catch (ArtifactDescriptorException e) {
            throw new BootstrapMavenException("Failed to read descriptor of " + artifact, e);
        }
    }

    public VersionRangeResult resolveVersionRange(Artifact artifact) throws BootstrapMavenException {
        try {
            return this.repoSystem.resolveVersionRange(this.repoSession, new VersionRangeRequest().setArtifact(artifact).setRepositories(this.remoteRepos));
        }
        catch (VersionRangeResolutionException ex) {
            throw new BootstrapMavenException("Failed to resolve version range for " + artifact, ex);
        }
    }

    public String getLatestVersionFromRange(Artifact artifact, String range) throws BootstrapMavenException {
        return this.getLatest(this.resolveVersionRange((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), range)));
    }

    private String getLatest(VersionRangeResult rangeResult) {
        List versions = rangeResult.getVersions();
        if (versions.isEmpty()) {
            return null;
        }
        Version next = (Version)versions.get(0);
        for (int i = 1; i < versions.size(); ++i) {
            Version candidate = (Version)versions.get(i);
            if (candidate.compareTo((Object)next) <= 0) continue;
            next = candidate;
        }
        return next.toString();
    }

    public CollectResult collectDependencies(Artifact artifact, List<Dependency> deps) throws BootstrapMavenException {
        return this.collectDependencies(artifact, deps, List.of());
    }

    public CollectResult collectDependencies(Artifact artifact, List<Dependency> deps, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        return this.collectDependencies(artifact, deps, mainRepos, List.of());
    }

    public CollectResult collectDependencies(Artifact artifact, List<Dependency> deps, List<RemoteRepository> mainRepos, Collection<Exclusion> exclusions) throws BootstrapMavenException {
        try {
            return this.repoSystem.collectDependencies(this.repoSession, this.newCollectRequest(artifact, mainRepos, exclusions).setDependencies(deps));
        }
        catch (DependencyCollectionException e) {
            throw new BootstrapMavenException("Failed to collect dependencies for " + artifact, e);
        }
    }

    public DependencyResult resolveDependencies(Artifact artifact, List<Dependency> deps) throws BootstrapMavenException {
        return this.resolveDependencies(artifact, deps, List.of());
    }

    public DependencyResult resolveDependencies(Artifact artifact, List<Dependency> deps, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        CollectRequest request = this.newCollectRequest(artifact, mainRepos);
        request.setDependencies(deps);
        try {
            return this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(request));
        }
        catch (DependencyResolutionException e) {
            throw new BootstrapMavenException("Failed to resolve dependencies for " + artifact, e);
        }
    }

    public DependencyResult resolvePluginDependencies(Artifact pluginArtifact) throws BootstrapMavenException {
        try {
            return this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(new CollectRequest().setRoot(new Dependency(pluginArtifact, null)).setRepositories(this.context.getRemotePluginRepositories())));
        }
        catch (DependencyResolutionException e) {
            throw new BootstrapMavenException("Failed to resolve dependencies for Maven plugin " + pluginArtifact, e);
        }
    }

    public DependencyResult toDependencyTree(List<Dependency> deps, List<RemoteRepository> mainRepos) throws BootstrapMavenException {
        DependencyResult result = new DependencyResult(new DependencyRequest().setCollectRequest(new CollectRequest(deps, List.of(), mainRepos)));
        DefaultDependencyNode root = new DefaultDependencyNode((Dependency)null);
        result.setRoot((DependencyNode)root);
        GenericVersionScheme vs = new GenericVersionScheme();
        for (Dependency i : deps) {
            DefaultDependencyNode node = new DefaultDependencyNode(i);
            try {
                node.setVersionConstraint((VersionConstraint)vs.parseVersionConstraint(i.getArtifact().getVersion()));
                node.setVersion((Version)vs.parseVersion(i.getArtifact().getVersion()));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new RuntimeException(e);
            }
            root.getChildren().add(node);
        }
        return result;
    }

    public CollectResult collectManagedDependencies(Artifact artifact, List<Dependency> directDeps, List<Dependency> managedDeps, List<RemoteRepository> mainRepos, Collection<Exclusion> exclusions, String ... excludedScopes) throws BootstrapMavenException {
        try {
            return this.repoSystem.collectDependencies(this.repoSession, this.newCollectManagedRequest(artifact, directDeps, managedDeps, mainRepos, exclusions, Set.of(excludedScopes)));
        }
        catch (DependencyCollectionException e) {
            throw new BootstrapMavenException("Failed to collect dependencies for " + artifact, e);
        }
    }

    public CollectRequest newCollectManagedRequest(Artifact artifact, List<Dependency> directDeps, List<Dependency> managedDeps, List<RemoteRepository> mainRepos, Collection<Exclusion> exclusions, Set<String> excludedScopes) throws BootstrapMavenException {
        ArrayList<Dependency> mergedManagedDeps;
        List<RemoteRepository> aggregatedRepos = this.aggregateRepositories(mainRepos, this.remoteRepos);
        ArtifactDescriptorResult descr = this.resolveDescriptorInternal(artifact, aggregatedRepos);
        Map<ArtifactKey, String> managedVersions = Map.of();
        if (!managedDeps.isEmpty()) {
            mergedManagedDeps = new ArrayList<Dependency>(managedDeps.size() + descr.getManagedDependencies().size());
            managedVersions = new HashMap<ArtifactKey, String>(managedDeps.size());
            for (Dependency dep : managedDeps) {
                managedVersions.put(MavenArtifactResolver.getKey(dep.getArtifact()), dep.getArtifact().getVersion());
                mergedManagedDeps.add(dep);
            }
            for (Dependency dep : descr.getManagedDependencies()) {
                ArtifactKey key = MavenArtifactResolver.getKey(dep.getArtifact());
                if (managedVersions.containsKey(key)) continue;
                mergedManagedDeps.add(dep);
            }
        } else {
            mergedManagedDeps = descr.getManagedDependencies();
        }
        directDeps = DependencyUtils.mergeDeps(directDeps, descr.getDependencies(), managedVersions, excludedScopes);
        aggregatedRepos = this.aggregateRepositories(aggregatedRepos, this.newResolutionRepositories(descr.getRepositories()));
        return MavenArtifactResolver.newCollectRequest(artifact, directDeps, mergedManagedDeps, exclusions, aggregatedRepos);
    }

    public static CollectRequest newCollectRequest(Artifact artifact, List<Dependency> directDeps, List<Dependency> managedDeps, Collection<Exclusion> exclusions, List<RemoteRepository> repos) {
        CollectRequest request = new CollectRequest().setDependencies(directDeps).setManagedDependencies(managedDeps).setRepositories(repos);
        if (exclusions.isEmpty()) {
            request.setRootArtifact(artifact);
        } else {
            request.setRoot(new Dependency(artifact, "compile", Boolean.valueOf(false), exclusions));
        }
        return request;
    }

    public List<RemoteRepository> newResolutionRepositories(List<RemoteRepository> repos) {
        return repos.isEmpty() ? List.of() : this.repoSystem.newResolutionRepositories(this.repoSession, repos);
    }

    public List<RemoteRepository> aggregateRepositories(List<RemoteRepository> dominant, List<RemoteRepository> recessive) {
        return dominant.isEmpty() ? recessive : this.remoteRepoManager.aggregateRepositories(this.repoSession, dominant, recessive, false);
    }

    public void install(Artifact artifact) throws BootstrapMavenException {
        try {
            this.repoSystem.install(this.repoSession, new InstallRequest().addArtifact(artifact));
        }
        catch (InstallationException ex) {
            throw new BootstrapMavenException("Failed to install " + artifact, ex);
        }
    }

    private CollectRequest newCollectRequest(Artifact artifact, List<RemoteRepository> mainRepos) {
        return this.newCollectRequest(artifact, mainRepos, List.of());
    }

    private CollectRequest newCollectRequest(Artifact artifact, List<RemoteRepository> mainRepos, Collection<Exclusion> exclusions) {
        return new CollectRequest().setRoot(new Dependency(artifact, "runtime", Boolean.valueOf(false), exclusions)).setRepositories(this.aggregateRepositories(mainRepos, this.remoteRepos));
    }

    private static ArtifactKey getKey(Artifact a) {
        return DependencyUtils.getKey(a);
    }

    public static class Builder
    extends BootstrapMavenContextConfig<Builder> {
        private Path secondaryLocalRepo;

        private Builder() {
        }

        public Builder setSecondaryLocalRepo(Path secondaryLocalRepo) {
            this.secondaryLocalRepo = secondaryLocalRepo;
            return this;
        }

        public MavenArtifactResolver build() throws BootstrapMavenException {
            return new MavenArtifactResolver(this);
        }
    }
}

