/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.fabric8.maven.Maven;
import io.fabric8.maven.XMLFormat;
import io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;

public class ModelUtils {
    private static Pattern unresolvedVersionPattern;
    private static final String STATE_ARTIFACT_INITIAL_VERSION = "1";

    private static Pattern getUnresolvedVersionPattern() {
        return unresolvedVersionPattern == null ? (unresolvedVersionPattern = Pattern.compile(Pattern.quote("${") + "(revision|sha1|changelist)" + Pattern.quote("}"))) : unresolvedVersionPattern;
    }

    public static ArtifactCoords getStateArtifact(ArtifactCoords appArtifact) {
        return new GACTV(appArtifact.getGroupId() + ".quarkus.curate", appArtifact.getArtifactId(), "", "pom", STATE_ARTIFACT_INITIAL_VERSION);
    }

    public static ResolvedDependency resolveAppArtifact(Path appJar) throws IOException {
        try (FileSystem fs = ZipUtils.newFileSystem((Path)appJar);){
            Path metaInfMaven = fs.getPath("META-INF", "maven");
            if (Files.exists(metaInfMaven, new LinkOption[0])) {
                try (DirectoryStream<Path> groupIds = Files.newDirectoryStream(metaInfMaven);){
                    for (Path groupIdPath : groupIds) {
                        if (!Files.isDirectory(groupIdPath, new LinkOption[0])) continue;
                        DirectoryStream<Path> artifactIds = Files.newDirectoryStream(groupIdPath);
                        try {
                            for (Path artifactIdPath : artifactIds) {
                                if (!Files.isDirectory(artifactIdPath, new LinkOption[0])) continue;
                                Path propsPath = artifactIdPath.resolve("pom.properties");
                                if (!Files.exists(propsPath, new LinkOption[0])) continue;
                                Properties props = ModelUtils.loadPomProps(appJar, artifactIdPath);
                                ResolvedDependency resolvedDependency = ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(props.getProperty("groupId"))).setArtifactId(props.getProperty("artifactId"))).setVersion(props.getProperty("version"))).setResolvedPath(appJar).build();
                                return resolvedDependency;
                            }
                        }
                        finally {
                            if (artifactIds == null) continue;
                            artifactIds.close();
                        }
                    }
                }
            }
            ResolvedDependency resolvedDependency = ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId("unknown")).setArtifactId("unknown")).setVersion("1.0-SNAPSHOT")).setResolvedPath(appJar).build();
            return resolvedDependency;
        }
    }

    static Model readAppModel(Path appJar) throws IOException {
        try (FileSystem fs = ZipUtils.newFileSystem((Path)appJar);){
            Path metaInfMaven = fs.getPath("META-INF", "maven");
            if (Files.exists(metaInfMaven, new LinkOption[0])) {
                try (DirectoryStream<Path> groupIds = Files.newDirectoryStream(metaInfMaven);){
                    for (Path groupIdPath : groupIds) {
                        if (!Files.isDirectory(groupIdPath, new LinkOption[0])) continue;
                        DirectoryStream<Path> artifactIds = Files.newDirectoryStream(groupIdPath);
                        try {
                            for (Path artifactIdPath : artifactIds) {
                                if (!Files.isDirectory(artifactIdPath, new LinkOption[0])) continue;
                                Path pomXml = artifactIdPath.resolve("pom.xml");
                                if (!Files.exists(pomXml, new LinkOption[0])) continue;
                                Model model = ModelUtils.readModel(pomXml);
                                return model;
                            }
                        }
                        finally {
                            if (artifactIds == null) continue;
                            artifactIds.close();
                        }
                    }
                }
            }
            throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.xml in " + appJar);
        }
    }

    public static String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId != null) {
            return groupId;
        }
        Parent parent = model.getParent();
        if (parent != null && (groupId = parent.getGroupId()) != null) {
            return groupId;
        }
        throw new IllegalStateException("Failed to determine groupId for project model");
    }

    public static String getRawVersion(Model model) {
        String version = model.getVersion();
        if (version != null) {
            return version;
        }
        Parent parent = model.getParent();
        if (parent != null && (version = parent.getVersion()) != null) {
            return version;
        }
        throw new IllegalStateException("Failed to determine version for project model");
    }

    public static String getVersion(Model model) {
        String rawVersion = ModelUtils.getRawVersion(model);
        return ModelUtils.isUnresolvedVersion(rawVersion) ? ModelUtils.resolveVersion(rawVersion, model) : rawVersion;
    }

    public static boolean isUnresolvedVersion(String version) {
        return ModelUtils.getUnresolvedVersionPattern().matcher(version).find();
    }

    public static String resolveVersion(String rawVersion, Model rawModel) {
        HashMap<String, String> props = new HashMap<String, String>();
        ModelUtils.putAll(props, rawModel.getProperties());
        ModelUtils.putAll(props, System.getProperties());
        Matcher matcher = ModelUtils.getUnresolvedVersionPattern().matcher(rawVersion);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String resolved = (String)props.get(matcher.group(1));
            if (resolved == null) {
                return null;
            }
            if (resolved.contains("${")) {
                throw new IllegalArgumentException("Illegal placeholder in Maven CI friendly version property \"" + matcher.group(1) + "\": " + resolved + "\n\tPlease consult https://maven.apache.org/maven-ci-friendly.html#single-project-setup");
            }
            matcher.appendReplacement(sb, resolved);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static void putAll(Map<String, String> map, Properties props) {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            map.put(e.getKey().toString(), e.getValue().toString());
        }
    }

    public static Model applySystemProperties(Model model) {
        Properties props = model.getProperties();
        for (Map.Entry<Object, Object> prop : model.getProperties().entrySet()) {
            String systemValue = PropertyUtils.getProperty((String)prop.getKey().toString());
            if (systemValue == null) continue;
            props.put(prop.getKey(), systemValue);
        }
        return model;
    }

    private static Properties loadPomProps(Path appJar, Path artifactIdPath) throws IOException {
        Path propsPath = artifactIdPath.resolve("pom.properties");
        if (!Files.exists(propsPath, new LinkOption[0])) {
            throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.properties in " + appJar);
        }
        Properties props = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(propsPath);){
            props.load(reader);
        }
        return props;
    }

    public static Model readModel(Path pomXml) throws IOException {
        try {
            return Maven.readModel((Path)pomXml);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        catch (RuntimeException e) {
            throw new IOException("Failed to read model", e.getCause());
        }
    }

    public static Model readModel(InputStream stream) throws IOException {
        Model model;
        block9: {
            InputStream is = stream;
            try {
                model = Maven.readModel((InputStream)is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
                catch (RuntimeException e) {
                    throw new IOException("Failed to read model", e.getCause());
                }
            }
            is.close();
        }
        return model;
    }

    public static void persistModel(Path pomFile, Model model) throws IOException {
        try {
            Maven.writeModel((Model)model, (Path)pomFile, (XMLFormat)XMLFormat.builder().indent("    ").insertLineBreakBetweenMajorSections().build());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

