/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.spi;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageReference {
    private static final String DOCKER_HUB_REGISTRY = "registry-1.docker.io";
    private static final String DEFAULT_TAG = "latest";
    private static final String LIBRARY_REPOSITORY_PREFIX = "library/";
    private static final String REGISTRY_COMPONENT_REGEX = "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))";
    private static final String REGISTRY_REGEX = String.format("%s(?:\\.%s)*(?::\\d+)?", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))");
    private static final String REPOSITORY_COMPONENT_REGEX = "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*";
    private static final String REPOSITORY_REGEX = String.format("(?:%s/)*%s", "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*", "[a-z\\d]+(?:(?:[_.]|__|-+)[a-z\\d]+)*");
    private static final String TAG_REGEX = "[\\w][\\w.-]{0,127}";
    private static final String HASH_REGEX = String.format("[a-f0-9]{%d}", 64);
    private static final String DIGEST_PREFIX = "sha256:";
    private static final String DIGEST_REGEX = "sha256:" + HASH_REGEX;
    private static final String REFERENCE_REGEX = String.format("^(?:(%s)/)?(%s)(?::(%s))?(?:@(%s))?$", REGISTRY_REGEX, REPOSITORY_REGEX, "[\\w][\\w.-]{0,127}", DIGEST_REGEX);
    private static final Pattern REFERENCE_PATTERN = Pattern.compile(REFERENCE_REGEX);
    private final String registry;
    private final String repository;
    private final String tag;
    private final String digest;

    public static boolean isValidRegistry(String registry) {
        return registry.matches(REGISTRY_REGEX);
    }

    public static boolean isValidRepository(String repository) {
        return repository.matches(REPOSITORY_REGEX);
    }

    public static boolean isValidTag(String tag) {
        return tag.matches(TAG_REGEX);
    }

    public static ImageReference parse(String reference) {
        Matcher matcher = REFERENCE_PATTERN.matcher(reference);
        if (!matcher.find() || matcher.groupCount() < 4) {
            throw new IllegalArgumentException("Reference " + reference + " is invalid");
        }
        String registry = matcher.group(1);
        Object repository = matcher.group(2);
        String tag = matcher.group(3);
        String digest = matcher.group(4);
        if (Strings.isNullOrEmpty((String)registry)) {
            registry = DOCKER_HUB_REGISTRY;
        }
        if (Strings.isNullOrEmpty((String)repository)) {
            throw new IllegalArgumentException("Reference " + reference + " is invalid: The repository was not set");
        }
        if (!(registry.contains(".") || registry.contains(":") || "localhost".equals(registry))) {
            repository = registry + "/" + (String)repository;
            registry = DOCKER_HUB_REGISTRY;
        }
        if (DOCKER_HUB_REGISTRY.equals(registry) && ((String)repository).indexOf(47) < 0) {
            repository = LIBRARY_REPOSITORY_PREFIX + (String)repository;
        }
        if (Strings.isNullOrEmpty((String)tag) && Strings.isNullOrEmpty((String)digest)) {
            tag = DEFAULT_TAG;
        }
        if (Strings.isNullOrEmpty((String)tag)) {
            tag = null;
        }
        if (Strings.isNullOrEmpty((String)digest)) {
            digest = null;
        }
        return new ImageReference(registry, (String)repository, tag, digest);
    }

    private ImageReference(String registry, String repository, String tag, String digest) {
        this.registry = registry;
        this.repository = repository;
        this.tag = tag;
        this.digest = digest;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDigest() {
        return this.digest;
    }
}

