/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.util.ExecUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class IsDockerWorking
implements BooleanSupplier {
    private static final Logger LOGGER = Logger.getLogger((String)IsDockerWorking.class.getName());
    private final boolean silent;

    public IsDockerWorking() {
        this(false);
    }

    public IsDockerWorking(boolean silent) {
        this.silent = silent;
    }

    @Override
    public boolean getAsBoolean() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (dockerHost != null && !dockerHost.startsWith("unix:")) {
            boolean bl;
            URI url = new URI(dockerHost);
            Socket s = new Socket(url.getHost(), url.getPort());
            try {
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.warnf("Unable to connect to DOCKER_HOST URI %s, make sure docker is running on the specified host", (Object)dockerHost);
                    }
                }
                catch (URISyntaxException e) {
                    LOGGER.warnf("Unable to parse DOCKER_HOST URI %s, it will be ignored for working docker detection", (Object)dockerHost);
                }
            }
            s.close();
            return bl;
        }
        try {
            if (!ExecUtil.execSilent("docker", "-v")) {
                LOGGER.warn((Object)"'docker -v' returned an error code. Make sure your Docker binary is correct");
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.warnf("No Docker binary found or general error: %s", (Object)e);
            return false;
        }
        try {
            OutputFilter filter = new OutputFilter();
            if (ExecUtil.exec(new File("."), filter, "docker", "version", "--format", "'{{.Server.Version}}'")) {
                LOGGER.debugf("Docker daemon found. Version: %s", (Object)filter.getOutput());
                return true;
            }
            if (!this.silent) {
                LOGGER.warn((Object)"Could not determine version of Docker daemon");
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unexpected error occurred while determining Docker daemon version", (Throwable)e);
            return false;
        }
    }

    public static class IsDockerRunningSilent
    extends IsDockerWorking {
        public IsDockerRunningSilent() {
            super(true);
        }
    }

    public static class OutputFilter
    implements Function<InputStream, Runnable> {
        private final StringBuilder builder = new StringBuilder();

        @Override
        public Runnable apply(InputStream is) {
            return () -> {
                try (InputStreamReader isr = new InputStreamReader(is);
                     BufferedReader reader = new BufferedReader(isr);){
                    String line = reader.readLine();
                    while (line != null) {
                        this.builder.append(line);
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading stream.", e);
                }
            };
        }

        public String getOutput() {
            return this.builder.toString();
        }
    }
}

