/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Objects;
import org.jboss.logging.Logger;

public final class CapabilityBuildItem
extends MultiBuildItem {
    private static volatile Logger log;
    private final String name;
    private final String provider;

    private static Logger getLog() {
        return log == null ? (log = Logger.getLogger(CapabilityBuildItem.class)) : log;
    }

    @Deprecated
    public CapabilityBuildItem(String name) {
        this(name, StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getName());
        String msg = "An instance of " + CapabilityBuildItem.class.getName() + " was created using a deprecated constructor by " + this.provider + " to provide capability '" + name + "'. Please report this issue to the extension maintainers to fix it in the future releases.";
        Logger log = CapabilityBuildItem.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)msg, (Throwable)new Exception(msg));
        } else {
            log.warn((Object)msg);
        }
    }

    public CapabilityBuildItem(String name, String provider) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.provider = Objects.requireNonNull(provider, "provider cannot be null");
    }

    public String getName() {
        return this.name;
    }

    public String getProvider() {
        return this.provider;
    }
}

