/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.quarkus.deployment.codegen.CodeGenData;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingConfig;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingValueTransformer;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingWriter;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathCollection;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.ClassPathUtils;
import io.smallrye.config.SmallRyeConfig;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.jboss.logging.Logger;

public class CodeGenerator {
    private static final Logger log = Logger.getLogger(CodeGenerator.class);
    private static final String META_INF_SERVICES = "META-INF/services/";
    private static final List<String> CONFIG_SERVICES = List.of("org.eclipse.microprofile.config.spi.Converter", "org.eclipse.microprofile.config.spi.ConfigSource", "org.eclipse.microprofile.config.spi.ConfigSourceProvider", "io.smallrye.config.ConfigSourceInterceptor", "io.smallrye.config.ConfigSourceInterceptorFactory", "io.smallrye.config.ConfigSourceFactory", "io.smallrye.config.SecretKeysHandler", "io.smallrye.config.SecretKeysHandlerFactory", "io.smallrye.config.ConfigValidator");

    public static void initAndRun(QuarkusClassLoader classLoader, PathCollection sourceParentDirs, Path generatedSourcesDir, Path buildDir, Consumer<Path> sourceRegistrar, ApplicationModel appModel, Properties properties, String launchMode, boolean test) throws CodeGenException {
        HashMap<String, String> props = new HashMap<String, String>();
        properties.entrySet().stream().forEach(e -> props.put((String)e.getKey(), (String)e.getValue()));
        List<CodeGenData> generators = CodeGenerator.init(appModel, props, (ClassLoader)classLoader, sourceParentDirs, generatedSourcesDir, buildDir, sourceRegistrar);
        if (generators.isEmpty()) {
            return;
        }
        LaunchMode mode = LaunchMode.valueOf((String)launchMode);
        Config config = CodeGenerator.getConfig(appModel, mode, properties, classLoader);
        for (CodeGenData generator : generators) {
            generator.setRedirectIO(true);
            CodeGenerator.trigger((ClassLoader)classLoader, generator, appModel, config, test);
        }
    }

    private static List<CodeGenData> init(ApplicationModel model, Map<String, String> properties, ClassLoader deploymentClassLoader, PathCollection sourceParentDirs, Path generatedSourcesDir, Path buildDir, Consumer<Path> sourceRegistrar) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            List<CodeGenProvider> codeGenProviders = CodeGenerator.loadCodeGenProviders(deploymentClassLoader);
            if (codeGenProviders.isEmpty()) {
                return List.of();
            }
            ArrayList<CodeGenData> result = new ArrayList<CodeGenData>(codeGenProviders.size());
            for (CodeGenProvider provider : codeGenProviders) {
                provider.init(model, properties);
                Path outputDir = CodeGenerator.codeGenOutDir(generatedSourcesDir, provider, sourceRegistrar);
                for (Path sourceParentDir : sourceParentDirs) {
                    Path in = provider.getInputDirectory();
                    if (in == null) {
                        in = sourceParentDir.resolve(provider.inputDirectory());
                    }
                    result.add(new CodeGenData(provider, outputDir, in, buildDir));
                }
            }
            return result;
        });
    }

    public static List<CodeGenData> init(ApplicationModel model, Map<String, String> properties, ClassLoader deploymentClassLoader, Collection<DevModeContext.ModuleInfo> modules) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            List<CodeGenProvider> codeGenProviders = null;
            List<CodeGenData> codeGens = List.of();
            for (DevModeContext.ModuleInfo module : modules) {
                if (module.getSourceParents().isEmpty() || module.getPreBuildOutputDir() == null) continue;
                if (codeGenProviders == null && (codeGenProviders = CodeGenerator.loadCodeGenProviders(deploymentClassLoader)).isEmpty()) {
                    return List.of();
                }
                for (CodeGenProvider provider : codeGenProviders) {
                    provider.init(model, properties);
                    Path outputDir = CodeGenerator.codeGenOutDir(Path.of(module.getPreBuildOutputDir(), new String[0]), provider, sourcePath -> module.addSourcePathFirst(sourcePath.toAbsolutePath().toString()));
                    for (Path sourceParentDir : module.getSourceParents()) {
                        Path in;
                        if (codeGens.isEmpty()) {
                            codeGens = new ArrayList();
                        }
                        if ((in = provider.getInputDirectory()) == null) {
                            in = sourceParentDir.resolve(provider.inputDirectory());
                        }
                        codeGens.add(new CodeGenData(provider, outputDir, in, Path.of(module.getTargetDir(), new String[0])));
                    }
                }
            }
            return codeGens;
        });
    }

    private static List<CodeGenProvider> loadCodeGenProviders(ClassLoader deploymentClassLoader) throws CodeGenException {
        Class<?> codeGenProviderClass;
        try {
            codeGenProviderClass = deploymentClassLoader.loadClass(CodeGenProvider.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenException("Failed to load CodeGenProvider class from deployment classloader", (Throwable)e);
        }
        Iterator<?> i = ServiceLoader.load(codeGenProviderClass, deploymentClassLoader).iterator();
        if (!i.hasNext()) {
            return List.of();
        }
        ArrayList<CodeGenProvider> codeGenProviders = new ArrayList<CodeGenProvider>();
        while (i.hasNext()) {
            codeGenProviders.add((CodeGenProvider)i.next());
        }
        return codeGenProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T callWithClassloader(ClassLoader deploymentClassLoader, CodeGenAction<T> supplier) throws CodeGenException {
        ClassLoader originalClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(deploymentClassLoader);
            T t = supplier.fire();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
    }

    public static boolean trigger(ClassLoader deploymentClassLoader, CodeGenData data, ApplicationModel appModel, Config config, boolean test) throws CodeGenException {
        return CodeGenerator.callWithClassloader(deploymentClassLoader, () -> {
            CodeGenProvider provider = data.provider;
            return provider.shouldRun(data.sourceDir, config) && provider.trigger(new CodeGenContext(appModel, data.outPath, data.buildDir, data.sourceDir, data.redirectIO, config, test));
        });
    }

    public static void dumpCurrentConfigValues(ApplicationModel appModel, String launchMode, Properties buildSystemProps, QuarkusClassLoader deploymentClassLoader, Properties previouslyRecordedProperties, Path outputFile) {
        LaunchMode mode = LaunchMode.valueOf((String)launchMode);
        if (previouslyRecordedProperties.isEmpty()) {
            try {
                CodeGenerator.readConfig(appModel, mode, buildSystemProps, deploymentClassLoader, configReader -> {
                    SmallRyeConfig config = configReader.initConfiguration(mode, buildSystemProps, appModel.getPlatformProperties());
                    HashMap<String, String> allProps = new HashMap<String, String>();
                    for (String name : config.getPropertyNames()) {
                        allProps.put(name, ConfigTrackingValueTransformer.asString((ConfigValue)config.getConfigValue(name)));
                    }
                    ConfigTrackingWriter.write(allProps, (ConfigTrackingConfig)((SmallRyeConfig)config.unwrap(SmallRyeConfig.class)).getConfigMapping(ConfigTrackingConfig.class), configReader.readConfiguration(config), outputFile);
                    return null;
                });
            }
            catch (CodeGenException e) {
                throw new RuntimeException("Failed to load application configuration", e);
            }
            return;
        }
        Config config = null;
        try {
            config = CodeGenerator.getConfig(appModel, mode, buildSystemProps, deploymentClassLoader);
        }
        catch (CodeGenException e) {
            throw new RuntimeException("Failed to load application configuration", e);
        }
        ConfigTrackingValueTransformer valueTransformer = ConfigTrackingValueTransformer.newInstance(config);
        Properties currentValues = new Properties(previouslyRecordedProperties.size());
        for (Map.Entry<Object, Object> prevProp : previouslyRecordedProperties.entrySet()) {
            String name = prevProp.getKey().toString();
            ConfigValue currentValue = config.getConfigValue(name);
            String current = valueTransformer.transform(name, currentValue);
            Object originalValue = prevProp.getValue();
            if (!originalValue.equals(current)) {
                log.info((Object)("Option " + name + " has changed since the last build from " + originalValue + " to " + current));
            }
            if (current == null) continue;
            currentValues.put(name, current);
        }
        ArrayList<String> names = new ArrayList<String>(currentValues.stringPropertyNames());
        Collections.sort(names);
        Path outputDir = outputFile.getParent();
        if (outputDir != null && !Files.exists(outputDir, new LinkOption[0])) {
            try {
                Files.createDirectories(outputDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, new OpenOption[0]);){
            for (String name : names) {
                ConfigTrackingWriter.write(writer, name, currentValues.getProperty(name));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Config getConfig(ApplicationModel appModel, LaunchMode launchMode, Properties buildSystemProps, QuarkusClassLoader deploymentClassLoader) throws CodeGenException {
        return (Config)CodeGenerator.readConfig(appModel, launchMode, buildSystemProps, deploymentClassLoader, configReader -> configReader.initConfiguration(launchMode, buildSystemProps, appModel.getPlatformProperties()));
    }

    public static <T> T readConfig(ApplicationModel appModel, LaunchMode launchMode, Properties buildSystemProps, QuarkusClassLoader deploymentClassLoader, Function<BuildTimeConfigurationReader, T> function) throws CodeGenException {
        Object sb;
        Map<String, List<String>> unavailableConfigServices = CodeGenerator.getUnavailableConfigServices(appModel.getAppArtifact(), (ClassLoader)deploymentClassLoader);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (!unavailableConfigServices.isEmpty()) {
            sb = new StringBuilder();
            ((StringBuilder)sb).append("The following services are not (yet) available and will be disabled during configuration initialization at the current build phase:");
            for (Map.Entry<String, List<String>> missingService : unavailableConfigServices.entrySet()) {
                ((StringBuilder)sb).append(System.lineSeparator());
                for (String string : missingService.getValue()) {
                    ((StringBuilder)sb).append("- ").append(string);
                }
            }
            log.warn((Object)((StringBuilder)sb).toString());
            HashMap allConfigServices = new HashMap(unavailableConfigServices.size());
            HashMap<String, byte[]> allowedConfigServices = new HashMap<String, byte[]>(unavailableConfigServices.size());
            HashMap<String, byte[]> bannedConfigServices = new HashMap<String, byte[]>(unavailableConfigServices.size());
            for (Map.Entry<String, List<String>> entry : unavailableConfigServices.entrySet()) {
                String service = entry.getKey();
                try {
                    ClassPathUtils.consumeAsPaths((ClassLoader)deploymentClassLoader, (String)service, p -> {
                        try {
                            allConfigServices.computeIfAbsent(service, k -> new ArrayList()).addAll(Files.readAllLines(p));
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("Failed to read " + p, e);
                        }
                    });
                }
                catch (IOException e) {
                    throw new CodeGenException("Failed to read resources from classpath", (Throwable)e);
                }
                List allServices = allConfigServices.getOrDefault(service, List.of());
                allServices.removeAll((Collection)entry.getValue());
                if (allServices.isEmpty()) {
                    bannedConfigServices.put(service, new byte[0]);
                    continue;
                }
                StringJoiner joiner = new StringJoiner(System.lineSeparator());
                allServices.forEach(joiner::add);
                allowedConfigServices.put(service, joiner.toString().getBytes());
            }
            QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder((String)"CodeGenerator Config ClassLoader", (ClassLoader)deploymentClassLoader, (boolean)false);
            if (!allowedConfigServices.isEmpty()) {
                builder.addElement((ClassPathElement)new MemoryClassPathElement(allowedConfigServices, true));
            }
            if (!bannedConfigServices.isEmpty()) {
                builder.addBannedElement((ClassPathElement)new MemoryClassPathElement(bannedConfigServices, true));
            }
            deploymentClassLoader = builder.build();
            Thread.currentThread().setContextClassLoader((ClassLoader)deploymentClassLoader);
        }
        try {
            sb = function.apply(new BuildTimeConfigurationReader((ClassLoader)deploymentClassLoader));
            return (T)sb;
        }
        catch (Exception e) {
            throw new CodeGenException("Failed to initialize application configuration", (Throwable)e);
        }
        finally {
            if (!unavailableConfigServices.isEmpty()) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                deploymentClassLoader.close();
            }
        }
    }

    private static Map<String, List<String>> getUnavailableConfigServices(ResolvedDependency dep, ClassLoader classLoader) throws CodeGenException {
        HashMap<String, List<String>> hashMap;
        block8: {
            OpenPathTree openTree = dep.getContentTree().open();
            try {
                HashMap<String, List<String>> unavailableServices = new HashMap<String, List<String>>();
                openTree.apply(META_INF_SERVICES, visit -> {
                    if (visit == null) {
                        return null;
                    }
                    Path servicesDir = visit.getPath();
                    for (String serviceClass : CONFIG_SERVICES) {
                        Path serviceFile = servicesDir.resolve(serviceClass);
                        if (!Files.exists(serviceFile, new LinkOption[0])) continue;
                        List unavailableList = unavailableServices.computeIfAbsent(META_INF_SERVICES + serviceClass, k -> new ArrayList());
                        try {
                            Files.readAllLines(serviceFile).stream().map(String::trim).filter(line -> !line.startsWith("#") && !line.isEmpty()).filter(className -> classLoader.getResource(ClassLoaderHelper.fromClassNameToResourceName((String)className)) == null).forEach(unavailableList::add);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("Failed to read " + serviceFile, e);
                        }
                    }
                    return null;
                });
                hashMap = unavailableServices;
                if (openTree == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (openTree != null) {
                        try {
                            openTree.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CodeGenException("Failed to read " + dep.getResolvedPaths(), (Throwable)e);
                }
            }
            openTree.close();
        }
        return hashMap;
    }

    private static Path codeGenOutDir(Path generatedSourcesDir, CodeGenProvider provider, Consumer<Path> sourceRegistrar) throws CodeGenException {
        Path outputDir = generatedSourcesDir.resolve(provider.providerId());
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
            sourceRegistrar.accept(outputDir);
            return outputDir;
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to create output directory for generated sources: " + outputDir.toAbsolutePath(), (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface CodeGenAction<T> {
        public T fire() throws CodeGenException;
    }
}

