/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg;

import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithParentName;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
@ConfigMapping(prefix="quarkus.native")
public interface NativeConfig {
    public static final String DEFAULT_GRAALVM_BUILDER_IMAGE = "quay.io/quarkus/ubi-quarkus-graalvmce-builder-image:jdk-21";
    public static final String DEFAULT_MANDREL_BUILDER_IMAGE = "quay.io/quarkus/ubi-quarkus-mandrel-builder-image:jdk-21";

    @WithDefault(value="false")
    public boolean enabled();

    @WithDefault(value="false")
    public boolean sourcesOnly();

    public Optional<List<String>> additionalBuildArgs();

    @WithDefault(value="true")
    public boolean enableHttpUrlHandler();

    @WithDefault(value="false")
    public boolean enableHttpsUrlHandler();

    @WithDefault(value="false")
    @Deprecated
    public boolean enableAllSecurityServices();

    @Deprecated
    @WithDefault(value="true")
    public boolean inlineBeforeAnalysis();

    @Deprecated
    @WithDefault(value="true")
    public boolean enableJni();

    @WithDefault(value="true")
    public boolean headless();

    @WithConverter(value=TrimmedStringConverter.class)
    @Deprecated
    public Optional<String> userLanguage();

    @WithConverter(value=TrimmedStringConverter.class)
    @Deprecated
    public Optional<String> userCountry();

    @WithDefault(value="UTF-8")
    @WithConverter(value=TrimmedStringConverter.class)
    public String fileEncoding();

    @WithDefault(value="false")
    public boolean addAllCharsets();

    @WithDefault(value="${GRAALVM_HOME:}")
    public Optional<String> graalvmHome();

    @WithDefault(value="${java.home}")
    public File javaHome();

    public Optional<String> nativeImageXmx();

    @WithDefault(value="false")
    public boolean debugBuildProcess();

    @WithDefault(value="true")
    public boolean publishDebugBuildProcessPort();

    @Deprecated
    @WithDefault(value="false")
    public boolean cleanupServer();

    @WithDefault(value="true")
    public boolean enableIsolates();

    @WithDefault(value="false")
    public boolean enableFallbackImages();

    @Deprecated
    @WithDefault(value="false")
    public boolean enableServer();

    @WithDefault(value="false")
    public boolean autoServiceLoaderRegistration();

    @WithDefault(value="false")
    public boolean dumpProxies();

    public Optional<Boolean> containerBuild();

    public Optional<Boolean> pie();

    public Optional<String> march();

    @WithDefault(value="false")
    public boolean remoteContainerBuild();

    default public boolean isExplicitContainerBuild() {
        return this.containerBuild().orElse(this.containerRuntime().isPresent() || this.remoteContainerBuild());
    }

    public BuilderImageConfig builderImage();

    public Optional<ContainerRuntimeUtil.ContainerRuntime> containerRuntime();

    public Optional<List<String>> containerRuntimeOptions();

    @WithDefault(value="false")
    @Deprecated
    public boolean enableVmInspection();

    public Optional<List<MonitoringOption>> monitoring();

    @WithDefault(value="true")
    @Deprecated
    public boolean fullStackTraces();

    @WithDefault(value="false")
    public boolean enableReports();

    @WithDefault(value="true")
    public boolean reportExceptionStackTraces();

    @WithDefault(value="false")
    public boolean reportErrorsAtRuntime();

    @WithDefault(value="false")
    public boolean reuseExisting();

    public ResourcesConfig resources();

    public Debug debug();

    @WithDefault(value="false")
    public boolean enableDashboardDump();

    public Compression compression();

    @WithDefault(value="false")
    public boolean agentConfigurationApply();

    public static enum ImagePullStrategy {
        ALWAYS,
        MISSING,
        NEVER;

    }

    public static enum MonitoringOption {
        HEAPDUMP,
        JVMSTAT,
        JFR,
        JMXSERVER,
        JMXCLIENT,
        ALL;

    }

    public static enum BuilderImageProvider {
        GRAALVM,
        MANDREL;

    }

    @ConfigGroup
    public static interface Compression {
        public OptionalInt level();

        public Optional<List<String>> additionalArgs();
    }

    @ConfigGroup
    public static interface Debug {
        @WithDefault(value="false")
        public boolean enabled();
    }

    public static interface ResourcesConfig {
        public Optional<List<String>> includes();

        public Optional<List<String>> excludes();
    }

    public static interface BuilderImageConfig {
        @WithParentName
        @WithDefault(value="${platform.quarkus.native.builder-image}")
        @ConfigDocDefault(value="mandrel")
        public String image();

        @WithDefault(value="always")
        public ImagePullStrategy pull();

        default public String getEffectiveImage() {
            String builderImageName = this.image().toUpperCase();
            if (builderImageName.equals(BuilderImageProvider.GRAALVM.name())) {
                return NativeConfig.DEFAULT_GRAALVM_BUILDER_IMAGE;
            }
            if (builderImageName.equals(BuilderImageProvider.MANDREL.name())) {
                return NativeConfig.DEFAULT_MANDREL_BUILDER_IMAGE;
            }
            return this.image();
        }
    }
}

