/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.builder.Json;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ForceNonWeakReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassConditionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NativeImageReflectConfigStep {
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void generateReflectConfig(BuildProducer<GeneratedResourceBuildItem> reflectConfig, List<ReflectiveMethodBuildItem> reflectiveMethods, List<ReflectiveFieldBuildItem> reflectiveFields, List<ReflectiveClassBuildItem> reflectiveClassBuildItems, List<ForceNonWeakReflectiveClassBuildItem> nonWeakReflectiveClassBuildItems, List<ServiceProviderBuildItem> serviceProviderBuildItems, List<ReflectiveClassConditionBuildItem> reflectiveClassConditionBuildItems) {
        LinkedHashMap<String, ReflectionInfo> reflectiveClasses = new LinkedHashMap<String, ReflectionInfo>();
        HashSet<String> forcedNonWeakClasses = new HashSet<String>();
        for (ForceNonWeakReflectiveClassBuildItem forceNonWeakReflectiveClassBuildItem : nonWeakReflectiveClassBuildItems) {
            forcedNonWeakClasses.add(forceNonWeakReflectiveClassBuildItem.getClassName());
        }
        for (ReflectiveClassBuildItem reflectiveClassBuildItem : reflectiveClassBuildItems) {
            this.addReflectiveClass(reflectiveClasses, forcedNonWeakClasses, reflectiveClassBuildItem);
        }
        for (ReflectiveFieldBuildItem reflectiveFieldBuildItem : reflectiveFields) {
            this.addReflectiveField(reflectiveClasses, reflectiveFieldBuildItem);
        }
        for (ReflectiveMethodBuildItem reflectiveMethodBuildItem : reflectiveMethods) {
            this.addReflectiveMethod(reflectiveClasses, reflectiveMethodBuildItem);
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            for (String provider : serviceProviderBuildItem.providers()) {
                this.addReflectiveMethod(reflectiveClasses, new ReflectiveMethodBuildItem(provider, "<init>", new String[0]));
                this.addReflectiveMethod(reflectiveClasses, new ReflectiveMethodBuildItem(true, provider, "provider", new String[0]));
            }
        }
        for (ReflectiveClassConditionBuildItem reflectiveClassConditionBuildItem : reflectiveClassConditionBuildItems) {
            reflectiveClasses.computeIfPresent(reflectiveClassConditionBuildItem.getClassName(), (key, value) -> {
                value.typeReachable = reflectiveClassConditionBuildItem.getTypeReachable();
                return value;
            });
        }
        Json.JsonArrayBuilder root = Json.array();
        for (Map.Entry entry : reflectiveClasses.entrySet()) {
            Json.JsonObjectBuilder json = Json.object();
            json.put("name", (String)entry.getKey());
            ReflectionInfo info = (ReflectionInfo)entry.getValue();
            Json.JsonArrayBuilder methodsArray = Json.array();
            Json.JsonArrayBuilder queriedMethodsArray = Json.array();
            if (info.typeReachable != null) {
                json.put("condition", Json.object().put("typeReachable", info.typeReachable));
            }
            if (info.constructors) {
                json.put("allDeclaredConstructors", true);
            } else {
                if (info.queryConstructors) {
                    json.put("queryAllDeclaredConstructors", true);
                }
                if (!info.ctorSet.isEmpty()) {
                    NativeImageReflectConfigStep.extractToJsonArray(info.ctorSet, methodsArray);
                }
            }
            if (info.methods) {
                json.put("allDeclaredMethods", true);
            } else {
                if (info.queryMethods) {
                    json.put("queryAllDeclaredMethods", true);
                }
                if (!info.methodSet.isEmpty()) {
                    NativeImageReflectConfigStep.extractToJsonArray(info.methodSet, methodsArray);
                }
                if (!info.queriedMethodSet.isEmpty()) {
                    NativeImageReflectConfigStep.extractToJsonArray(info.queriedMethodSet, queriedMethodsArray);
                }
            }
            if (!methodsArray.isEmpty()) {
                json.put("methods", methodsArray);
            }
            if (!queriedMethodsArray.isEmpty()) {
                json.put("queriedMethods", queriedMethodsArray);
            }
            if (info.fields) {
                json.put("allDeclaredFields", true);
            } else if (!info.fieldSet.isEmpty()) {
                Json.JsonArrayBuilder fieldsArray = Json.array();
                for (String fieldName : info.fieldSet) {
                    fieldsArray.add(Json.object().put("name", fieldName));
                }
                json.put("fields", fieldsArray);
            }
            if (info.classes) {
                json.put("allDeclaredClasses", true);
            }
            if (info.unsafeAllocated) {
                json.put("unsafeAllocated", true);
            }
            root.add(json);
        }
        try (StringWriter stringWriter = new StringWriter();){
            root.appendTo((Appendable)stringWriter);
            reflectConfig.produce(new GeneratedResourceBuildItem("META-INF/native-image/reflect-config.json", stringWriter.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void extractToJsonArray(Set<ReflectiveMethodBuildItem> methodSet, Json.JsonArrayBuilder methodsArray) {
        for (ReflectiveMethodBuildItem method : methodSet) {
            Json.JsonObjectBuilder methodObject = Json.object();
            methodObject.put("name", method.getName());
            Json.JsonArrayBuilder paramsArray = Json.array();
            for (int i = 0; i < method.getParams().length; ++i) {
                paramsArray.add(method.getParams()[i]);
            }
            methodObject.put("parameterTypes", paramsArray);
            methodsArray.add(methodObject);
        }
    }

    public void addReflectiveMethod(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveMethodBuildItem methodInfo) {
        String cl = methodInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo();
            reflectiveClasses.put(cl, existing);
        }
        if (methodInfo.getName().equals("<init>")) {
            existing.ctorSet.add(methodInfo);
        } else if (methodInfo.isQueryOnly()) {
            existing.queriedMethodSet.add(methodInfo);
        } else {
            existing.methodSet.add(methodInfo);
        }
    }

    public void addReflectiveClass(Map<String, ReflectionInfo> reflectiveClasses, Set<String> forcedNonWeakClasses, ReflectiveClassBuildItem classBuildItem) {
        for (String cl : classBuildItem.getClassNames()) {
            ReflectionInfo existing = reflectiveClasses.get(cl);
            if (existing == null) {
                String typeReachable = !forcedNonWeakClasses.contains(cl) && classBuildItem.isWeak() ? cl : null;
                reflectiveClasses.put(cl, new ReflectionInfo(classBuildItem, typeReachable));
                continue;
            }
            if (classBuildItem.isConstructors()) {
                existing.constructors = true;
            }
            if (classBuildItem.isQueryConstructors()) {
                existing.queryConstructors = true;
            }
            if (classBuildItem.isMethods()) {
                existing.methods = true;
            }
            if (classBuildItem.isQueryMethods()) {
                existing.queryMethods = true;
            }
            if (classBuildItem.isFields()) {
                existing.fields = true;
            }
            if (classBuildItem.isClasses()) {
                existing.classes = true;
            }
            if (classBuildItem.isSerialization()) {
                existing.serialization = true;
            }
            if (!classBuildItem.isUnsafeAllocated()) continue;
            existing.unsafeAllocated = true;
        }
    }

    public void addReflectiveField(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveFieldBuildItem fieldInfo) {
        String cl = fieldInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo();
            reflectiveClasses.put(cl, existing);
        }
        existing.fieldSet.add(fieldInfo.getName());
    }

    static final class ReflectionInfo {
        boolean constructors;
        boolean queryConstructors;
        boolean methods;
        boolean queryMethods;
        boolean fields;
        boolean classes;
        boolean serialization;
        boolean unsafeAllocated;
        String typeReachable;
        Set<String> fieldSet = new HashSet<String>();
        Set<ReflectiveMethodBuildItem> methodSet = new HashSet<ReflectiveMethodBuildItem>();
        Set<ReflectiveMethodBuildItem> queriedMethodSet = new HashSet<ReflectiveMethodBuildItem>();
        Set<ReflectiveMethodBuildItem> ctorSet = new HashSet<ReflectiveMethodBuildItem>();

        private ReflectionInfo() {
        }

        private ReflectionInfo(ReflectiveClassBuildItem classBuildItem, String typeReachable) {
            this.methods = classBuildItem.isMethods();
            this.queryMethods = classBuildItem.isQueryMethods();
            this.fields = classBuildItem.isFields();
            this.classes = classBuildItem.isClasses();
            this.typeReachable = typeReachable;
            this.constructors = classBuildItem.isConstructors();
            this.queryConstructors = classBuildItem.isQueryConstructors();
            this.serialization = classBuildItem.isSerialization();
            this.unsafeAllocated = classBuildItem.isUnsafeAllocated();
        }
    }
}

