/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.configuration.matching.ConfigPatternMap;
import io.quarkus.deployment.configuration.matching.Container;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.util.ClassPathUtils;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappings;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigDescriptionBuildStep {
    @BuildStep
    List<ConfigDescriptionBuildItem> createConfigDescriptions(ConfigurationBuildItem config) throws Exception {
        Properties javadoc = new Properties();
        ClassPathUtils.consumeAsStreams((String)"META-INF/quarkus-javadoc.properties", in -> {
            try {
                javadoc.load((InputStream)in);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        ArrayList<ConfigDescriptionBuildItem> ret = new ArrayList<ConfigDescriptionBuildItem>();
        this.processConfig(config.getReadResult().getBuildTimePatternMap(), ret, javadoc, ConfigPhase.BUILD_TIME);
        this.processConfig(config.getReadResult().getBuildTimeRunTimePatternMap(), ret, javadoc, ConfigPhase.BUILD_AND_RUN_TIME_FIXED);
        this.processConfig(config.getReadResult().getRunTimePatternMap(), ret, javadoc, ConfigPhase.RUN_TIME);
        this.processMappings(config.getReadResult().getBuildTimeMappings(), ret, javadoc, ConfigPhase.BUILD_TIME);
        this.processMappings(config.getReadResult().getBuildTimeRunTimeMappings(), ret, javadoc, ConfigPhase.BUILD_AND_RUN_TIME_FIXED);
        this.processMappings(config.getReadResult().getRunTimeMappings(), ret, javadoc, ConfigPhase.RUN_TIME);
        return ret;
    }

    private void processConfig(ConfigPatternMap<Container> patterns, List<ConfigDescriptionBuildItem> ret, Properties javadoc, ConfigPhase configPhase) {
        for (String childName : patterns.childNames()) {
            ConfigPatternMap<Container> child = patterns.getChild(childName);
            this.processConfigChild(childName, child, ret, javadoc, configPhase);
        }
    }

    private void processConfigChild(final String name, ConfigPatternMap<Container> patterns, final List<ConfigDescriptionBuildItem> ret, final Properties javadoc, final ConfigPhase configPhase) {
        Iterable<String> childNames = patterns.childNames();
        if (childNames.iterator().hasNext()) {
            for (String childName : childNames) {
                ConfigPatternMap<Container> child = patterns.getChild(childName);
                this.processConfigChild(name + "." + childName, child, ret, javadoc, configPhase);
            }
        } else {
            patterns.forEach(new Consumer<Container>(){

                @Override
                public void accept(Container node) {
                    String propDefVal;
                    Field field = node.findField();
                    ConfigItem configItem = field.getAnnotation(ConfigItem.class);
                    ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
                    Class<?> valueClass = field.getType();
                    EffectiveConfigTypeAndValues effectiveConfigTypeAndValues = ConfigDescriptionBuildStep.this.getTypeName(field);
                    String defaultDefault = valueClass == Boolean.TYPE ? "false" : (valueClass.isPrimitive() && valueClass != Character.TYPE ? "0" : null);
                    String defVal = defaultDefault;
                    if (configItem != null) {
                        String itemDefVal = configItem.defaultValue();
                        if (!itemDefVal.equals("<<no default>>")) {
                            defVal = itemDefVal;
                        }
                    } else if (configProperty != null && !(propDefVal = configProperty.defaultValue()).equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                        defVal = propDefVal;
                    }
                    String javadocKey = field.getDeclaringClass().getName().replace('$', '.') + "." + field.getName();
                    ret.add(new ConfigDescriptionBuildItem(name, defVal, javadoc.getProperty(javadocKey), effectiveConfigTypeAndValues.getTypeName(), effectiveConfigTypeAndValues.getAllowedValues(), configPhase));
                }
            });
        }
    }

    private void processMappings(List<ConfigMappings.ConfigClass> mappings, List<ConfigDescriptionBuildItem> descriptionBuildItems, Properties javaDocProperties, ConfigPhase configPhase) {
        for (ConfigMappings.ConfigClass mapping : mappings) {
            Map properties = ConfigMappings.getProperties((ConfigMappings.ConfigClass)mapping);
            for (Map.Entry entry : properties.entrySet()) {
                ConfigMappingInterface.LeafProperty leafProperty;
                String propertyName = (String)entry.getKey();
                ConfigMappingInterface.Property property = (ConfigMappingInterface.Property)entry.getValue();
                Method method = property.getMethod();
                String defaultValue = null;
                if (property instanceof ConfigMappingInterface.PrimitiveProperty) {
                    ConfigMappingInterface.PrimitiveProperty primitiveProperty = (ConfigMappingInterface.PrimitiveProperty)property;
                    if (primitiveProperty.hasDefaultValue()) {
                        defaultValue = primitiveProperty.getDefaultValue();
                    } else if (primitiveProperty.getPrimitiveType() == Boolean.TYPE) {
                        defaultValue = "false";
                    } else if (primitiveProperty.getPrimitiveType() != Character.TYPE) {
                        defaultValue = "0";
                    }
                } else if (property instanceof ConfigMappingInterface.LeafProperty && (leafProperty = (ConfigMappingInterface.LeafProperty)property).hasDefaultValue()) {
                    defaultValue = leafProperty.getDefaultValue();
                }
                String javadocKey = method.getDeclaringClass().getName().replace('$', '.') + "." + method.getName();
                descriptionBuildItems.add(new ConfigDescriptionBuildItem(propertyName, defaultValue, javaDocProperties.getProperty(javadocKey), null, null, configPhase));
            }
        }
    }

    private EffectiveConfigTypeAndValues getTypeName(Field field) {
        Class<?> valueClass = field.getType();
        return this.getTypeName(field, valueClass);
    }

    private EffectiveConfigTypeAndValues getTypeName(Field field, Class<?> valueClass) {
        EffectiveConfigTypeAndValues typeAndValues = new EffectiveConfigTypeAndValues();
        String name = valueClass.getName();
        if (valueClass.equals(Optional.class) || valueClass.equals(List.class) || valueClass.equals(Set.class)) {
            if (field != null) {
                Type genericType = field.getGenericType();
                name = genericType.getTypeName();
            }
            if (name.contains("<") && name.contains(">")) {
                name = name.substring(name.lastIndexOf("<") + 1, name.indexOf(">"));
            }
            try {
                Class<?> c = Class.forName(name);
                return this.getTypeName(null, c);
            }
            catch (ClassNotFoundException c) {
                // empty catch block
            }
        }
        if (valueClass.equals(OptionalInt.class)) {
            name = Integer.class.getName();
        } else if (valueClass.equals(OptionalDouble.class)) {
            name = Double.class.getName();
        } else if (valueClass.equals(OptionalLong.class)) {
            name = Long.class.getName();
        }
        if (Enum.class.isAssignableFrom(valueClass)) {
            ?[] values;
            name = Enum.class.getName();
            for (Object v : values = valueClass.getEnumConstants()) {
                Enum casted = (Enum)valueClass.cast(v);
                typeAndValues.addAllowedValue(casted.name());
            }
        }
        if (valueClass.isAssignableFrom(Level.class)) {
            typeAndValues.addAllowedValue(Level.ALL.getName());
            typeAndValues.addAllowedValue(Level.CONFIG.getName());
            typeAndValues.addAllowedValue(Level.FINE.getName());
            typeAndValues.addAllowedValue(Level.FINER.getName());
            typeAndValues.addAllowedValue(Level.FINEST.getName());
            typeAndValues.addAllowedValue(Level.INFO.getName());
            typeAndValues.addAllowedValue(Level.OFF.getName());
            typeAndValues.addAllowedValue(Level.SEVERE.getName());
            typeAndValues.addAllowedValue(Level.WARNING.getName());
        }
        if (name.equals("int")) {
            name = Integer.class.getName();
        } else if (name.equals("boolean")) {
            name = Boolean.class.getName();
        } else if (name.equals("float")) {
            name = Float.class.getName();
        } else if (name.equals("double")) {
            name = Double.class.getName();
        } else if (name.equals("long")) {
            name = Long.class.getName();
        } else if (name.equals("byte")) {
            name = Byte.class.getName();
        } else if (name.equals("short")) {
            name = Short.class.getName();
        } else if (name.equals("char")) {
            name = Character.class.getName();
        }
        typeAndValues.setTypeName(name);
        return typeAndValues;
    }

    static class EffectiveConfigTypeAndValues {
        private String typeName;
        private List<String> allowedValues;

        public EffectiveConfigTypeAndValues() {
        }

        public EffectiveConfigTypeAndValues(String typeName) {
            this.typeName = typeName;
        }

        public EffectiveConfigTypeAndValues(String typeName, List<String> allowedValues) {
            this.typeName = typeName;
            this.allowedValues = allowedValues;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public List<String> getAllowedValues() {
            return this.allowedValues;
        }

        public void setAllowedValues(List<String> allowedValues) {
            this.allowedValues = allowedValues;
        }

        public void addAllowedValue(String v) {
            if (this.allowedValues == null) {
                this.allowedValues = new ArrayList<String>();
            }
            this.allowedValues.add(v);
        }
    }
}

