/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner.bootstrap;

import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesNetworkIdBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.RuntimeApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.runner.bootstrap.ForkJoinClassLoading;
import io.quarkus.runner.bootstrap.RunningQuarkusApplicationImpl;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class StartupActionImpl
implements StartupAction {
    private static final Logger log = Logger.getLogger(StartupActionImpl.class);
    private final CuratedApplication curatedApplication;
    private final QuarkusClassLoader runtimeClassLoader;
    private final String mainClassName;
    private final String applicationClassName;
    private final Map<String, String> devServicesProperties;
    private final String devServicesNetworkId;
    private final List<RuntimeApplicationShutdownBuildItem> runtimeApplicationShutdownBuildItems;
    private final List<Closeable> runtimeCloseTasks = new ArrayList<Closeable>();

    public StartupActionImpl(CuratedApplication curatedApplication, BuildResult buildResult) {
        QuarkusClassLoader runtimeClassLoader;
        this.curatedApplication = curatedApplication;
        this.mainClassName = ((MainClassBuildItem)buildResult.consume(MainClassBuildItem.class)).getClassName();
        this.applicationClassName = ((ApplicationClassNameBuildItem)buildResult.consume(ApplicationClassNameBuildItem.class)).getClassName();
        this.devServicesProperties = StartupActionImpl.extractDevServicesProperties(buildResult);
        this.devServicesNetworkId = StartupActionImpl.extractDevServicesNetworkId(buildResult);
        this.runtimeApplicationShutdownBuildItems = buildResult.consumeMulti(RuntimeApplicationShutdownBuildItem.class);
        Map<String, byte[]> transformedClasses = StartupActionImpl.extractTransformedClasses(buildResult);
        QuarkusClassLoader baseClassLoader = curatedApplication.getOrCreateBaseRuntimeClassLoader();
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>(StartupActionImpl.extractGeneratedResources(buildResult, true));
        if (curatedApplication.isFlatClassPath()) {
            resources.putAll(StartupActionImpl.extractGeneratedResources(buildResult, false));
            baseClassLoader.reset(resources, transformedClasses);
            runtimeClassLoader = baseClassLoader;
        } else {
            baseClassLoader.reset(StartupActionImpl.extractGeneratedResources(buildResult, false), transformedClasses);
            runtimeClassLoader = curatedApplication.createRuntimeClassLoader(resources, transformedClasses);
        }
        this.runtimeClassLoader = runtimeClassLoader;
        runtimeClassLoader.setStartupAction((StartupAction)this);
    }

    public RunningQuarkusApplication runMainClass(final String ... args) throws Exception {
        ForkJoinClassLoading.setForkJoinClassLoader((ClassLoader)this.runtimeClassLoader);
        ApplicationStateNotification.reset();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.runtimeClassLoader);
        String className = this.mainClassName;
        try {
            Class<?> appClass = Class.forName(className, true, (ClassLoader)this.runtimeClassLoader);
            final Method start = appClass.getMethod("main", String[].class);
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread.currentThread().setContextClassLoader((ClassLoader)StartupActionImpl.this.runtimeClassLoader);
                    try {
                        start.invoke(null, new Object[]{args == null ? new String[]{} : args});
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error running Quarkus", e);
                        if (ApplicationStateNotification.getState() == ApplicationStateNotification.State.INITIAL) {
                            ApplicationStateNotification.notifyStartupFailed((Throwable)e);
                        }
                    }
                    finally {
                        for (RuntimeApplicationShutdownBuildItem i : StartupActionImpl.this.runtimeApplicationShutdownBuildItems) {
                            try {
                                i.getCloseTask().run();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to run close task", t);
                            }
                        }
                        for (Closeable closeTask : StartupActionImpl.this.runtimeCloseTasks) {
                            try {
                                closeTask.close();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to run close task", t);
                            }
                        }
                    }
                }
            }, "Quarkus Main Thread");
            t.start();
            ApplicationStateNotification.waitForApplicationStart();
            RunningQuarkusApplicationImpl runningQuarkusApplicationImpl = new RunningQuarkusApplicationImpl(new Closeable(){

                @Override
                public void close() throws IOException {
                    if (Quarkus.isMainThread((Thread)Thread.currentThread())) {
                        final CountDownLatch latch = new CountDownLatch(1);
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                StartupActionImpl.this.doClose();
                                latch.countDown();
                            }
                        }).start();
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            throw new IOException(e);
                        }
                    } else {
                        StartupActionImpl.this.doClose();
                    }
                }
            }, this.runtimeClassLoader);
            return runningQuarkusApplicationImpl;
        }
        catch (Throwable t) {
            try {
                Class<?> configClass = Class.forName("io.quarkus.runtime.generated.Config", true, (ClassLoader)this.runtimeClassLoader);
                configClass.getDeclaredMethod(RunTimeConfigurationGenerator.C_CREATE_RUN_TIME_CONFIG.getName(), new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void addRuntimeCloseTask(Closeable closeTask) {
        this.runtimeCloseTasks.add(closeTask);
    }

    private void doClose() {
        try {
            this.runtimeClassLoader.loadClass(Quarkus.class.getName()).getMethod("blockingExit", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error((Object)"Failed to stop Quarkus", (Throwable)e);
        }
        finally {
            ForkJoinClassLoading.setForkJoinClassLoader(ClassLoader.getSystemClassLoader());
            if (this.curatedApplication.getQuarkusBootstrap().getMode() == QuarkusBootstrap.Mode.TEST) {
                this.curatedApplication.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runMainClassBlocking(String ... args) throws Exception {
        ForkJoinClassLoading.setForkJoinClassLoader((ClassLoader)this.runtimeClassLoader);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.runtimeClassLoader);
        String className = this.mainClassName;
        try {
            Method setAlreadyStartedCallback;
            Method setDefaultExitCodeHandler;
            AtomicInteger result;
            block22: {
                int n;
                result = new AtomicInteger();
                Class<?> lifecycleManager = Class.forName(ApplicationLifecycleManager.class.getName(), true, (ClassLoader)this.runtimeClassLoader);
                AtomicBoolean alreadyStarted = new AtomicBoolean();
                setDefaultExitCodeHandler = lifecycleManager.getDeclaredMethod("setDefaultExitCodeHandler", Consumer.class);
                setAlreadyStartedCallback = lifecycleManager.getDeclaredMethod("setAlreadyStartedCallback", Consumer.class);
                try {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = result::set;
                    setDefaultExitCodeHandler.invoke(null, objectArray);
                    Object[] objectArray2 = new Object[1];
                    objectArray2[0] = alreadyStarted::set;
                    setAlreadyStartedCallback.invoke(null, objectArray2);
                    Class<?> appClass = Class.forName(className, true, (ClassLoader)this.runtimeClassLoader);
                    Method start = appClass.getMethod("main", String[].class);
                    start.invoke(null, new Object[]{args == null ? new String[]{} : args});
                    CountDownLatch latch = new CountDownLatch(1);
                    new Thread(() -> {
                        try {
                            Class<?> q = Class.forName(Quarkus.class.getName(), true, (ClassLoader)this.runtimeClassLoader);
                            q.getMethod("blockingExit", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            latch.countDown();
                        }
                    }).start();
                    latch.await();
                    if (!alreadyStarted.get()) break block22;
                    n = 0;
                }
                catch (Throwable throwable) {
                    setDefaultExitCodeHandler.invoke(null, new Object[]{null});
                    setAlreadyStartedCallback.invoke(null, new Object[]{null});
                    throw throwable;
                }
                setDefaultExitCodeHandler.invoke(null, new Object[]{null});
                setAlreadyStartedCallback.invoke(null, new Object[]{null});
                return n;
            }
            int n = result.get();
            setDefaultExitCodeHandler.invoke(null, new Object[]{null});
            setAlreadyStartedCallback.invoke(null, new Object[]{null});
            return n;
        }
        finally {
            for (Closeable closeTask : this.runtimeCloseTasks) {
                try {
                    closeTask.close();
                }
                catch (Throwable t) {
                    log.error((Object)"Failed to run close task", t);
                }
            }
            this.runtimeClassLoader.close();
            Thread.currentThread().setContextClassLoader(old);
            for (RuntimeApplicationShutdownBuildItem i : this.runtimeApplicationShutdownBuildItems) {
                try {
                    i.getCloseTask().run();
                }
                catch (Throwable t) {
                    log.error((Object)"Failed to run close task", t);
                }
            }
        }
    }

    public void overrideConfig(Map<String, String> config) {
        RuntimeOverrideConfigSource.setConfig((ClassLoader)this.runtimeClassLoader, config);
    }

    public RunningQuarkusApplication run(String ... args) throws Exception {
        ForkJoinClassLoading.setForkJoinClassLoader((ClassLoader)this.runtimeClassLoader);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> appClass;
            Thread.currentThread().setContextClassLoader((ClassLoader)this.runtimeClassLoader);
            String className = this.applicationClassName;
            try {
                appClass = Class.forName(className, true, (ClassLoader)this.runtimeClassLoader);
            }
            catch (Throwable t) {
                try {
                    Class<?> configClass = Class.forName("io.quarkus.runtime.generated.Config", true, (ClassLoader)this.runtimeClassLoader);
                    configClass.getDeclaredMethod(RunTimeConfigurationGenerator.C_CREATE_RUN_TIME_CONFIG.getName(), new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
            Method start = appClass.getMethod("start", String[].class);
            Object application = appClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            start.invoke(application, new Object[]{args});
            final Closeable closeTask = (Closeable)application;
            RunningQuarkusApplicationImpl runningQuarkusApplicationImpl = new RunningQuarkusApplicationImpl(new Closeable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        ClassLoader original = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader((ClassLoader)StartupActionImpl.this.runtimeClassLoader);
                            closeTask.close();
                            for (Closeable closeTask2 : StartupActionImpl.this.runtimeCloseTasks) {
                                try {
                                    closeTask2.close();
                                }
                                catch (Throwable t) {
                                    log.error((Object)"Failed to run close task", t);
                                }
                            }
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(original);
                            StartupActionImpl.this.runtimeClassLoader.close();
                        }
                    }
                    finally {
                        ForkJoinClassLoading.setForkJoinClassLoader(ClassLoader.getSystemClassLoader());
                        for (RuntimeApplicationShutdownBuildItem i : StartupActionImpl.this.runtimeApplicationShutdownBuildItems) {
                            try {
                                i.getCloseTask().run();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to run close task", t);
                            }
                        }
                        if (!StartupActionImpl.this.curatedApplication.isEligibleForReuse() && StartupActionImpl.this.curatedApplication.getQuarkusBootstrap().getMode() == QuarkusBootstrap.Mode.TEST && !StartupActionImpl.this.curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication()) {
                            StartupActionImpl.this.curatedApplication.close();
                        }
                    }
                }
            }, this.runtimeClassLoader);
            return runningQuarkusApplicationImpl;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new RuntimeException("Failed to start Quarkus", e.getCause());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public QuarkusClassLoader getClassLoader() {
        return this.runtimeClassLoader;
    }

    public Map<String, String> getDevServicesProperties() {
        return this.devServicesProperties;
    }

    public String getDevServicesNetworkId() {
        return this.devServicesNetworkId;
    }

    private static Map<String, String> extractDevServicesProperties(BuildResult buildResult) {
        DevServicesLauncherConfigResultBuildItem result = (DevServicesLauncherConfigResultBuildItem)buildResult.consumeOptional(DevServicesLauncherConfigResultBuildItem.class);
        if (result == null) {
            return Map.of();
        }
        return new HashMap<String, String>(result.getConfig());
    }

    private static String extractDevServicesNetworkId(BuildResult buildResult) {
        DevServicesNetworkIdBuildItem networkId = (DevServicesNetworkIdBuildItem)buildResult.consumeOptional(DevServicesNetworkIdBuildItem.class);
        if (networkId == null || networkId.getNetworkId() == null) {
            return null;
        }
        return networkId.getNetworkId();
    }

    private static Map<String, byte[]> extractTransformedClasses(BuildResult buildResult) {
        HashMap<String, byte[]> ret = new HashMap<String, byte[]>();
        TransformedClassesBuildItem transformers = (TransformedClassesBuildItem)buildResult.consume(TransformedClassesBuildItem.class);
        for (Set<TransformedClassesBuildItem.TransformedClass> i : transformers.getTransformedClassesByJar().values()) {
            for (TransformedClassesBuildItem.TransformedClass clazz : i) {
                if (clazz.getData() == null) continue;
                ret.put(clazz.getFileName(), clazz.getData());
            }
        }
        return ret;
    }

    private static Map<String, byte[]> extractGeneratedResources(BuildResult buildResult, boolean applicationClasses) {
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        for (MultiBuildItem i : buildResult.consumeMulti(GeneratedClassBuildItem.class)) {
            String debugSourcesDir;
            if (i.isApplicationClass() != applicationClasses) continue;
            data.put(ClassLoaderHelper.fromClassNameToResourceName((String)i.getName()), i.getClassData());
            String debugClassesDir = BootstrapDebug.debugClassesDir();
            if (debugClassesDir != null) {
                try {
                    File debugPath = new File(debugClassesDir);
                    if (!debugPath.exists()) {
                        debugPath.mkdir();
                    }
                    File classFile = new File(debugPath, i.getName() + ".class");
                    classFile.getParentFile().mkdirs();
                    try (FileOutputStream classWriter = new FileOutputStream(classFile);){
                        classWriter.write(i.getClassData());
                    }
                    log.infof("Wrote %s", (Object)classFile.getAbsolutePath());
                }
                catch (Exception t) {
                    log.errorf((Throwable)t, "Failed to write debug class files %s", (Object)i.getName());
                }
            }
            if ((debugSourcesDir = BootstrapDebug.debugSourcesDir()) == null) continue;
            try {
                if (i.getSource() != null) {
                    File debugPath = new File(debugSourcesDir);
                    if (!debugPath.exists()) {
                        debugPath.mkdir();
                    }
                    File sourceFile = new File(debugPath, i.getName() + ".zig");
                    sourceFile.getParentFile().mkdirs();
                    Files.write(sourceFile.toPath(), i.getSource().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                    log.infof("Wrote source %s", (Object)sourceFile.getAbsolutePath());
                    continue;
                }
                log.infof("Source not available: %s", (Object)i.getName());
            }
            catch (Exception t) {
                log.errorf((Throwable)t, "Failed to write debug source file %s", (Object)i.getName());
            }
        }
        if (applicationClasses) {
            for (MultiBuildItem i : buildResult.consumeMulti(GeneratedResourceBuildItem.class)) {
                if (i.isExcludeFromDevCL()) continue;
                data.put(i.getName(), i.getData());
            }
        }
        return data;
    }
}

