/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.MainBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.StartupContext;
import io.quarkus.runtime.StartupTask;
import io.quarkus.runtime.configuration.ConfigurationException;

public class RuntimeConfigSetupBuildStep {
    private static final String RUNTIME_CONFIG_STARTUP_TASK_CLASS_NAME = "io.quarkus.deployment.steps.RuntimeConfigSetup";

    @BuildStep
    @Produce(value=RuntimeConfigSetupCompleteBuildItem.class)
    void setupRuntimeConfig(BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<MainBytecodeRecorderBuildItem> mainBytecodeRecorder) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        try (ClassCreator clazz = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(RUNTIME_CONFIG_STARTUP_TASK_CLASS_NAME).interfaces(new Class[]{StartupTask.class}).build();
             MethodCreator method = clazz.getMethodCreator("deploy", Void.TYPE, new Class[]{StartupContext.class});){
            TryBlock tryBlock = method.tryBlock();
            tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(StartupContext.class, (String)"setCurrentBuildStepName", Void.TYPE, (Class[])new Class[]{String.class}), method.getMethodParam(0), new ResultHandle[]{method.load("RuntimeConfigSetupBuildStep.setupRuntimeConfig")});
            tryBlock.invokeStaticMethod(RunTimeConfigurationGenerator.C_CREATE_RUN_TIME_CONFIG, new ResultHandle[0]);
            tryBlock.returnValue(null);
            CatchBlockCreator cb = tryBlock.addCatch(RuntimeException.class);
            cb.throwException(ConfigurationException.class, "Failed to read configuration properties", cb.getCaughtException());
        }
        mainBytecodeRecorder.produce(new MainBytecodeRecorderBuildItem(RUNTIME_CONFIG_STARTUP_TASK_CLASS_NAME));
    }
}

