/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cyclonedx.generator;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import io.quarkus.bootstrap.app.SbomResult;
import io.quarkus.bootstrap.resolver.maven.EffectiveModelResolver;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathTree;
import io.quarkus.sbom.ApplicationComponent;
import io.quarkus.sbom.ApplicationManifest;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.cyclonedx.Version;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.generators.BomGeneratorFactory;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.Evidence;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Pedigree;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.Tool;
import org.cyclonedx.model.component.evidence.Occurrence;
import org.cyclonedx.model.metadata.ToolInformation;
import org.cyclonedx.util.BomUtils;
import org.cyclonedx.util.LicenseResolver;
import org.jboss.logging.Logger;

public class CycloneDxSbomGenerator {
    private static final Logger log = Logger.getLogger(CycloneDxSbomGenerator.class);
    private static final String QUARKUS_COMPONENT_SCOPE = "quarkus:component:scope";
    private static final String QUARKUS_COMPONENT_LOCATION = "quarkus:component:location";
    private static final Comparator<ArtifactCoords> ARTIFACT_COORDS_COMPARATOR = (c1, c2) -> {
        int i = c1.getGroupId().compareTo(c2.getGroupId());
        if (i != 0) {
            return i;
        }
        i = c1.getArtifactId().compareTo(c2.getArtifactId());
        if (i != 0) {
            return i;
        }
        i = c1.getVersion().compareTo(c2.getVersion());
        if (i != 0) {
            return i;
        }
        i = c1.getClassifier().compareTo(c2.getClassifier());
        if (i != 0) {
            return i;
        }
        return c1.getType().compareTo(c2.getType());
    };
    private static final String CLASSIFIER_CYCLONEDX = "cyclonedx";
    private static final String FORMAT_ALL = "all";
    private static final String FORMAT_JSON = "json";
    private static final String FORMAT_XML = "xml";
    private static final String DEFAULT_FORMAT = "json";
    private static final List<String> SUPPORTED_FORMATS = List.of("json", "xml");
    private boolean generated;
    private ApplicationManifest manifest;
    private Path outputDir;
    private Path outputFile;
    private String schemaVersion;
    private String format;
    private EffectiveModelResolver modelResolver;
    private boolean includeLicenseText;
    private Version effectiveSchemaVersion;

    public static CycloneDxSbomGenerator newInstance() {
        return new CycloneDxSbomGenerator();
    }

    private CycloneDxSbomGenerator() {
    }

    public CycloneDxSbomGenerator setManifest(ApplicationManifest manifest) {
        this.ensureNotGenerated();
        this.manifest = manifest;
        return this;
    }

    public CycloneDxSbomGenerator setOutputDirectory(Path outputDir) {
        this.ensureNotGenerated();
        this.outputDir = outputDir;
        return this;
    }

    public CycloneDxSbomGenerator setOutputFile(Path outputFile) {
        this.ensureNotGenerated();
        this.outputFile = outputFile;
        return this;
    }

    public CycloneDxSbomGenerator setFormat(String format) {
        this.ensureNotGenerated();
        this.format = format;
        return this;
    }

    public CycloneDxSbomGenerator setSchemaVersion(String schemaVersion) {
        this.ensureNotGenerated();
        this.schemaVersion = schemaVersion;
        return this;
    }

    public CycloneDxSbomGenerator setEffectiveModelResolver(EffectiveModelResolver modelResolver) {
        this.ensureNotGenerated();
        this.modelResolver = modelResolver;
        return this;
    }

    public CycloneDxSbomGenerator setIncludeLicenseText(boolean includeLicenseText) {
        this.ensureNotGenerated();
        this.includeLicenseText = includeLicenseText;
        return this;
    }

    public List<SbomResult> generate() {
        this.ensureNotGenerated();
        Objects.requireNonNull(this.manifest, "Manifest is null");
        if (this.outputFile == null && this.outputDir == null) {
            throw new IllegalArgumentException("Either outputDir or outputFile must be provided");
        }
        this.generated = true;
        Bom bom = new Bom();
        bom.setMetadata(new Metadata());
        this.addToolInfo(bom);
        this.addApplicationComponent(bom, this.manifest.getMainComponent());
        for (ApplicationComponent c : this.manifest.getComponents()) {
            this.addComponent(bom, c);
        }
        if (FORMAT_ALL.equalsIgnoreCase(this.format)) {
            if (this.outputFile != null) {
                throw new IllegalArgumentException("Can't use output file " + String.valueOf(this.outputFile) + " with format 'all', since it implies generating multiple files");
            }
            ArrayList<SbomResult> result = new ArrayList<SbomResult>(SUPPORTED_FORMATS.size());
            for (String format : SUPPORTED_FORMATS) {
                result.add(this.persistSbom(bom, this.getOutputFile(format), format));
            }
            return result;
        }
        Path outputFile = this.getOutputFile(this.format == null ? "json" : this.format);
        return List.of(this.persistSbom(bom, outputFile, this.getFormat(outputFile)));
    }

    private void addComponent(Bom bom, ApplicationComponent component) {
        Component c = this.getComponent(component);
        bom.addComponent(c);
        CycloneDxSbomGenerator.recordDependencies(bom, component, c);
    }

    private static void recordDependencies(Bom bom, ApplicationComponent component, Component c) {
        if (!component.getDependencies().isEmpty()) {
            Dependency d = new Dependency(c.getBomRef());
            for (ArtifactCoords depCoords : CycloneDxSbomGenerator.sortAlphabetically(component.getDependencies())) {
                d.addDependency(new Dependency(CycloneDxSbomGenerator.getPackageURL(depCoords).toString()));
            }
            bom.addDependency(d);
        }
    }

    private void addApplicationComponent(Bom bom, ApplicationComponent component) {
        Component c = this.getComponent(component);
        c.setType(Component.Type.APPLICATION);
        bom.getMetadata().setComponent(c);
        bom.addComponent(c);
        CycloneDxSbomGenerator.recordDependencies(bom, component, c);
    }

    private Component getComponent(ApplicationComponent component) {
        Component c = new Component();
        ResolvedDependency dep = component.getResolvedDependency();
        if (dep != null) {
            this.initMavenComponent((ArtifactCoords)dep, c);
        } else if (component.getDistributionPath() != null) {
            c.setBomRef(component.getDistributionPath());
            c.setType(Component.Type.FILE);
            c.setName(component.getPath().getFileName().toString());
        } else if (component.getPath() != null) {
            String fileName = component.getPath().getFileName().toString();
            c.setName(fileName);
            c.setBomRef(fileName);
            c.setType(Component.Type.FILE);
        } else {
            throw new RuntimeException("Component is not associated with any file system path");
        }
        ArrayList<Property> props = new ArrayList<Property>(2);
        String quarkusScope = component.getScope();
        if (quarkusScope == null) {
            quarkusScope = dep == null || dep.isRuntimeCp() ? "runtime" : "development";
        }
        CycloneDxSbomGenerator.addProperty(props, QUARKUS_COMPONENT_SCOPE, quarkusScope);
        if (component.getDistributionPath() != null) {
            if (this.getSchemaVersion().getVersion() >= 1.5) {
                Occurrence occurence = new Occurrence();
                occurence.setLocation(component.getDistributionPath());
                Evidence evidence = new Evidence();
                evidence.setOccurrences(List.of(occurence));
                c.setEvidence(evidence);
            } else {
                CycloneDxSbomGenerator.addProperty(props, QUARKUS_COMPONENT_LOCATION, component.getDistributionPath());
            }
        }
        c.setProperties(props);
        if (component.getPedigree() != null) {
            Pedigree pedigree = new Pedigree();
            pedigree.setNotes(component.getPedigree());
            c.setPedigree(pedigree);
        }
        if (component.getPath() != null) {
            try {
                c.setHashes(BomUtils.calculateHashes((File)component.getPath().toFile(), (Version)this.getSchemaVersion()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return c;
    }

    private void initMavenComponent(ArtifactCoords coords, Component c) {
        this.addPomMetadata(coords, c);
        c.setGroup(coords.getGroupId());
        c.setName(coords.getArtifactId());
        c.setVersion(coords.getVersion());
        PackageURL purl = CycloneDxSbomGenerator.getPackageURL(coords);
        c.setPurl(purl);
        c.setBomRef(purl.toString());
        c.setType(Component.Type.LIBRARY);
    }

    private void addPomMetadata(ArtifactCoords dep, Component component) {
        Model model;
        Model model2 = model = this.modelResolver == null ? null : this.modelResolver.resolveEffectiveModel(dep);
        if (model != null) {
            this.extractComponentMetadata(model, component);
        }
    }

    private void extractComponentMetadata(Model model, Component component) {
        if (component.getPublisher() == null && model.getOrganization() != null) {
            component.setPublisher(model.getOrganization().getName());
        }
        if (component.getDescription() == null) {
            component.setDescription(model.getDescription());
        }
        Version schemaVersion = this.getSchemaVersion();
        if ((component.getLicenseChoice() == null || component.getLicenseChoice().getLicenses() == null || component.getLicenseChoice().getLicenses().isEmpty()) && model.getLicenses() != null) {
            component.setLicenseChoice(this.resolveMavenLicenses(model.getLicenses(), schemaVersion, this.includeLicenseText));
        }
        if (Version.VERSION_10 != schemaVersion) {
            CycloneDxSbomGenerator.addExternalReference(ExternalReference.Type.WEBSITE, model.getUrl(), component);
            if (model.getCiManagement() != null) {
                CycloneDxSbomGenerator.addExternalReference(ExternalReference.Type.BUILD_SYSTEM, model.getCiManagement().getUrl(), component);
            }
            if (model.getDistributionManagement() != null) {
                CycloneDxSbomGenerator.addExternalReference(ExternalReference.Type.DISTRIBUTION, model.getDistributionManagement().getDownloadUrl(), component);
                if (model.getDistributionManagement().getRepository() != null) {
                    ExternalReference.Type type = schemaVersion.getVersion() < 1.5 ? ExternalReference.Type.DISTRIBUTION : ExternalReference.Type.DISTRIBUTION_INTAKE;
                    CycloneDxSbomGenerator.addExternalReference(type, model.getDistributionManagement().getRepository().getUrl(), component);
                }
            }
            if (model.getIssueManagement() != null) {
                CycloneDxSbomGenerator.addExternalReference(ExternalReference.Type.ISSUE_TRACKER, model.getIssueManagement().getUrl(), component);
            }
            if (model.getMailingLists() != null && !model.getMailingLists().isEmpty()) {
                for (MailingList list : model.getMailingLists()) {
                    String url = list.getArchive();
                    if (url == null) {
                        url = list.getSubscribe();
                    }
                    CycloneDxSbomGenerator.addExternalReference(ExternalReference.Type.MAILING_LIST, url, component);
                }
            }
            if (model.getScm() != null) {
                CycloneDxSbomGenerator.addExternalReference(ExternalReference.Type.VCS, model.getScm().getUrl(), component);
            }
        }
    }

    private LicenseChoice resolveMavenLicenses(List<License> projectLicenses, Version schemaVersion, boolean includeLicenseText) {
        LicenseChoice licenseChoice = new LicenseChoice();
        for (License artifactLicense : projectLicenses) {
            boolean resolved = false;
            if (artifactLicense.getName() != null) {
                LicenseChoice resolvedByName = LicenseResolver.resolve((String)artifactLicense.getName(), (boolean)includeLicenseText);
                resolved = this.resolveLicenseInfo(licenseChoice, resolvedByName, schemaVersion);
            }
            if (artifactLicense.getUrl() != null && !resolved) {
                LicenseChoice resolvedByUrl = LicenseResolver.resolve((String)artifactLicense.getUrl(), (boolean)includeLicenseText);
                resolved = this.resolveLicenseInfo(licenseChoice, resolvedByUrl, schemaVersion);
            }
            if (artifactLicense.getName() == null || resolved) continue;
            org.cyclonedx.model.License license = new org.cyclonedx.model.License();
            license.setName(artifactLicense.getName().trim());
            if (StringUtils.isNotBlank((CharSequence)artifactLicense.getUrl())) {
                try {
                    URI uri = new URI(artifactLicense.getUrl().trim());
                    license.setUrl(uri.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            licenseChoice.addLicense(license);
        }
        return licenseChoice;
    }

    private boolean resolveLicenseInfo(LicenseChoice licenseChoice, LicenseChoice licenseChoiceToResolve, Version schemaVersion) {
        if (licenseChoiceToResolve != null) {
            if (licenseChoiceToResolve.getLicenses() != null && !licenseChoiceToResolve.getLicenses().isEmpty()) {
                licenseChoice.addLicense((org.cyclonedx.model.License)licenseChoiceToResolve.getLicenses().get(0));
                return true;
            }
            if (licenseChoiceToResolve.getExpression() != null && Version.VERSION_10 != schemaVersion) {
                licenseChoice.setExpression(licenseChoiceToResolve.getExpression());
                return true;
            }
        }
        return false;
    }

    private static boolean doesComponentHaveExternalReference(Component component, ExternalReference.Type type) {
        if (component.getExternalReferences() != null && !component.getExternalReferences().isEmpty()) {
            for (ExternalReference ref : component.getExternalReferences()) {
                if (type != ref.getType()) continue;
                return true;
            }
        }
        return false;
    }

    private static void addExternalReference(ExternalReference.Type referenceType, String url, Component component) {
        if (url == null) {
            return;
        }
        try {
            URI uri = new URI(url.trim());
            ExternalReference ref = new ExternalReference();
            ref.setType(referenceType);
            ref.setUrl(uri.toString());
            component.addExternalReference(ref);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private static PackageURL getPackageURL(ArtifactCoords dep) {
        PackageURL purl;
        TreeMap<String, String> qualifiers = new TreeMap<String, String>();
        qualifiers.put("type", dep.getType());
        if (!dep.getClassifier().isEmpty()) {
            qualifiers.put("classifier", dep.getClassifier());
        }
        try {
            purl = new PackageURL("maven", dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), qualifiers, null);
        }
        catch (MalformedPackageURLException e) {
            throw new RuntimeException("Failed to generate Purl for " + dep.toCompactCoords(), e);
        }
        return purl;
    }

    static void addProperty(List<Property> props, String name, String value) {
        Property prop = new Property();
        prop.setName(name);
        prop.setValue(value);
        props.add(prop);
    }

    private static List<ArtifactCoords> sortAlphabetically(Collection<ArtifactCoords> col) {
        ArrayList<ArtifactCoords> list = new ArrayList<ArtifactCoords>(col);
        list.sort(ARTIFACT_COORDS_COMPARATOR);
        return list;
    }

    private SbomResult persistSbom(Bom bom, Path sbomFile, String format) {
        String sbomContent;
        Version specVersion = this.getSchemaVersion();
        if (format.equalsIgnoreCase("json")) {
            try {
                sbomContent = BomGeneratorFactory.createJson((Version)specVersion, (Bom)bom).toJsonString();
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to generate an SBOM in JSON format", e);
            }
        } else if (format.equalsIgnoreCase(FORMAT_XML)) {
            try {
                sbomContent = BomGeneratorFactory.createXml((Version)specVersion, (Bom)bom).toXmlString();
            }
            catch (GeneratorException e) {
                throw new RuntimeException("Failed to generate an SBOM in XML format", e);
            }
        } else {
            throw new RuntimeException("Unsupported SBOM artifact type " + format + ", supported types are json and xml");
        }
        Path outputDir = sbomFile.getParent();
        if (outputDir != null) {
            try {
                Files.createDirectories(outputDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SBOM Content:" + System.lineSeparator() + sbomContent));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(sbomFile, new OpenOption[0]);){
            writer.write(sbomContent);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write to " + String.valueOf(sbomFile), e);
        }
        return new SbomResult(sbomFile, "CycloneDX", bom.getSpecVersion(), format, CLASSIFIER_CYCLONEDX, this.manifest.getRunnerPath());
    }

    private Path getOutputFile(String defaultFormat) {
        if (this.outputFile == null) {
            String fileName = this.toSbomFileName(this.manifest.getRunnerPath().getFileName().toString(), defaultFormat);
            return this.outputDir == null ? Path.of(fileName, new String[0]) : this.outputDir.resolve(fileName);
        }
        return this.outputFile;
    }

    private String toSbomFileName(String deliverableName, String defaultFormat) {
        return CycloneDxSbomGenerator.stripExtension(deliverableName) + "-cyclonedx." + defaultFormat;
    }

    private static String stripExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot <= 0) {
            return fileName;
        }
        int lastDash = fileName.lastIndexOf(45);
        return lastDot < lastDash ? fileName : fileName.substring(0, lastDot);
    }

    private String getFormat(Path outputFile) {
        if (this.format == null || FORMAT_ALL.equalsIgnoreCase(this.format)) {
            String name = outputFile.getFileName().toString();
            int lastDot = name.lastIndexOf(46);
            if (lastDot < 0 || lastDot == name.length() - 1) {
                throw new IllegalArgumentException("Failed to determine file extension of " + String.valueOf(outputFile));
            }
            return name.substring(lastDot + 1);
        }
        return this.format;
    }

    private Version getSchemaVersion() {
        if (this.effectiveSchemaVersion == null) {
            if (this.schemaVersion == null) {
                this.effectiveSchemaVersion = Collections.max(List.of(Version.values()));
            } else {
                for (Version v : Version.values()) {
                    if (!this.schemaVersion.equals(v.getVersionString())) continue;
                    this.effectiveSchemaVersion = v;
                    break;
                }
                if (this.effectiveSchemaVersion == null) {
                    Version[] versions = Version.values();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Requested CycloneDX schema version ").append(this.schemaVersion).append(" does not appear in the list of supported versions: ").append(versions[0].getVersionString());
                    for (int i = 1; i < versions.length; ++i) {
                        sb.append(", ").append(versions[i].getVersionString());
                    }
                    throw new IllegalArgumentException(sb.toString());
                }
            }
        }
        return this.effectiveSchemaVersion;
    }

    private void addToolInfo(Bom bom) {
        Path toolLocation = this.getToolLocation();
        if (toolLocation == null) {
            return;
        }
        List hashes = null;
        if (!Files.isDirectory(toolLocation, new LinkOption[0])) {
            try {
                hashes = BomUtils.calculateHashes((File)toolLocation.toFile(), (Version)this.getSchemaVersion());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to calculate hashes for the tool at " + String.valueOf(toolLocation), e);
            }
        } else {
            log.warn((Object)("skipping tool hashing because " + String.valueOf(toolLocation) + " appears to be a directory"));
        }
        if (this.getSchemaVersion().getVersion() >= 1.5) {
            ToolInformation toolInfo = new ToolInformation();
            Component toolComponent = new Component();
            toolComponent.setType(Component.Type.LIBRARY);
            ApplicationComponent appComponent = this.findApplicationComponent(toolLocation);
            if (appComponent != null && appComponent.getResolvedDependency() != null) {
                this.initMavenComponent((ArtifactCoords)appComponent.getResolvedDependency(), toolComponent);
            } else {
                ArtifactCoords coords = CycloneDxSbomGenerator.getMavenArtifact(toolLocation);
                if (coords != null) {
                    this.initMavenComponent(coords, toolComponent);
                } else {
                    toolComponent.setName(toolLocation.getFileName().toString());
                }
            }
            if (hashes != null) {
                toolComponent.setHashes(hashes);
            }
            toolInfo.setComponents(List.of(toolComponent));
            bom.getMetadata().setToolChoice(toolInfo);
        } else {
            Tool tool = new Tool();
            ApplicationComponent appComponent = this.findApplicationComponent(toolLocation);
            if (appComponent != null && appComponent.getResolvedDependency() != null) {
                tool.setVendor(appComponent.getResolvedDependency().getGroupId());
                tool.setName(appComponent.getResolvedDependency().getArtifactId());
                tool.setVersion(appComponent.getResolvedDependency().getVersion());
            } else {
                ArtifactCoords coords = CycloneDxSbomGenerator.getMavenArtifact(toolLocation);
                if (coords != null) {
                    tool.setVendor(coords.getGroupId());
                    tool.setName(coords.getArtifactId());
                    tool.setVersion(coords.getVersion());
                } else {
                    tool.setName(toolLocation.getFileName().toString());
                }
            }
            if (hashes != null) {
                tool.setHashes(hashes);
            }
            bom.getMetadata().setTools(List.of(tool));
        }
    }

    private ApplicationComponent findApplicationComponent(Path path) {
        for (ApplicationComponent c : this.manifest.getComponents()) {
            if (!c.getResolvedDependency().getResolvedPaths().contains(path)) continue;
            return c;
        }
        return null;
    }

    private static ArtifactCoords getMavenArtifact(Path toolLocation) {
        ArrayList toolArtifact = new ArrayList(1);
        PathTree.ofDirectoryOrArchive((Path)toolLocation).walkIfContains("META-INF/maven", visit -> {
            if (!Files.isDirectory(visit.getPath(), new LinkOption[0]) && visit.getPath().getFileName().toString().equals("pom.properties")) {
                try (BufferedReader reader = Files.newBufferedReader(visit.getPath());){
                    Properties props = new Properties();
                    props.load(reader);
                    String groupId = props.getProperty("groupId");
                    if (CycloneDxSbomGenerator.isBlanc(groupId)) {
                        return;
                    }
                    String artifactId = props.getProperty("artifactId");
                    if (CycloneDxSbomGenerator.isBlanc(artifactId)) {
                        return;
                    }
                    String version = props.getProperty("version");
                    if (CycloneDxSbomGenerator.isBlanc(version)) {
                        return;
                    }
                    toolArtifact.add(ArtifactCoords.jar((String)groupId, (String)artifactId, (String)version));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        if (toolArtifact.size() != 1) {
            return null;
        }
        return (ArtifactCoords)toolArtifact.get(0);
    }

    private static boolean isBlanc(String s) {
        return s == null || s.trim().isEmpty();
    }

    private Path getToolLocation() {
        CodeSource cs = this.getClass().getProtectionDomain().getCodeSource();
        if (cs == null) {
            log.warn((Object)"Failed to determine code source of the tool");
            return null;
        }
        URL url = cs.getLocation();
        if (url == null) {
            log.warn((Object)"Failed to determine code source URL of the tool");
            return null;
        }
        try {
            return Path.of(url.toURI());
        }
        catch (URISyntaxException e) {
            log.warn((Object)("Failed to translate " + String.valueOf(url) + " to a file system path"), (Throwable)e);
            return null;
        }
    }

    private void ensureNotGenerated() {
        if (this.generated) {
            throw new RuntimeException("This instance has already been used to generate an SBOM");
        }
    }
}

