/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.spi;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public final class DevServicesDatasourceResultBuildItem
extends SimpleBuildItem {
    final DbResult defaultDatasource;
    final Map<String, DbResult> namedDatasources;

    public DevServicesDatasourceResultBuildItem(DbResult defaultDatasource, Map<String, DbResult> namedDatasources) {
        this.defaultDatasource = defaultDatasource;
        this.namedDatasources = Collections.unmodifiableMap(namedDatasources);
    }

    public DbResult getDefaultDatasource() {
        return this.defaultDatasource;
    }

    public Map<String, DbResult> getNamedDatasources() {
        return this.namedDatasources;
    }

    public static DbResult resolve(Optional<DevServicesDatasourceResultBuildItem> devDbResultBuildItem, String dataSourceName) {
        if (devDbResultBuildItem.isPresent()) {
            if (dataSourceName.equals("<default>")) {
                return devDbResultBuildItem.get().defaultDatasource;
            }
            return devDbResultBuildItem.get().namedDatasources.get(dataSourceName);
        }
        return null;
    }

    public static class DbResult {
        final String dbType;
        final Map<String, String> configProperties;

        public DbResult(String dbType, Map<String, String> configProperties) {
            this.dbType = dbType;
            this.configProperties = Collections.unmodifiableMap(configProperties);
        }

        public String getDbType() {
            return this.dbType;
        }

        public Map<String, String> getConfigProperties() {
            return this.configProperties;
        }
    }
}

