/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.devservices;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceResultBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class DevServicesDatasourceProcessor {
    private static final Logger log = Logger.getLogger(DevServicesDatasourceProcessor.class);
    private static final int DOCKER_PS_ID_LENGTH = 12;
    static volatile List<DevServicesResultBuildItem.RunningDevService> databases;
    static volatile Map<String, Object> cachedProperties;
    static volatile boolean first;

    @BuildStep
    DevServicesDatasourceResultBuildItem launchDatabases(Capabilities capabilities, CurateOutcomeBuildItem curateOutcomeBuildItem, DockerStatusBuildItem dockerStatusBuildItem, List<DefaultDataSourceDbKindBuildItem> installedDrivers, List<DevServicesDatasourceProviderBuildItem> devDBProviders, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, LaunchModeBuildItem launchMode, List<DevServicesDatasourceConfigurationHandlerBuildItem> configurationHandlerBuildItems, BuildProducer<DevServicesResultBuildItem> devServicesResultBuildItemBuildProducer, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig globalDevServicesConfig) {
        if (databases != null) {
            boolean restartRequired = false;
            Map<String, Object> newDatasourceConfigs = DevServicesDatasourceProcessor.buildMapFromBuildConfig(dataSourcesBuildTimeConfig);
            if (!newDatasourceConfigs.equals(cachedProperties)) {
                restartRequired = true;
            }
            if (!restartRequired) {
                for (DevServicesResultBuildItem.RunningDevService runningDevService : databases) {
                    devServicesResultBuildItemBuildProducer.produce((BuildItem)runningDevService.toBuildItem());
                }
                return null;
            }
            for (Closeable closeable : databases) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop database", e);
                }
            }
            databases = null;
            cachedProperties = null;
        }
        HashMap<String, DevServicesDatasourceResultBuildItem.DbResult> results = new HashMap<String, DevServicesDatasourceResultBuildItem.DbResult>();
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        ArrayList<DevServicesResultBuildItem.RunningDevService> runningDevServices = new ArrayList<DevServicesResultBuildItem.RunningDevService>();
        Map<String, List<DevServicesDatasourceConfigurationHandlerBuildItem>> map = configurationHandlerBuildItems.stream().collect(Collectors.toMap(DevServicesDatasourceConfigurationHandlerBuildItem::getDbKind, Collections::singletonList, (configurationHandlerBuildItems1, configurationHandlerBuildItems2) -> {
            ArrayList ret = new ArrayList();
            ret.addAll(configurationHandlerBuildItems1);
            ret.addAll(configurationHandlerBuildItems2);
            return ret;
        }));
        Map<String, DevServicesDatasourceProvider> devDBProviderMap = devDBProviders.stream().collect(Collectors.toMap(DevServicesDatasourceProviderBuildItem::getDatabase, DevServicesDatasourceProviderBuildItem::getDevServicesProvider));
        for (Map.Entry entry : dataSourcesBuildTimeConfig.dataSources().entrySet()) {
            DevServicesResultBuildItem.RunningDevService devService = this.startDevDb((String)entry.getKey(), capabilities, curateOutcomeBuildItem, installedDrivers, dataSourcesBuildTimeConfig.hasNamedDataSources(), devDBProviderMap, (DataSourceBuildTimeConfig)entry.getValue(), map, propertiesMap, dockerStatusBuildItem, launchMode.getLaunchMode(), consoleInstalledBuildItem, loggingSetupBuildItem, globalDevServicesConfig);
            if (devService == null) continue;
            runningDevServices.add(devService);
            results.put((String)entry.getKey(), this.toDbResult(devService));
        }
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (databases != null) {
                        for (Closeable closeable : databases) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to stop database", t);
                            }
                        }
                    }
                    first = true;
                    databases = null;
                    cachedProperties = null;
                }
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        databases = runningDevServices;
        cachedProperties = DevServicesDatasourceProcessor.buildMapFromBuildConfig(dataSourcesBuildTimeConfig);
        for (DevServicesResultBuildItem.RunningDevService database : databases) {
            devServicesResultBuildItemBuildProducer.produce((BuildItem)database.toBuildItem());
        }
        return new DevServicesDatasourceResultBuildItem(results);
    }

    private static Map<String, Object> buildMapFromBuildConfig(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map.Entry datasource : dataSourcesBuildTimeConfig.dataSources().entrySet()) {
            String name = (String)datasource.getKey();
            DataSourceBuildTimeConfig config = (DataSourceBuildTimeConfig)datasource.getValue();
            res.put(name + ".db-kind", config.dbKind());
            res.put(name + ".db-version", config.dbVersion());
            res.put(name + ".devservices.command", config.devservices().command());
            res.put(name + ".devservices.container-env", config.devservices().containerEnv());
            res.put(name + ".devservices.container-properties.", config.devservices().containerProperties());
            res.put(name + ".devservices.db-name", config.devservices().dbName());
            res.put(name + ".devservices.image-name", config.devservices().imageName());
            res.put(name + ".devservices.init-script-path", config.devservices().initScriptPath());
            res.put(name + ".devservices.password", config.devservices().password());
            res.put(name + ".devservices.port", config.devservices().port());
            res.put(name + ".devservices.properties", config.devservices().properties());
            res.put(name + ".devservices.reuse", config.devservices().reuse());
            res.put(name + ".devservices.username", config.devservices().username());
            res.put(name + ".devservices.volumes", config.devservices().volumes());
            Optional username = ConfigUtils.getFirstOptionalValue((List)DataSourceUtil.dataSourcePropertyKeys((String)name, (String)"username"), String.class);
            res.put(name + ".username", username);
            Optional password = ConfigUtils.getFirstOptionalValue((List)DataSourceUtil.dataSourcePropertyKeys((String)name, (String)"password"), String.class);
            res.put(name + ".password", password);
        }
        return res;
    }

    private DevServicesResultBuildItem.RunningDevService startDevDb(String dbName, Capabilities capabilities, CurateOutcomeBuildItem curateOutcomeBuildItem, List<DefaultDataSourceDbKindBuildItem> installedDrivers, boolean hasNamedDatasources, Map<String, DevServicesDatasourceProvider> devDBProviders, DataSourceBuildTimeConfig dataSourceBuildTimeConfig, Map<String, List<DevServicesDatasourceConfigurationHandlerBuildItem>> configurationHandlerBuildItems, Map<String, String> propertiesMap, DockerStatusBuildItem dockerStatusBuildItem, LaunchMode launchMode, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig globalDevServicesConfig) {
        Object dataSourcePrettyName;
        Object object = dataSourcePrettyName = DataSourceUtil.isDefault((String)dbName) ? "default datasource" : "datasource " + dbName;
        if (!ConfigUtils.getFirstOptionalValue((List)DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)"active"), Boolean.class).orElse(true).booleanValue()) {
            log.debug((Object)("Not starting Dev Services for " + (String)dataSourcePrettyName + " as the datasource has been deactivated in the configuration"));
            return null;
        }
        if (!dataSourceBuildTimeConfig.devservices().enabled().orElse(true).booleanValue()) {
            log.debug((Object)("Not starting Dev Services for " + (String)dataSourcePrettyName + " as it has been disabled in the configuration"));
            return null;
        }
        Boolean enabled = dataSourceBuildTimeConfig.devservices().enabled().orElse(!hasNamedDatasources);
        Optional defaultDbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourceBuildTimeConfig.dbKind(), installedDrivers, (!DataSourceUtil.isDefault((String)dbName) || enabled != false ? 1 : 0) != 0, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        if (!defaultDbKind.isPresent()) {
            log.warn((Object)("Unable to determine a database type for " + (String)dataSourcePrettyName));
            return null;
        }
        DevServicesDatasourceProvider devDbProvider = devDBProviders.get(defaultDbKind.get());
        List<DevServicesDatasourceConfigurationHandlerBuildItem> configHandlers = configurationHandlerBuildItems.get(defaultDbKind.get());
        if (devDbProvider == null || configHandlers == null) {
            log.warn((Object)("Unable to start Dev Services for " + (String)dataSourcePrettyName + " as this datasource type (" + (String)defaultDbKind.get() + ") does not support Dev Services"));
            return null;
        }
        if (dataSourceBuildTimeConfig.devservices().enabled().isEmpty()) {
            for (DevServicesDatasourceConfigurationHandlerBuildItem i : configHandlers) {
                if (!i.getCheckConfiguredFunction().test(dbName)) continue;
                log.debug((Object)("Not starting Dev Services for " + (String)dataSourcePrettyName + " as it has explicit configuration"));
                return null;
            }
        }
        if (devDbProvider.isDockerRequired() && !dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            String message = "Please configure the datasource URL for " + (String)dataSourcePrettyName + " or ensure the Docker daemon is up and running.";
            if (launchMode == LaunchMode.TEST) {
                throw new IllegalStateException(message);
            }
            log.warn((Object)message);
            return null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode == LaunchMode.TEST ? "(test) " : "") + "Database for " + (String)dataSourcePrettyName + " (" + (String)defaultDbKind.get() + ") starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            DevServicesDatasourceContainerConfig containerConfig = new DevServicesDatasourceContainerConfig(dataSourceBuildTimeConfig.devservices().imageName(), dataSourceBuildTimeConfig.devservices().containerEnv(), dataSourceBuildTimeConfig.devservices().containerProperties(), dataSourceBuildTimeConfig.devservices().properties(), dataSourceBuildTimeConfig.devservices().port(), dataSourceBuildTimeConfig.devservices().command(), dataSourceBuildTimeConfig.devservices().dbName(), dataSourceBuildTimeConfig.devservices().username(), dataSourceBuildTimeConfig.devservices().password(), dataSourceBuildTimeConfig.devservices().initScriptPath(), dataSourceBuildTimeConfig.devservices().volumes(), dataSourceBuildTimeConfig.devservices().reuse(), dataSourceBuildTimeConfig.devservices().showLogs());
            DevServicesDatasourceProvider.RunningDevServicesDatasource datasource = devDbProvider.startDatabase(ConfigUtils.getFirstOptionalValue((List)DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)"username"), String.class), ConfigUtils.getFirstOptionalValue((List)DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)"password"), String.class), dbName, containerConfig, launchMode, globalDevServicesConfig.timeout);
            for (Object key : DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)"db-kind")) {
                propertiesMap.put((String)key, dataSourceBuildTimeConfig.dbKind().orElse(null));
            }
            String devServicesPrefix = "devservices.";
            if (dataSourceBuildTimeConfig.devservices().command().isPresent()) {
                this.setDataSourceProperties(propertiesMap, dbName, devServicesPrefix + "command", (String)dataSourceBuildTimeConfig.devservices().command().get());
            }
            if (dataSourceBuildTimeConfig.devservices().imageName().isPresent()) {
                this.setDataSourceProperties(propertiesMap, dbName, devServicesPrefix + "image-name", (String)dataSourceBuildTimeConfig.devservices().imageName().get());
            }
            if (dataSourceBuildTimeConfig.devservices().port().isPresent()) {
                this.setDataSourceProperties(propertiesMap, dbName, devServicesPrefix + "port", Integer.toString(dataSourceBuildTimeConfig.devservices().port().getAsInt()));
            }
            if (!dataSourceBuildTimeConfig.devservices().properties().isEmpty()) {
                for (Map.Entry entry : dataSourceBuildTimeConfig.devservices().properties().entrySet()) {
                    this.setDataSourceProperties(propertiesMap, dbName, devServicesPrefix + "properties." + (String)entry.getKey(), (String)entry.getValue());
                }
            }
            this.setDataSourceProperties(propertiesMap, dbName, devServicesPrefix + "reuse", String.valueOf(dataSourceBuildTimeConfig.devservices().reuse()));
            HashMap<String, String> devDebProperties = new HashMap<String, String>();
            for (DevServicesDatasourceConfigurationHandlerBuildItem devDbConfigurationHandlerBuildItem : configHandlers) {
                Map properties = (Map)devDbConfigurationHandlerBuildItem.getConfigProviderFunction().apply(dbName, datasource);
                for (Map.Entry entry : properties.entrySet()) {
                    if (((String)entry.getKey()).contains(".jdbc.") && ((String)entry.getKey()).endsWith(".url")) {
                        if (!capabilities.isCapabilityWithPrefixPresent("io.quarkus.agroal")) continue;
                        devDebProperties.put((String)entry.getKey(), (String)entry.getValue());
                        continue;
                    }
                    devDebProperties.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            this.setDataSourceProperties(devDebProperties, dbName, "db-kind", (String)defaultDbKind.get());
            if (datasource.getUsername() != null) {
                this.setDataSourceProperties(devDebProperties, dbName, "username", datasource.getUsername());
            }
            if (datasource.getPassword() != null) {
                this.setDataSourceProperties(devDebProperties, dbName, "password", datasource.getPassword());
            }
            compressor.close();
            if (datasource.getId() == null) {
                log.infof("Dev Services for %s (%s) started", dataSourcePrettyName, defaultDbKind.get());
            } else {
                log.infof("Dev Services for %s (%s) started - container ID is %s", dataSourcePrettyName, defaultDbKind.get(), (Object)(datasource.getId().length() > 12 ? datasource.getId().substring(0, 12) : datasource.getId()));
            }
            List list = DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)"devservices.");
            for (String name : ConfigProvider.getConfig().getPropertyNames()) {
                for (String prefix : list) {
                    if (!name.startsWith(prefix)) continue;
                    devDebProperties.put(name, (String)ConfigProvider.getConfig().getValue(name, String.class));
                }
            }
            return new DevServicesResultBuildItem.RunningDevService((String)defaultDbKind.get(), datasource.getId(), datasource.getCloseTask(), devDebProperties);
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
    }

    private void setDataSourceProperties(Map<String, String> propertiesMap, String dbName, String propertyKeyRadical, String value) {
        for (String key : DataSourceUtil.dataSourcePropertyKeys((String)dbName, (String)propertyKeyRadical)) {
            propertiesMap.put(key, value);
        }
    }

    private DevServicesDatasourceResultBuildItem.DbResult toDbResult(DevServicesResultBuildItem.RunningDevService devService) {
        if (devService == null) {
            return null;
        }
        return new DevServicesDatasourceResultBuildItem.DbResult(devService.getName(), devService.getConfig());
    }

    static {
        first = true;
    }
}

