/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.common;

import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.dev.devservices.RunningContainer;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerUtil;
import io.quarkus.runtime.LaunchMode;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.testcontainers.DockerClientFactory;

public class ComposeLocator {
    private static final Logger log = Logger.getLogger(ComposeLocator.class);

    public static Optional<ContainerAddress> locateContainer(DevServicesComposeProjectBuildItem composeProject, List<String> images, int port, LaunchMode launchMode, boolean useSharedNetwork) {
        if (launchMode != LaunchMode.NORMAL) {
            return composeProject.locate(images, port).map(runningContainer -> {
                String serviceName = ComposeLocator.getServiceName(runningContainer);
                ContainerAddress containerAddress = new ContainerAddress((RunningContainer)runningContainer, useSharedNetwork ? serviceName : DockerClientFactory.instance().dockerHostIpAddress(), useSharedNetwork ? port : (Integer)runningContainer.getPortMapping(port).orElseThrow(() -> new IllegalStateException("No public port found for " + port)));
                log.infof("Compose Dev Service container found: %s (%s). Connecting to: %s.", (Object)ContainerUtil.getShortId(containerAddress.getId()), (Object)containerAddress.getRunningContainer().containerInfo().imageName(), (Object)containerAddress.getUrl());
                return containerAddress;
            });
        }
        return Optional.empty();
    }

    public static String getServiceName(RunningContainer runningContainer) {
        return (String)runningContainer.containerInfo().labels().get("com.docker.compose.service");
    }

    public static List<RunningContainer> locateContainer(DevServicesComposeProjectBuildItem composeProject, List<String> images, LaunchMode launchMode) {
        if (launchMode != LaunchMode.NORMAL) {
            return composeProject.locate(images);
        }
        return Collections.emptyList();
    }
}

