/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment.compose;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerPort;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public class ComposeServiceWaitStrategyTarget
implements WaitStrategyTarget,
Supplier<InspectContainerResponse> {
    private final Container container;
    private final DockerClient dockerClient;
    private final List<Integer> exposedPorts;
    private final AtomicReference<InspectContainerResponse> containerInfo = new AtomicReference();

    public ComposeServiceWaitStrategyTarget(DockerClient dockerClient, Container container) {
        this.dockerClient = dockerClient;
        this.container = container;
        this.exposedPorts = Arrays.stream(container.getPorts()).filter(port -> port.getPublicPort() != null).map(ContainerPort::getPrivatePort).filter(Objects::nonNull).toList();
    }

    public List<Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    public String getContainerId() {
        return this.container.getId();
    }

    public String getServiceName() {
        return (String)this.container.getLabels().get("com.docker.compose.service");
    }

    public int getContainerNumber() {
        return Integer.parseInt((String)this.container.getLabels().get("com.docker.compose.container-number"));
    }

    public String getContainerName() {
        return String.format("%s-%s", this.getServiceName(), this.getContainerNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InspectContainerResponse getContainerInfo() {
        InspectContainerResponse value = this.containerInfo.get();
        if (value == null) {
            AtomicReference<InspectContainerResponse> atomicReference = this.containerInfo;
            synchronized (atomicReference) {
                value = this.containerInfo.get();
                if (value == null) {
                    value = this.dockerClient.inspectContainerCmd(this.getContainerId()).exec();
                    this.containerInfo.set(value);
                }
            }
        }
        return value;
    }

    @Override
    public InspectContainerResponse get() {
        return this.getContainerInfo();
    }
}

